/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.actions;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.SelectionUtils;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.handlers.HandlerUtil;

public final class NatureConverter
extends AbstractHandler
implements IObjectActionDelegate {
    private static final String NATURE_REMOVAL_TITLE = "TITAN Nature removal";
    private static final String NATURE_REMOVAL_MESSAGE = "Are you sure you wish to remove the TITAN Nature from project ";
    private ISelection selection;

    public void run(IAction action) {
        this.doConvertNature(this.selection);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        this.doConvertNature(this.selection);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConvertNature(ISelection selection) {
        List selectedProjects = SelectionUtils.getProjectsFromSelection((ISelection)selection);
        for (IProject tempProject : selectedProjects) {
            try {
                this.convertNatureOnProject(tempProject);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("Error while processing project: " + tempProject.getName()), (Throwable)e);
            }
            finally {
                Activator.getDefault().resumeHandlingResourceChanges();
            }
        }
    }

    private void convertNatureOnProject(final IProject tempProject) throws CoreException {
        final IProjectDescription description = tempProject.getDescription();
        if (!TITANNature.hasTITANNature(tempProject)) {
            Activator.getDefault().pauseHandlingResourceChanges();
            TITANNature.addTITANNatureToProject(description);
            tempProject.setDescription(description, 1, null);
            tempProject.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "generateMakefile"), "true");
            tempProject.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "TTCN3preprocessor"), "cpp");
            tempProject.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "C/C++ compiler"), "g++");
            tempProject.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "addSourceLineInfo"), "true");
            tempProject.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "workingDir"), "bin");
            ProjectFileHandler pfHandler = new ProjectFileHandler(tempProject);
            WorkspaceJob job = pfHandler.saveProjectSettingsJob();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace((String)"Interrupted", (Throwable)e);
            }
            try {
                tempProject.refreshLocal(2, null);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)"Error while refreshing resources", (Throwable)e);
            }
            Activator.getDefault().resumeHandlingResourceChanges();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn(null, (IAdaptable)tempProject, (String)"org.eclipse.titan.designer.properties.pages.ProjectBuildPropertyPage", null, null);
                    if (dialog != null) {
                        dialog.open();
                    }
                }
            });
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (MessageDialog.openConfirm(null, (String)NatureConverter.NATURE_REMOVAL_TITLE, (String)(NatureConverter.NATURE_REMOVAL_MESSAGE + tempProject.getName() + '?'))) {
                        TITANNature.removeTITANNature(description);
                        try {
                            tempProject.setDescription(description, 1, null);
                        }
                        catch (CoreException e) {
                            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                        }
                    }
                }
            });
        }
    }
}

