/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.map.sorted.mutable.TreeSortedMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.ColorManager;

public final class AstSyntaxHighlightTokens {
    private static Map<String, IntObjectHashMap<EnumSet<SyntaxDecoration>>> offsetMaps = new HashMap<String, IntObjectHashMap<EnumSet<SyntaxDecoration>>>();
    private static Map<String, MutableSortedMap<Integer, Integer>> depthMaps = new HashMap<String, MutableSortedMap<Integer, Integer>>();
    private static final int MAX_BRACKET_COLORS = 8;
    private static List<SyntaxDecoration> bracketcolors = new ArrayList<SyntaxDecoration>(List.of(SyntaxDecoration.Bracket0, SyntaxDecoration.Bracket1, SyntaxDecoration.Bracket2, SyntaxDecoration.Bracket3, SyntaxDecoration.Bracket4, SyntaxDecoration.Bracket5, SyntaxDecoration.Bracket6, SyntaxDecoration.Bracket7));
    private static Map<SyntaxDecoration, IToken> tokenMap = new HashMap<SyntaxDecoration, IToken>();
    private static boolean isUnused;

    public static void updateTokens() {
        IPreferencesService prefs = Platform.getPreferencesService();
        tokenMap.clear();
        boolean isEnabled = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.enableSemanticHighlighting", false, null);
        if (isEnabled) {
            AstSyntaxHighlightTokens.addTokens();
        }
    }

    private static void addTokens() {
        ColorManager colorManager = new ColorManager();
        IPreferencesService prefs = Platform.getPreferencesService();
        boolean isEnabled = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.color.ast_constant.enabled", true, null);
        if (isEnabled) {
            tokenMap.put(SyntaxDecoration.Constant, (IToken)colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.ast_constant"));
        }
        if (isEnabled = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.color.ast_deftype.enabled", true, null)) {
            tokenMap.put(SyntaxDecoration.DefType, (IToken)colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.ast_deftype"));
        }
        if (isEnabled = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.color.ast_deprecated.enabled", true, null)) {
            tokenMap.put(SyntaxDecoration.Deprecated, (IToken)colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.ast_deprecated"));
        }
        if (isEnabled = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.color.ast_variable.enabled", true, null)) {
            tokenMap.put(SyntaxDecoration.Variable, (IToken)colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.ast_variable"));
        }
        if (isEnabled = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.color.ast_unused.enabled", true, null)) {
            tokenMap.put(SyntaxDecoration.Unused, (IToken)colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.ast_unused"));
        }
        tokenMap.put(SyntaxDecoration.Bracket0, (IToken)colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.bracketcolor0"));
        tokenMap.put(SyntaxDecoration.Bracket1, (IToken)colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.bracketcolor1"));
        tokenMap.put(SyntaxDecoration.Bracket2, (IToken)colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.bracketcolor2"));
        tokenMap.put(SyntaxDecoration.Bracket3, (IToken)colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.bracketcolor3"));
        tokenMap.put(SyntaxDecoration.Bracket4, (IToken)colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.bracketcolor4"));
        tokenMap.put(SyntaxDecoration.Bracket5, (IToken)colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.bracketcolor5"));
        tokenMap.put(SyntaxDecoration.Bracket6, (IToken)colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.bracketcolor6"));
        tokenMap.put(SyntaxDecoration.Bracket7, (IToken)colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.bracketcolor7"));
    }

    private AstSyntaxHighlightTokens() {
    }

    public static synchronized IntObjectHashMap<EnumSet<SyntaxDecoration>> getOffsetMap(String moduleName) {
        IntObjectHashMap<EnumSet<SyntaxDecoration>> existingMap = offsetMaps.get(moduleName);
        if (existingMap != null) {
            return existingMap;
        }
        IntObjectHashMap newOffsetMap = new IntObjectHashMap();
        offsetMaps.put(moduleName, (IntObjectHashMap<EnumSet<SyntaxDecoration>>)newOffsetMap);
        return newOffsetMap;
    }

    public static synchronized MutableSortedMap<Integer, Integer> getDepthMap(String moduleName) {
        MutableSortedMap<Integer, Integer> existingMap = depthMaps.get(moduleName);
        if (existingMap != null) {
            return existingMap;
        }
        TreeSortedMap newDepthMap = new TreeSortedMap();
        depthMaps.put(moduleName, (MutableSortedMap<Integer, Integer>)newDepthMap);
        return newDepthMap;
    }

    public static synchronized void setOffsetMap(String module, IntObjectHashMap<EnumSet<SyntaxDecoration>> offsetMap) {
        offsetMaps.put(module, offsetMap);
    }

    public static synchronized void addBracket(String module, IFile actualFile, int offset, int depth) {
        IntObjectHashMap<EnumSet<SyntaxDecoration>> tokens = AstSyntaxHighlightTokens.getOffsetMap(actualFile.getFullPath().toOSString());
        MutableSortedMap<Integer, Integer> depths = AstSyntaxHighlightTokens.getDepthMap(actualFile.getFullPath().toOSString());
        if (depth < 0) {
            tokens.remove(offset);
            depths.remove((Object)offset);
            return;
        }
        tokens.asSynchronized().put(offset, bracketcolors.size() > 0 ? EnumSet.of(bracketcolors.get(depth % 8)) : null);
        depths.asSynchronized().put((Object)offset, (Object)depth);
    }

    public static int getDepthAtOffset(IFile file, int offset) {
        Pair pair;
        MutableSortedMap<Integer, Integer> map = AstSyntaxHighlightTokens.getDepthMap(file.getFullPath().toOSString());
        int depth = 0;
        Iterator iterator = map.keyValuesView().iterator();
        while (iterator.hasNext() && (Integer)(pair = (Pair)iterator.next()).getOne() < offset) {
            depth = (Integer)pair.getTwo();
        }
        return depth;
    }

    public static void addSyntaxDecoration(Location location, SyntaxDecoration decoration) {
        IFile file = (IFile)location.getFile();
        if (file != null) {
            AstSyntaxHighlightTokens.addSyntaxDecoration(file.getFullPath().toOSString(), location.getOffset(), decoration);
        }
    }

    public static void addSyntaxDecoration(String key, int offset, SyntaxDecoration decoration) {
        IntObjectHashMap<EnumSet<SyntaxDecoration>> syntaxMap = AstSyntaxHighlightTokens.getOffsetMap(key);
        if (syntaxMap == null) {
            return;
        }
        EnumSet<SyntaxDecoration> existing = (EnumSet<SyntaxDecoration>)syntaxMap.asSynchronized().get(offset);
        if (existing == null) {
            existing = EnumSet.of(decoration);
        } else {
            existing.add(decoration);
        }
        syntaxMap.asSynchronized().put(offset, existing);
    }

    public static void removeSyntaxDecoration(Location location) {
        IFile file = (IFile)location.getFile();
        if (file != null) {
            AstSyntaxHighlightTokens.removeSyntaxDecoration(file.getFullPath().toOSString(), location.getOffset());
        }
    }

    public static void removeSyntaxDecoration(String key, int offset) {
        IntObjectHashMap<EnumSet<SyntaxDecoration>> syntaxMap = AstSyntaxHighlightTokens.getOffsetMap(key);
        if (syntaxMap == null) {
            return;
        }
        syntaxMap.asSynchronized().remove(offset);
    }

    public static void removeSpecificSyntaxDecoration(Location location, SyntaxDecoration decoration) {
        IFile file = (IFile)location.getFile();
        if (file != null) {
            AstSyntaxHighlightTokens.removeSpecificSyntaxDecoration(file.getFullPath().toOSString(), location.getOffset(), decoration);
        }
    }

    public static void removeSpecificSyntaxDecoration(String key, int offset, SyntaxDecoration decoration) {
        IntObjectHashMap<EnumSet<SyntaxDecoration>> syntaxMap = AstSyntaxHighlightTokens.getOffsetMap(key);
        if (syntaxMap == null || syntaxMap.get(offset) == null) {
            return;
        }
        if (((EnumSet)syntaxMap.get(offset)).contains((Object)decoration)) {
            EnumSet existing = (EnumSet)syntaxMap.asSynchronized().get(offset);
            existing.remove((Object)decoration);
            if (existing.size() > 0) {
                syntaxMap.asSynchronized().put(offset, (Object)existing);
            } else {
                syntaxMap.asSynchronized().remove(offset);
            }
        }
    }

    public static IToken getSyntaxToken(String key, int offset) {
        IntObjectHashMap<EnumSet<SyntaxDecoration>> syntaxMap = AstSyntaxHighlightTokens.getOffsetMap(key);
        if (syntaxMap == null) {
            return null;
        }
        EnumSet existing = (EnumSet)syntaxMap.get(offset);
        if (existing == null) {
            return null;
        }
        if (existing.contains((Object)SyntaxDecoration.Unused) && isUnused) {
            return tokenMap.get((Object)SyntaxDecoration.Unused);
        }
        for (SyntaxDecoration decoration : existing) {
            if (decoration == SyntaxDecoration.Unused) continue;
            return tokenMap.get((Object)decoration);
        }
        return null;
    }

    public static IToken getSyntaxToken(Location location) {
        if (location == null) {
            return null;
        }
        IFile file = (IFile)location.getFile();
        if (file != null) {
            return AstSyntaxHighlightTokens.getSyntaxToken(file.getFullPath().toOSString(), location.getOffset());
        }
        return null;
    }

    public static synchronized void update(String filename, DocumentEvent event) {
        IntObjectHashMap<EnumSet<SyntaxDecoration>> syntaxMap = AstSyntaxHighlightTokens.getOffsetMap(filename);
        if (syntaxMap == null) {
            return;
        }
        int change = event.getText().length() - event.fLength;
        IntObjectHashMap tempMap = new IntObjectHashMap();
        syntaxMap.forEachKeyValue((IntObjectProcedure & Serializable)(key, value) -> {
            if (key < event.fOffset || key > event.fOffset + event.fLength) {
                tempMap.put(key < event.fOffset ? key : key + change, value);
            }
        });
        AstSyntaxHighlightTokens.setOffsetMap(filename, (IntObjectHashMap<EnumSet<SyntaxDecoration>>)tempMap);
    }

    public static boolean isSemanticHighlightingPreferenceChanged(String property) {
        return property.contains("org.eclipse.titan.designer.color.ast_constant") || property.contains("org.eclipse.titan.designer.color.ast_deftype") || property.contains("org.eclipse.titan.designer.color.ast_deprecated") || property.contains("org.eclipse.titan.designer.color.ast_variable") || property.contains("org.eclipse.titan.designer.color.ast_unused");
    }

    static {
        IPreferencesService prefs = Platform.getPreferencesService();
        boolean isSemanticHighlightingEnabled = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.enableSemanticHighlighting", false, null);
        if (isSemanticHighlightingEnabled) {
            AstSyntaxHighlightTokens.addTokens();
        }
        isUnused = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.color.ast_unused.enabled", false, null);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(event -> {
            String property = event.getProperty();
            if ("org.eclipse.titan.designer.color.ast_unused.enabled".equals(property)) {
                isUnused = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.color.ast_unused.enabled", false, null);
            }
        });
    }

    public static enum SyntaxDecoration {
        Constant,
        DefType,
        Deprecated,
        Variable,
        Unused,
        Bracket0,
        Bracket1,
        Bracket2,
        Bracket3,
        Bracket4,
        Bracket5,
        Bracket6,
        Bracket7;

    }
}

