/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor.contentassist;

import java.util.regex.Matcher;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContextInfo;

public class WithAttributeVariantOptionContext
extends ProposalContext {
    public WithAttributeVariantOptionContext(ProposalContextInfo proposalContextInfo) {
        super(proposalContextInfo);
        this.doFallback = false;
    }

    @Override
    public void getProposals(ProposalCollector propCollector) {
        Matcher matcher = this.proposalContextInfo.matcher;
        String attributeKeyword = matcher.group(3);
        String prefix = this.getPrefix();
        int replacementOffset = this.proposalContextInfo.offset - prefix.length();
        int replacementLength = prefix.length();
        switch (attributeKeyword) {
            case "PADDING": 
            case "PREPADDING": {
                WithAttributeVariantOptionContext.addProposal("yes", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                WithAttributeVariantOptionContext.addProposal("no", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                this.addProposalsXBitsOctets(propCollector, prefix, replacementOffset, replacementLength);
                break;
            }
            case "PADDING_PATTERN": {
                this.addItemsByType(null, IType.Type_type.TYPE_BITSTRING, propCollector, prefix, null);
                break;
            }
            case "EXTENSION_BIT": 
            case "EXTENSION_BIT_GROUP": {
                WithAttributeVariantOptionContext.addProposal("yes", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                WithAttributeVariantOptionContext.addProposal("no", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                WithAttributeVariantOptionContext.addProposal("reverse", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                break;
            }
            case "LENGTHTO": {
                break;
            }
            case "POINTERTO": {
                break;
            }
            case "UNIT": 
            case "PTRUNIT": {
                this.addProposalsXBitsOctets(propCollector, prefix, replacementOffset, replacementLength);
                break;
            }
            case "LENGTHINDEX": {
                break;
            }
            case "FIELDLENGTH": {
                this.addProposalsXNumber(propCollector, prefix, replacementOffset, replacementLength);
                break;
            }
            case "PTROFFSET": {
                this.addItemsByType(null, IType.Type_type.TYPE_INTEGER, propCollector, prefix, null);
                break;
            }
            case "ALIGN": {
                WithAttributeVariantOptionContext.addProposal("left", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                WithAttributeVariantOptionContext.addProposal("right", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                break;
            }
            case "COMP": {
                WithAttributeVariantOptionContext.addProposal("unsigned", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                WithAttributeVariantOptionContext.addProposal("2scompl", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                WithAttributeVariantOptionContext.addProposal("signbit", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                break;
            }
            case "BYTEORDER": {
                WithAttributeVariantOptionContext.addProposal("first", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                WithAttributeVariantOptionContext.addProposal("last", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                break;
            }
            case "FIELDORDER": 
            case "BITORDER": 
            case "BITORDERINFIELD": 
            case "BITORDERINOCTET": {
                WithAttributeVariantOptionContext.addProposal("msb", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                WithAttributeVariantOptionContext.addProposal("lsb", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                break;
            }
            case "HEXORDER": {
                WithAttributeVariantOptionContext.addProposal("low", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                WithAttributeVariantOptionContext.addProposal("high", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                break;
            }
            case "REPEATABLE": {
                WithAttributeVariantOptionContext.addProposal("yes", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                WithAttributeVariantOptionContext.addProposal("no", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                break;
            }
            case "TOPLEVEL": {
                WithAttributeVariantOptionContext.addProposal("BITORDER( msb )", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
                WithAttributeVariantOptionContext.addProposal("BITORDER( lsb )", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
            }
        }
    }

    private void addProposalsXBitsOctets(ProposalCollector propCollector, String prefix, int replacementOffset, int replacementLength) {
        WithAttributeVariantOptionContext.addProposal("bit", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
        WithAttributeVariantOptionContext.addProposal("bits", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
        WithAttributeVariantOptionContext.addProposalsXOctets(propCollector, prefix, replacementOffset, replacementLength);
        this.addProposalsXNumber(propCollector, prefix, replacementOffset, replacementLength);
    }

    private static void addProposalsXOctets(ProposalCollector propCollector, String prefix, int replacementOffset, int replacementLength) {
        WithAttributeVariantOptionContext.addProposal("octet", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
        WithAttributeVariantOptionContext.addProposal("octets", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
        WithAttributeVariantOptionContext.addProposal("nibble", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
        WithAttributeVariantOptionContext.addProposal("word16", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
        WithAttributeVariantOptionContext.addProposal("dword32", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
        WithAttributeVariantOptionContext.addProposal("elements", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
    }

    private void addProposalsXNumber(ProposalCollector propCollector, String prefix, int replacementOffset, int replacementLength) {
        WithAttributeVariantOptionContext.addProposal("variable", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
        WithAttributeVariantOptionContext.addProposal("null_terminated", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
        WithAttributeVariantOptionContext.addProposal("IEEE754", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
        WithAttributeVariantOptionContext.addProposal("IEEE754", IType.Type_type.TYPE_UNDEFINED, propCollector, replacementOffset, replacementLength, prefix);
    }
}

