/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.finddefinition;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.finddefinition.StoredDefinitionFilter;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;

public class DefinitionFinder {
    private final StoredDefinitionFilter filter;

    public DefinitionFinder(StoredDefinitionFilter filter) {
        this.filter = filter;
    }

    public List<Object> findDefinitions() {
        if (this.filter.getWorkspaceScope()) {
            return this.getDefinitionsOfWorkspace();
        }
        return this.getDefinitionsOfProject(this.filter.getCurrentProject());
    }

    private List<Object> getDefinitionsOfWorkspace() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (IProject project : GlobalParser.getAllAnalyzedProjects()) {
            result.addAll(this.getDefinitionsOfProject(project));
        }
        return result;
    }

    private List<Object> getDefinitionsOfProject(IProject project) {
        ArrayList<Object> result = new ArrayList<Object>();
        ProjectSourceParser parser = GlobalParser.getProjectSourceParser(project);
        if (this.filter.showOnlyModules()) {
            result.addAll(parser.getModules());
        } else {
            for (Module module : parser.getModules()) {
                if (this.filter.filter(module)) {
                    result.add(module);
                }
                for (Assignment ass : module.getAssignments()) {
                    if (!this.filter.filter(ass)) continue;
                    result.add(ass);
                }
            }
        }
        return result;
    }
}

