/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import java.util.List;
import org.eclipse.titan.common.utils.StringUtils;

public final class BuildLocation
implements Cloneable {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String[] REPLACEMENT_TARGETS = new String[]{"\\", ","};
    private static final String[] REPLACEMENTS = new String[]{"\\\\", "\\,"};
    private boolean active;
    private String name;
    private String command;

    public BuildLocation(boolean active, String name, String command) {
        this.active = active;
        this.name = name;
        this.command = command;
    }

    public BuildLocation(String propertyPart) {
        List temp = StringUtils.intelligentSplit((String)propertyPart, (char)',', (char)'\\');
        if (temp.size() == 3) {
            this.active = TRUE.equals(temp.get(0));
            this.name = (String)temp.get(1);
            this.command = (String)temp.get(2);
        }
    }

    public BuildLocation clone() {
        return new BuildLocation(this.active, this.name, this.command);
    }

    public void configure(boolean active, String name, String command) {
        this.active = active;
        this.name = name;
        this.command = command;
    }

    public boolean getActive() {
        return this.active;
    }

    public String getName() {
        return this.name;
    }

    public String getCommand() {
        return this.command;
    }

    public StringBuilder getPropertyValueRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.active ? TRUE : FALSE).append(',');
        String temp = this.name.replace(REPLACEMENT_TARGETS[0], REPLACEMENTS[0]);
        builder.append(temp.replace(REPLACEMENT_TARGETS[1], REPLACEMENTS[1])).append(',');
        temp = this.command.replace(REPLACEMENT_TARGETS[0], REPLACEMENTS[0]);
        builder.append(temp.replace(REPLACEMENT_TARGETS[1], REPLACEMENTS[1]));
        return builder;
    }
}

