/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.path;

import java.net.URI;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.common.path.PathUtil;
import org.eclipse.titan.common.utils.environment.EnvironmentVariableResolver;

public final class TITANPathUtilities {
    private TITANPathUtilities() {
    }

    public static String resolvePathURIForMakefile(String pathToBeResolved, String basePath, boolean reportDebugInformation, StringBuilder output) {
        URI uri = TITANPathUtilities.resolvePathURI(pathToBeResolved, basePath);
        if (uri == null) {
            return EnvironmentVariableResolver.eclipseStyle().replaceEnvVarsWithUnixEnvVars(pathToBeResolved);
        }
        return PathConverter.convert(URIUtil.toPath((URI)uri).toOSString(), reportDebugInformation, output);
    }

    public static URI resolvePath(String pathToBeResolved, URI basePath) {
        return TITANPathUtilities.resolvePathURI(pathToBeResolved, basePath == null ? null : URIUtil.toPath((URI)basePath).toOSString());
    }

    public static URI resolvePathURI(String pathToBeResolved, String basePath) {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin == null) {
            ErrorReporter.logError("There was an error while resolving `" + pathToBeResolved + "'the DebugPlugin was not yet initialized");
            return URI.create(pathToBeResolved);
        }
        Map envVariables = debugPlugin.getLaunchManager().getNativeEnvironmentCasePreserved();
        IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        return TITANPathUtilities.resolvePathURI(pathToBeResolved, basePath, envVariables, pathVariableManager);
    }

    private static URI resolvePathURI(String pathToBeResolved, String basePath, Map<?, ?> envVariables, IPathVariableManager pathVariableManager) {
        String temp;
        String tmp2 = null;
        try {
            String tmp1 = EnvironmentVariableResolver.eclipseStyle().resolve(pathToBeResolved, envVariables);
            tmp2 = EnvironmentVariableResolver.unixStyle().resolve(tmp1, envVariables);
        }
        catch (EnvironmentVariableResolver.VariableNotFoundException e) {
            ErrorReporter.logWarning("There was an error while resolving `" + pathToBeResolved + "'");
            return null;
        }
        URI uri = URIUtil.toURI((String)tmp2);
        URI resolvedURI = pathVariableManager.resolveURI(uri);
        if (basePath != null && !"".equals(basePath) && uri != null && !resolvedURI.isAbsolute() && (temp = PathUtil.getAbsolutePath(basePath, tmp2)) != null) {
            resolvedURI = URIUtil.toURI((String)temp);
        }
        return resolvedURI;
    }
}

