/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.osgi.filter.impl;

import java.util.Map;
import org.eclipse.cbi.p2repo.osgi.filter.impl.FilterImpl;

class SubstringFilterImpl
extends FilterImpl {
    private final String[] strings;

    SubstringFilterImpl(String attr, String[] value) {
        super(6, attr);
        this.strings = value;
    }

    @Override
    public int compareTo(FilterImpl filter) {
        int cmp = this.internalCompareTo(filter);
        if (cmp != 0) {
            return cmp;
        }
        int top = this.strings.length;
        String[] o_value = ((SubstringFilterImpl)filter).strings;
        if (top > o_value.length) {
            return 1;
        }
        if (top < o_value.length) {
            return -1;
        }
        int idx = 0;
        while (idx < top) {
            String m = this.strings[idx];
            String o = o_value[idx];
            if (m == null) {
                if (o != null) {
                    return -1;
                }
            } else {
                if (o == null) {
                    return 1;
                }
                cmp = m.compareTo(o);
                if (cmp != 0) {
                    return cmp;
                }
            }
            ++idx;
        }
        return 0;
    }

    @Override
    String getValueAsString() {
        StringBuilder bld = new StringBuilder();
        int size = this.strings.length;
        int i = 0;
        while (i < size) {
            String substr = this.strings[i];
            if (substr == null) {
                bld.append('*');
            } else {
                bld.append(substr);
            }
            ++i;
        }
        return bld.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    boolean internalCompare(Object value) {
        if (!(value instanceof String)) {
            return false;
        }
        String string = (String)value;
        int pos = 0;
        int i = 0;
        int size = this.strings.length;
        while (i < size) {
            String substr = this.strings[i];
            if (i + 1 < size) {
                if (substr == null) {
                    String substr2 = this.strings[i + 1];
                    if (substr2 != null) {
                        int index = string.indexOf(substr2, pos);
                        if (index == -1) {
                            return false;
                        }
                        pos = index + substr2.length();
                        if (i + 2 < size) {
                            ++i;
                        }
                    }
                } else {
                    int len = substr.length();
                    if (!string.regionMatches(pos, substr, 0, len)) return false;
                    pos += len;
                }
            } else {
                if (substr != null) return string.endsWith(substr);
                return true;
            }
            ++i;
        }
        return true;
    }

    @Override
    boolean match0(Map<String, ? extends Object> properties) {
        Object prop = properties == null ? null : properties.get(this.getAttr());
        return prop instanceof String ? this.compare(prop) : false;
    }

    @Override
    void toString(StringBuilder sb) {
        sb.append('(');
        sb.append(this.getAttr());
        sb.append('=');
        int i = 0;
        int size = this.strings.length;
        while (i < size) {
            String substr = this.strings[i];
            if (substr == null) {
                sb.append('*');
            } else {
                sb.append(SubstringFilterImpl.encodeValue(substr));
            }
            ++i;
        }
        sb.append(')');
    }
}

