/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.internal.services.WorkbenchServiceRegistry;
import org.eclipse.ui.services.AbstractServiceFactory;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;

public final class ServiceLocator
implements IDisposable,
INestable,
IServiceLocator {
    boolean activated = false;
    private AbstractServiceFactory factory;
    private IServiceLocator parent;
    private boolean disposed;
    private IDisposable owner;
    private IEclipseContext e4Context;
    private Map<Class<?>, Object> servicesToDispose = new HashMap();

    public ServiceLocator() {
        this(null, null, null);
    }

    public ServiceLocator(IServiceLocator parent, AbstractServiceFactory factory, IDisposable owner) {
        this.parent = parent;
        this.factory = factory;
        this.owner = owner;
    }

    @Override
    public final void activate() {
        this.activated = true;
        for (Object service : this.servicesToDispose.values()) {
            if (!(service instanceof INestable)) continue;
            ((INestable)service).activate();
        }
    }

    @Override
    public final void deactivate() {
        this.activated = false;
        for (Object service : this.servicesToDispose.values()) {
            if (!(service instanceof INestable)) continue;
            ((INestable)service).deactivate();
        }
    }

    @Override
    public final void dispose() {
        this.disposeServices();
        if (this.servicesToDispose.size() > 0) {
            this.disposeServices();
            if (this.servicesToDispose.size() > 0) {
                WorkbenchPlugin.log(StatusUtil.newStatus(2, String.format("Services: %s register themselves while disposing (skipping dispose of such services).", this.servicesToDispose), null));
            }
        }
        this.servicesToDispose.clear();
        this.e4Context = null;
        this.disposed = true;
        this.owner = null;
    }

    private void disposeServices() {
        HashMap copy = new HashMap(this.servicesToDispose);
        Set<Map.Entry<Class<?>, Object>> entrySet = copy.entrySet();
        for (Map.Entry<Class<?>, Object> entry : entrySet) {
            if (entry.getValue() instanceof IDisposable) {
                IDisposable iDisposable = (IDisposable)entry.getValue();
                iDisposable.dispose();
            }
            this.servicesToDispose.remove(entry.getKey());
        }
    }

    public final Object getService(Class key) {
        if (this.disposed) {
            return null;
        }
        if (IEclipseContext.class.equals((Object)key)) {
            return this.e4Context;
        }
        Object service = this.e4Context.get(key.getName());
        if (service == null) {
            service = this.servicesToDispose.get(key);
        } else if (service == this.e4Context.getLocal(key.getName())) {
            this.registerService(key, service, false);
        }
        if (service == null) {
            IServiceLocator factoryParent = WorkbenchServiceRegistry.GLOBAL_PARENT;
            if (this.parent != null) {
                factoryParent = new ParentLocator(this.parent, key);
            }
            if (this.factory != null) {
                service = this.factory.create(key, factoryParent, this);
            }
            if (service == null) {
                service = WorkbenchServiceRegistry.getRegistry().getService(key, factoryParent, this);
            }
            if (service == null) {
                service = factoryParent.getService(key);
            } else {
                this.registerService(key, service, true);
            }
        }
        return service;
    }

    public final boolean hasService(Class key) {
        if (this.disposed) {
            return false;
        }
        return this.e4Context.containsKey(key.getName());
    }

    public final void registerService(Class api, Object service) {
        this.registerService(api, service, true);
    }

    private void registerService(Class<?> api, Object service, boolean saveInContext) {
        if (api == null) {
            throw new NullPointerException("The service key cannot be null");
        }
        if (!api.isInstance(service)) {
            throw new IllegalArgumentException("The service does not implement the given interface");
        }
        if (service instanceof INestable && this.activated) {
            ((INestable)service).activate();
        }
        this.servicesToDispose.put(api, service);
        if (saveInContext) {
            this.e4Context.set(api.getName(), service);
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void unregisterServices(String[] serviceNames) {
        if (this.owner != null) {
            this.owner.dispose();
        }
    }

    public void setContext(IEclipseContext context) {
        this.e4Context = context;
    }

    public IEclipseContext getContext() {
        return this.e4Context;
    }

    private static class ParentLocator
    implements IServiceLocator {
        private IServiceLocator locator;
        private Class key;

        public ParentLocator(IServiceLocator parent, Class serviceInterface) {
            this.locator = parent;
            this.key = serviceInterface;
        }

        public Object getService(Class api) {
            if (this.key.equals(api)) {
                return this.locator.getService(this.key);
            }
            return null;
        }

        public boolean hasService(Class api) {
            return this.key.equals(api);
        }
    }
}

