/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressBar
extends Control {
    int timerId;
    int minimum = 0;
    int maximum = 100;
    int selection = 0;
    static final int DELAY = 100;

    public ProgressBar(Composite parent, int style) {
        super(parent, ProgressBar.checkStyle(style));
    }

    static int checkStyle(int style) {
        return ProgressBar.checkBits(style |= 0x80000, 256, 512, 0, 0, 0, 0);
    }

    @Override
    void createHandle(int index) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_progress_bar_new();
        if (this.handle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        int orientation = (this.style & 0x200) != 0 ? 2 : 0;
        this.gtk_orientable_set_orientation(this.handle, orientation);
        if ((this.style & 2) != 0) {
            this.timerId = OS.g_timeout_add(100, this.display.windowTimerProc, this.handle);
        }
    }

    @Override
    int eventHandle() {
        return OS.GTK3 ? this.fixedHandle : super.eventHandle();
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public int getState() {
        this.checkWidget();
        return 0;
    }

    @Override
    int gtk_realize(int widget) {
        int result = super.gtk_realize(widget);
        if (result != 0) {
            return result;
        }
        this.updateBar(this.selection, this.minimum, this.maximum);
        return 0;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.timerId != 0) {
            OS.g_source_remove(this.timerId);
        }
        this.timerId = 0;
    }

    @Override
    void setParentBackground() {
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value <= this.minimum) {
            return;
        }
        this.maximum = value;
        this.selection = Math.min(this.selection, this.maximum);
        this.updateBar(this.selection, this.minimum, this.maximum);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0 || value >= this.maximum) {
            return;
        }
        this.minimum = value;
        this.selection = Math.max(this.selection, this.minimum);
        this.updateBar(this.selection, this.minimum, this.maximum);
    }

    public void setSelection(int value) {
        this.checkWidget();
        this.selection = Math.max(this.minimum, Math.min(this.maximum, value));
        this.updateBar(this.selection, this.minimum, this.maximum);
    }

    public void setState(int state) {
        this.checkWidget();
    }

    @Override
    int timerProc(int widget) {
        if (this.isVisible()) {
            OS.gtk_progress_bar_pulse(this.handle);
        }
        return 1;
    }

    void updateBar(int selection, int minimum, int maximum) {
        if (!this.gtk_widget_get_realized(this.handle)) {
            return;
        }
        double fraction = minimum == maximum ? 1.0 : (double)(selection - minimum) / (double)(maximum - minimum);
        OS.gtk_progress_bar_set_fraction(this.handle, fraction);
        if (!OS.GTK3) {
            int window = this.paintWindow();
            OS.gdk_window_process_updates(window, false);
            OS.gdk_flush();
        }
    }

    void gtk_orientable_set_orientation(int pbar, int orientation) {
        if (OS.GTK3) {
            switch (orientation) {
                case 2: {
                    OS.gtk_orientable_set_orientation(pbar, 1);
                    OS.gtk_progress_bar_set_inverted(pbar, true);
                    break;
                }
                case 0: {
                    OS.gtk_orientable_set_orientation(pbar, 0);
                    OS.gtk_progress_bar_set_inverted(pbar, false);
                }
            }
        } else {
            OS.gtk_progress_bar_set_orientation(pbar, orientation);
        }
    }
}

