/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.presentation;

import java.util.List;
import org.eclipse.cbi.p2repo.aggregator.util.VerificationDiagnostic;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;

class AggregatorMarkerHelper
extends EditUIMarkerHelper {
    AggregatorMarkerHelper() {
    }

    protected void adjustMarker(IMarker marker, Diagnostic diagnostic, Diagnostic parentDiagnostic) throws CoreException {
        List data = diagnostic.getData();
        StringBuilder relatedURIs = new StringBuilder();
        boolean first = true;
        for (Object object : data) {
            String uriString = null;
            if (object instanceof Resource.Diagnostic) {
                uriString = ((Resource.Diagnostic)object).getLocation();
                if (object instanceof VerificationDiagnostic) {
                    marker.setAttribute("p2.verification.error.type", (Object)object.getClass().getName());
                    if (object instanceof VerificationDiagnostic.Singleton) {
                        marker.setAttribute("p2.verification.root.problem", (Object)((VerificationDiagnostic.Singleton)object).getRootProblem());
                        marker.setAttribute("p2.verification.related.diagnostics", (Object)((VerificationDiagnostic.Singleton)object).getRelatedDiagnostics());
                    }
                }
            } else {
                URI uri = null;
                if (object instanceof EObject) {
                    uri = EcoreUtil.getURI((EObject)((EObject)object));
                } else if (object instanceof Resource) {
                    uri = ((Resource)object).getURI();
                }
                if (uri != null) {
                    uriString = uri.toString();
                }
            }
            if (uriString == null) continue;
            if (first) {
                first = false;
                marker.setAttribute("uri", (Object)uriString);
                continue;
            }
            if (relatedURIs.length() != 0) {
                relatedURIs.append(' ');
            }
            relatedURIs.append(URI.encodeFragment((String)uriString, (boolean)false));
        }
        if (relatedURIs.length() > 0) {
            marker.setAttribute("relatedURIs", (Object)relatedURIs.toString());
        }
    }

    public void createMarkers(Resource markerResource, Diagnostic diagnostic) throws CoreException {
        block5: {
            block4: {
                if (!diagnostic.getChildren().isEmpty()) break block4;
                if (diagnostic.getSeverity() == 0) break block5;
                this.createMarkers((IResource)this.getFile(markerResource), diagnostic, null);
                break block5;
            }
            if (diagnostic.getMessage() == null) {
                for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                    this.createMarkers(markerResource, childDiagnostic);
                }
            } else {
                for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                    this.createMarkers((IResource)this.getFile(markerResource), childDiagnostic, diagnostic);
                }
            }
        }
    }

    protected String getMarkerID() {
        return "org.eclipse.cbi.p2repo.aggregator.editor.diagnostic.nonpersistent";
    }
}

