/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.initialization;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.core.IRSEInitListener;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.tests.RSETestsPlugin;
import org.eclipse.rse.tests.initialization.BadInitializer;
import org.eclipse.rse.tests.initialization.GoodInitializer;
import org.eclipse.rse.tests.initialization.InitListener;
import org.eclipse.rse.tests.initialization.ListenerInitializer;
import org.eclipse.rse.tests.initialization.UglyInitializer;

public class InitializationTest
extends TestCase {
    public InitializationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        RSECorePlugin.addInitListener((IRSEInitListener)new IRSEInitListener(){

            public void phaseComplete(int phase) {
                System.out.println("I see phase " + phase);
            }
        });
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testInitialization() {
        if (!RSETestsPlugin.isTestCaseEnabled("InitializationTest.testInitialization")) {
            return;
        }
        try {
            IStatus status = null;
            status = RSECorePlugin.waitForInitCompletion((int)1);
            InitializationTest.assertEquals((Object)Status.OK_STATUS, (Object)status);
            status = RSECorePlugin.waitForInitCompletion((int)2);
            InitializationTest.assertEquals((int)2, (int)status.getSeverity());
            status = RSECorePlugin.waitForInitCompletion((int)0);
            InitializationTest.assertEquals((int)2, (int)status.getSeverity());
            status = RSECorePlugin.waitForInitCompletion();
            InitializationTest.assertEquals((int)2, (int)status.getSeverity());
        }
        catch (InterruptedException interruptedException) {
            InitializationTest.fail((String)"interrupted");
        }
        catch (RuntimeException e) {
            throw e;
        }
        System.out.println("Init job should be done");
        InitializationTest.assertTrue((String)"not indicating complete", (boolean)RSECorePlugin.isInitComplete((int)0));
        GoodInitializer goodInitializer = GoodInitializer.getInstance();
        BadInitializer badInitializer = BadInitializer.getInstance();
        UglyInitializer uglyInitializer = UglyInitializer.getInstance();
        ListenerInitializer listenerInitializer = ListenerInitializer.getInstance();
        InitializationTest.assertTrue((String)"good initializer not run", (boolean)goodInitializer.wasRun());
        InitializationTest.assertTrue((String)"bad initializer not run", (boolean)badInitializer.wasRun());
        InitializationTest.assertTrue((String)"ugly initializer not run", (boolean)uglyInitializer.wasRun());
        InitializationTest.assertTrue((String)"listener initializer not run", (boolean)listenerInitializer.wasRun());
        InitListener listener = listenerInitializer.getListener();
        InitializationTest.assertFalse((String)"listener saw phase INIT_MODEL", (boolean)listener.sawPhase(1));
        InitializationTest.assertTrue((String)"listener missed phase INIT_ALL", (boolean)listener.sawPhase(0));
    }
}

