/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.synchronize;

import java.lang.reflect.Method;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.rse.internal.importexport.files.Utilities;
import org.eclipse.rse.internal.synchronize.ISynchronizeData;
import org.eclipse.rse.internal.synchronize.SynchronizeData;
import org.eclipse.rse.internal.synchronize.provisional.ISynchronizeOperation;
import org.eclipse.rse.internal.synchronize.provisional.SynchronizeConnectionManager;
import org.eclipse.rse.internal.synchronize.provisional.SynchronizeOperation;
import org.eclipse.rse.internal.synchronize.provisional.Synchronizer;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.tests.synchronize.SynchronizeTestBase;

public class RSESynchronizeTest
extends SynchronizeTestBase {
    static /* synthetic */ Class class$0;

    public RSESynchronizeTest(String name) {
        super(name);
    }

    public RSESynchronizeTest(String name, String propertiesFileName) {
        super(name, propertiesFileName);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.tests.synchronize.RSESynchronizeTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String baseName = clazz.getName();
        TestSuite suite = new TestSuite(baseName);
        String[] connTypes = new String[]{"local"};
        int i = 0;
        while (i < connTypes.length) {
            String suiteName = connTypes[i] == null ? "EFS" : connTypes[i];
            String propFileName = connTypes[i] == null ? null : String.valueOf(connTypes[i]) + "Connection.properties";
            TestSuite subSuite = new TestSuite(String.valueOf(baseName) + "." + suiteName);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.rse.tests.synchronize.RSESynchronizeTest");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method[] m = clazz2.getMethods();
            int j = 0;
            while (j < m.length) {
                String testName = m[j].getName();
                if (testName.startsWith("test")) {
                    subSuite.addTest((Test)new RSESynchronizeTest(testName, propFileName));
                }
                ++j;
            }
            suite.addTest((Test)subSuite);
            ++i;
        }
        return suite;
    }

    public void testConnectDisconnect() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        IProject project = RSESynchronizeTest.getProject(this.getUniqueString());
        IResource[] resources = new IResource[]{project};
        this.ensureExistsInWorkspace(resources, true);
        SynchronizeConnectionManager connection = new SynchronizeConnectionManager();
        RSESynchronizeTest.assertTrue((String)"1.1", (!connection.isConnected(project) ? 1 : 0) != 0);
        connection.connect(project);
        RSESynchronizeTest.assertTrue((String)"1.2", (boolean)connection.isConnected(project));
        connection.disconnect(project);
        RSESynchronizeTest.assertTrue((String)"1.3", (!connection.isConnected(project) ? 1 : 0) != 0);
        this.ensureDoesNotExistInWorkspace((IResource)project);
        RSESynchronizeTest.assertTrue((String)"2.1", (!connection.isConnected(project) ? 1 : 0) != 0);
    }

    public void testExport() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        IProject project = RSESynchronizeTest.getProject(this.getUniqueString());
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IFile subFile2 = folder.getFile("subfile2.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile, subFile2};
        this.ensureExistsInWorkspace(resources, true);
        SynchronizeData sd = new SynchronizeData();
        IResource[] resourcesToSync = new IResource[]{folder, subFile};
        sd.setElements(Arrays.asList(resourcesToSync));
        String remoteLocation = Utilities.getAsString((IRemoteFile)this.remoteTempDir);
        sd.setRemoteLocation(remoteLocation);
        sd.setSynchronizeType(2);
        Synchronizer synchronizer = new Synchronizer((ISynchronizeData)sd);
        synchronizer.run((ISynchronizeOperation)new SynchronizeOperation());
        IRemoteFile rProject = this.fss.getRemoteFileObject(this.remoteTempDir, project.getName(), this.getDefaultProgressMonitor());
        RSESynchronizeTest.assertTrue((String)"1.0", (boolean)rProject.exists());
        IRemoteFile rFolder = this.fss.getRemoteFileObject(rProject, "folder", this.getDefaultProgressMonitor());
        RSESynchronizeTest.assertTrue((String)"1.1", (boolean)rFolder.exists());
        RSESynchronizeTest.assertTrue((String)"1.2", (boolean)rFolder.isDirectory());
        IRemoteFile rFile = this.fss.getRemoteFileObject(rProject, "file.txt", this.getDefaultProgressMonitor());
        RSESynchronizeTest.assertFalse((String)"2.1", (boolean)rFile.exists());
        IRemoteFile rSubFile = this.fss.getRemoteFileObject(rFolder, "subfile.txt", this.getDefaultProgressMonitor());
        RSESynchronizeTest.assertTrue((String)"3.1", (boolean)rSubFile.exists());
        RSESynchronizeTest.assertTrue((String)"3.2", (boolean)rSubFile.isFile());
    }
}

