/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.shells.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.internal.shells.ui.ShellResources;
import org.eclipse.rse.internal.shells.ui.actions.SystemBaseShellAction;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.swt.widgets.Shell;

public class SystemTerminateShellAction
extends SystemBaseShellAction {
    public SystemTerminateShellAction(Shell parent) {
        this(ShellResources.ACTION_CANCEL_SHELL_LABEL, ShellResources.ACTION_CANCEL_SHELL_TOOLTIP, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemcancelIcon"), parent);
    }

    public SystemTerminateShellAction(String label, String tooltip, ImageDescriptor image, Shell parent) {
        super(label, tooltip, image, parent);
    }

    public void run() {
        ArrayList selected = new ArrayList();
        selected.addAll(this._selected);
        int i = selected.size() - 1;
        while (i >= 0) {
            IRemoteCommandShell cmdShell = (IRemoteCommandShell)selected.get(i);
            this.terminateShell(cmdShell);
            --i;
        }
    }

    protected boolean isApplicable(IRemoteCommandShell cmdShell) {
        return cmdShell.isActive();
    }

    protected void terminateShell(IRemoteCommandShell command) {
        this.cancel(command);
    }

    public void cancel(IRemoteCommandShell command) {
        try {
            IRemoteCmdSubSystem cmdSubSystem = command.getCommandSubSystem();
            if (cmdSubSystem != null) {
                cmdSubSystem.cancelShell((Object)command, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception exception) {}
    }
}

