/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.csv;

import java.io.IOException;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.csv.CSVPackageHandler;
import org.jacoco.report.csv.ClassRowWriter;

class CSVGroupHandler
implements IReportVisitor {
    private final ClassRowWriter writer;
    private final String groupName;

    public CSVGroupHandler(ClassRowWriter writer, String groupName) {
        this.writer = writer;
        this.groupName = groupName;
    }

    public IReportVisitor visitChild(ICoverageNode node) throws IOException {
        ICoverageNode.ElementType type = node.getElementType();
        switch (type) {
            case PACKAGE: {
                return new CSVPackageHandler(this.writer, this.groupName, node.getName());
            }
            case GROUP: 
            case BUNDLE: {
                return new CSVGroupHandler(this.writer, this.groupName + "/" + node.getName());
            }
        }
        throw new AssertionError((Object)String.format("Unexpected child node %s.", new Object[]{type}));
    }

    public void visitEnd(ISourceFileLocator sourceFileLocator) throws IOException {
    }
}

