/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.terminals.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.internal.terminals.ui.Activator;
import org.eclipse.rse.internal.terminals.ui.TerminalUIResources;
import org.eclipse.rse.internal.terminals.ui.actions.RemoveTerminalAction;
import org.eclipse.rse.internal.terminals.ui.actions.ShowInTerminalViewAction;
import org.eclipse.rse.services.terminals.ITerminalShell;
import org.eclipse.rse.subsystems.terminals.core.ITerminalServiceSubSystemConfiguration;
import org.eclipse.rse.subsystems.terminals.core.elements.TerminalElement;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class TerminalViewElementAdapter
extends AbstractSystemViewAdapter
implements ISystemRemoteElementAdapter {
    private List actions = new ArrayList();
    private ShowInTerminalViewAction showInTerminalViewAction;
    private RemoveTerminalAction closeTerminalAction;

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell parent, String menuGroup) {
        Object firstSelection = selection.getFirstElement();
        if (firstSelection != null) {
            if (firstSelection instanceof TerminalElement) {
                TerminalElement cmdShell = (TerminalElement)firstSelection;
                if (this.showInTerminalViewAction == null) {
                    this.showInTerminalViewAction = new ShowInTerminalViewAction(this.getShell());
                }
                menu.add("group.open", (IAction)this.showInTerminalViewAction);
                this.getTerminalActions((ITerminalServiceSubSystemConfiguration)cmdShell.getSubSystem().getSubSystemConfiguration());
                menu.add("group.change", (IAction)this.closeTerminalAction);
            }
        } else {
            return;
        }
    }

    public List getTerminalActions(ITerminalServiceSubSystemConfiguration factory) {
        this.actions.clear();
        if (this.actions.size() == 0) {
            if (this.closeTerminalAction == null) {
                this.closeTerminalAction = new RemoveTerminalAction(this.getShell());
            }
            this.actions.add(this.closeTerminalAction);
        }
        return this.actions;
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        TerminalElement terminalElement;
        ITerminalShell terminalShell;
        if (element instanceof TerminalElement && (terminalShell = (terminalElement = (TerminalElement)element).getTerminalShell()) != null && terminalShell.isActive()) {
            return Activator.getDefault().getImageDescriptor(Activator.ICON_ID_TERMINAL_SUBSYSTEM_LIVE);
        }
        return Activator.getDefault().getImageDescriptor(Activator.ICON_ID_TERMINAL_SUBSYSTEM);
    }

    public Object getParent(Object element) {
        return null;
    }

    public String getType(Object element) {
        return TerminalUIResources.TerminalViewElementAdapter_type;
    }

    public boolean hasChildren(IAdaptable element) {
        return false;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        return null;
    }

    protected Object internalGetPropertyValue(Object key) {
        return null;
    }

    public String getAbsoluteParentName(Object element) {
        return null;
    }

    public Object getRemoteParent(Object element, IProgressMonitor monitor) throws Exception {
        return null;
    }

    public String[] getRemoteParentNamesInUse(Object element, IProgressMonitor monitor) throws Exception {
        return null;
    }

    public boolean refreshRemoteObject(Object oldElement, Object newElement) {
        return false;
    }

    public String getRemoteSubType(Object element) {
        return null;
    }

    public String getRemoteType(Object element) {
        return null;
    }

    public String getRemoteTypeCategory(Object element) {
        return null;
    }

    public String getSubSystemConfigurationId(Object element) {
        return null;
    }

    public String getText(Object element) {
        return element.toString();
    }

    public String getAbsoluteName(Object object) {
        return object.toString();
    }
}

