/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.synchronize.filesystem;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.eclipse.rse.internal.synchronize.filesystem.FileSystemPlugin;
import org.eclipse.rse.internal.synchronize.filesystem.FileSystemProvider;
import org.eclipse.rse.internal.synchronize.filesystem.Policy;
import org.eclipse.rse.internal.synchronize.filesystem.subscriber.FileSystemResourceVariant;
import org.eclipse.rse.internal.synchronize.filesystem.subscriber.FileSystemSubscriber;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.core.variants.ThreeWaySynchronizer;
import org.eclipse.ui.dialogs.ContainerGenerator;

public class FileSystemOperations {
    FileSystemOperations(FileSystemProvider provider) {
    }

    private FileSystemProvider getProvider(IResource resource) {
        return (FileSystemProvider)RepositoryProvider.getProvider((IProject)resource.getProject());
    }

    public void get(IResource[] resources, int depth, boolean overrideOutgoing, IProgressMonitor progress) throws TeamException {
        try {
            progress = Policy.monitorFor(progress);
            progress.beginTask(Policy.bind("GetAction.working"), 100);
            FileSystemSubscriber.getInstance().refresh(resources, depth, (IProgressMonitor)new SubProgressMonitor(progress, 30));
            this.internalGet(resources, depth, overrideOutgoing, (IProgressMonitor)new SubProgressMonitor(progress, 70));
        }
        finally {
            progress.done();
        }
    }

    public void get(ResourceTraversal[] traversals, boolean overrideOutgoing, IProgressMonitor monitor) throws TeamException {
        try {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(null, 100 * traversals.length);
            int i = 0;
            while (i < traversals.length) {
                ResourceTraversal traversal = traversals[i];
                this.get(traversal.getResources(), traversal.getDepth(), overrideOutgoing, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public void checkout(IResource[] resources, int depth, IProgressMonitor progress) throws TeamException {
        try {
            try {
                progress = Policy.monitorFor(progress);
                progress.beginTask(Policy.bind("FileSystemSimpleAccessOperations.1"), resources.length);
                int i = 0;
                while (i < resources.length) {
                    Policy.checkCanceled(progress);
                    resources[i].accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (resource.getType() == 1) {
                                resource.getResourceAttributes().setReadOnly(false);
                            }
                            return true;
                        }
                    }, depth, false);
                    progress.worked(1);
                    ++i;
                }
            }
            catch (CoreException e) {
                throw TeamException.asTeamException((CoreException)e);
            }
        }
        finally {
            progress.done();
        }
    }

    public void checkin(IResource[] resources, int depth, boolean overrideIncoming, IProgressMonitor progress) throws TeamException {
        try {
            progress = Policy.monitorFor(progress);
            progress.beginTask(Policy.bind("PutAction.working"), 100);
            FileSystemSubscriber.getInstance().refresh(resources, depth, (IProgressMonitor)new SubProgressMonitor(progress, 30));
            this.internalPut(resources, depth, overrideIncoming, (IProgressMonitor)new SubProgressMonitor(progress, 70));
        }
        finally {
            progress.done();
        }
    }

    public void checkin(ResourceTraversal[] traversals, boolean overrideIncoming, IProgressMonitor monitor) throws TeamException {
        try {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(null, 100 * traversals.length);
            int i = 0;
            while (i < traversals.length) {
                ResourceTraversal traversal = traversals[i];
                this.checkin(traversal.getResources(), traversal.getDepth(), overrideIncoming, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                FileSystemSubscriber.getInstance().refresh(traversal.getResources(), traversal.getDepth(), null);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean isCheckedOut(IResource resource) {
        if (resource.getType() != 1) {
            return true;
        }
        return !resource.getResourceAttributes().isReadOnly();
    }

    private FileSystemResourceVariant getExportResourceVariant(IResource resource) {
        return (FileSystemResourceVariant)this.getProvider(resource).getExportResourceVariant(resource);
    }

    private FileSystemResourceVariant getImportResourceVariant(IResource resource) {
        return (FileSystemResourceVariant)this.getProvider(resource).getImportResourcevariant(resource);
    }

    private void internalGet(IResource[] resources, int depth, boolean overrideOutgoing, IProgressMonitor progress) throws TeamException {
        progress.beginTask(Policy.bind("GetAction.working"), -1);
        int i = 0;
        while (i < resources.length) {
            Policy.checkCanceled(progress);
            if (resources[i].getType() == 1) {
                this.internalGet((IFile)resources[i], overrideOutgoing, progress);
            } else if (depth != 0) {
                this.internalGet((IContainer)resources[i], depth, overrideOutgoing, progress);
            }
            progress.worked(1);
            ++i;
        }
    }

    private void internalGet(IContainer container, int depth, boolean overrideOutgoing, IProgressMonitor progress) throws TeamException {
        try {
            IResource[] children;
            ThreeWaySynchronizer synchronizer = FileSystemSubscriber.getInstance().getSynchronizer();
            ArrayList<IFolder> toDelete = new ArrayList<IFolder>();
            if (container.getType() == 2) {
                IFolder folder = (IFolder)container;
                FileSystemResourceVariant remote = this.getImportResourceVariant((IResource)container);
                if (!folder.exists() && remote != null) {
                    folder.create(true, true, progress);
                    folder.getResourceAttributes().setReadOnly(false);
                    synchronizer.setBaseBytes((IResource)folder, remote.asBytes());
                } else if (folder.exists() && remote == null) {
                    toDelete.add(folder);
                }
            }
            if ((children = synchronizer.members((IResource)container)).length > 0) {
                this.internalGet(children, depth == 2 ? 2 : 0, overrideOutgoing, progress);
            }
            for (IFolder folder : toDelete) {
                if (folder.members().length != 0) continue;
                folder.delete(false, true, progress);
                synchronizer.flush((IResource)folder, 2);
            }
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void internalGet(IFile localFile, boolean overrideOutgoing, IProgressMonitor progress) throws TeamException {
        ThreeWaySynchronizer synchronizer = FileSystemSubscriber.getInstance().getSynchronizer();
        IResourceVariantComparator comparator = FileSystemSubscriber.getInstance().getResourceComparator();
        FileSystemResourceVariant remote = this.getImportResourceVariant((IResource)localFile);
        byte[] baseBytes = synchronizer.getBaseBytes((IResource)localFile);
        FileSystemProvider provider = this.getProvider((IResource)localFile);
        IResourceVariant base = provider.getResourceVariant((IResource)localFile, baseBytes);
        if (base != null && remote == null) {
            try {
                localFile.delete(false, true, progress);
                synchronizer.flush((IResource)localFile, 0);
                return;
            }
            catch (CoreException e) {
                throw TeamException.asTeamException((CoreException)e);
            }
        }
        if (!synchronizer.isLocallyModified((IResource)localFile) && base != null && remote != null && comparator.compare(base, (IResourceVariant)remote)) {
            return;
        }
        try {
            UniFilePlus remoteFile = (UniFilePlus)provider.getImportFile((IResource)localFile);
            if (!remoteFile.exists()) {
                localFile.delete(true, null);
                synchronizer.flush((IResource)localFile, 0);
            } else {
                if (localFile.exists()) {
                    localFile.delete(true, null);
                }
                try {
                    this.createParentFolderRecursively((IResource)localFile);
                    remoteFile.getRemoteFile().getParentRemoteFileSubSystem().download(remoteFile.getRemoteFile(), localFile.getLocation().toOSString(), localFile.getCharset(), progress);
                    if (localFile.isAccessible()) {
                        localFile.getResourceAttributes().setReadOnly(true);
                    }
                    localFile.getParent().refreshLocal(1, progress);
                    synchronizer.setBaseBytes((IResource)localFile, remote.asBytes());
                    SystemIFileProperties properties = new SystemIFileProperties((IResource)localFile);
                    properties.setRemoteFileTimeStamp(remoteFile.lastModified());
                    properties.setDownloadFileTimeStamp(localFile.getLocalTimeStamp());
                }
                catch (SystemMessageException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (CoreException e) {
            throw FileSystemPlugin.wrapException(e);
        }
    }

    private void internalPut(IResource[] resources, int depth, boolean overrideIncoming, IProgressMonitor progress) throws TeamException {
        try {
            progress = Policy.monitorFor(progress);
            progress.beginTask(Policy.bind("PutAction.working"), -1);
            int i = 0;
            while (i < resources.length) {
                Policy.checkCanceled(progress);
                if (resources[i].getType() == 1) {
                    this.internalPut((IFile)resources[i], overrideIncoming, progress);
                } else if (depth > 0) {
                    this.internalPut((IContainer)resources[i], depth, overrideIncoming, progress);
                }
                progress.worked(1);
                ++i;
            }
            progress.done();
        }
        catch (TeamException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean internalPut(IFile localFile, boolean overrideIncoming, IProgressMonitor progress) throws TeamException {
        ThreeWaySynchronizer synchronizer = FileSystemSubscriber.getInstance().getSynchronizer();
        IResourceVariantComparator comparator = FileSystemSubscriber.getInstance().getResourceComparator();
        FileSystemResourceVariant remote = this.getExportResourceVariant((IResource)localFile);
        byte[] baseBytes = synchronizer.getBaseBytes((IResource)localFile);
        FileSystemProvider provider = this.getProvider((IResource)localFile);
        IResourceVariant base = provider.getResourceVariant((IResource)localFile, baseBytes);
        overrideIncoming = true;
        if (base == null && remote != null && !overrideIncoming) {
            return false;
        }
        if (base != null && remote == null) {
            if (!localFile.exists()) {
                synchronizer.flush((IResource)localFile, 0);
            } else if (!overrideIncoming) {
                return false;
            }
        } else if (base != null && remote != null) {
            boolean same = comparator.compare(base, (IResourceVariant)remote);
            if (!this.isLocallyModified(localFile) && same) {
                return true;
            }
            if (!same && !overrideIncoming) {
                return false;
            }
        }
        UniFilePlus remoteFile = (UniFilePlus)provider.getExportFile((IResource)localFile);
        if (!localFile.exists()) {
            remoteFile.delete();
            synchronizer.flush((IResource)localFile, 0);
        } else {
            try {
                try {
                    if (!remoteFile.getParentFile().exists()) {
                        remoteFile.getParentFile().mkdirs();
                    }
                    remoteFile.getRemoteFile().getParentRemoteFileSubSystem().upload(localFile.getLocation().toOSString(), remoteFile.getRemoteFile(), localFile.getCharset(), progress);
                    localFile.getResourceAttributes().setReadOnly(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                remote = this.getExportResourceVariant((IResource)localFile);
                synchronizer.setBaseBytes((IResource)localFile, remote.asBytes());
                remoteFile.getRemoteFile().markStale(true);
                IRemoteFile updatedRemoteFile = remoteFile.getRemoteFile().getParentRemoteFileSubSystem().getRemoteFileObject(remoteFile.getRemoteFile().getAbsolutePath(), progress);
                SystemIFileProperties properties = new SystemIFileProperties((IResource)localFile);
                properties.setRemoteFileTimeStamp(updatedRemoteFile.getLastModified());
                properties.setDownloadFileTimeStamp(localFile.getLocalTimeStamp());
            }
            catch (CoreException e) {
                throw FileSystemPlugin.wrapException(e);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private boolean isLocallyModified(IFile localFile) throws TeamException {
        ThreeWaySynchronizer synchronizer = FileSystemSubscriber.getInstance().getSynchronizer();
        if (!localFile.exists()) {
            return synchronizer.getBaseBytes((IResource)localFile) != null;
        }
        return synchronizer.isLocallyModified((IResource)localFile);
    }

    private void internalPut(IContainer container, int depth, boolean overrideIncoming, IProgressMonitor progress) throws TeamException {
        try {
            ThreeWaySynchronizer synchronizer = FileSystemSubscriber.getInstance().getSynchronizer();
            FileSystemProvider provider = this.getProvider((IResource)container);
            ArrayList<UniFilePlus> toDelete = new ArrayList<UniFilePlus>();
            if (container.getType() == 2) {
                IFolder folder = (IFolder)container;
                UniFilePlus diskFile = (UniFilePlus)provider.getExportFile((IResource)container);
                FileSystemResourceVariant fileSystemResourceVariant = this.getExportResourceVariant((IResource)container);
                if (!folder.exists() && fileSystemResourceVariant != null) {
                    toDelete.add(diskFile);
                } else if (folder.exists() && fileSystemResourceVariant == null) {
                    diskFile.mkdirs();
                    IResourceVariant variant = provider.getExportResourceVariant((IResource)folder);
                    if (variant != null) {
                        synchronizer.setBaseBytes((IResource)folder, variant.asBytes());
                    }
                }
            } else if (container.getType() == 4) {
                IProject project = (IProject)container;
                UniFilePlus remoteProjectFolder = (UniFilePlus)provider.getExportFile((IResource)project);
                FileSystemResourceVariant fileSystemResourceVariant = this.getExportResourceVariant((IResource)container);
                if (project.exists() && fileSystemResourceVariant == null) {
                    remoteProjectFolder.mkdir();
                    synchronizer.setBaseBytes((IResource)project, provider.getExportResourceVariant((IResource)project).asBytes());
                }
            }
            IResource[] children = synchronizer.members((IResource)container);
            if (children.length > 0) {
                this.internalPut(children, depth == 2 ? 2 : 0, overrideIncoming, progress);
            }
            for (File file : toDelete) {
                if (file.listFiles().length != 0) continue;
                file.delete();
                synchronizer.flush((IResource)container, 2);
            }
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createParentFolderRecursively(IResource resource) throws CoreException {
        if (!resource.getParent().exists()) {
            ContainerGenerator generator = new ContainerGenerator(resource.getParent().getFullPath());
            IContainer parent = generator.generateContainer(null);
            this.createParentFolderRecursively((IResource)parent);
        }
    }
}

