/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.extra;

import java.util.List;
import org.eclipse.dstore.extra.IDataElement;
import org.eclipse.dstore.extra.IDomainNotifier;

public class DomainEvent {
    public static final int UNKNOWN = 0;
    public static final int INSERT = 1;
    public static final int REMOVE = 2;
    public static final int STRUCTURE_CHANGE = 3;
    public static final int NON_STRUCTURE_CHANGE = 4;
    public static final int FILE_CHANGE = 5;
    public static final int FIRST_CUSTOM_CHANGE = 10;
    public static final int LAST_CUSTOM_CHANGE = 255;
    public static final int MASK = 255;
    public static final int REVEAL = 256;
    public static final int SELECT = 512;
    public static final int INSERT_REVEAL = 257;
    public static final int INSERT_REVEAL_SELECT = 769;
    private IDataElement _parent;
    private int _type;

    public DomainEvent(int type, IDataElement parent, Object property) {
        this._type = type;
        this._parent = parent;
    }

    public DomainEvent(int type, IDataElement parent, Object property, IDataElement child) {
        this._type = type;
        this._parent = parent;
    }

    public DomainEvent(IDomainNotifier source, int type, IDataElement parent, Object property) {
        this._type = type;
        this._parent = parent;
    }

    public boolean equals(Object event) {
        return ((DomainEvent)event).getParent() == this.getParent();
    }

    public String getId() {
        return this._parent.getId();
    }

    public String getName() {
        return this._parent.getName();
    }

    public int getType() {
        return this._type;
    }

    public IDataElement getParent() {
        return this._parent;
    }

    public List getChildren() {
        return this._parent.getNestedData();
    }

    public int getChildrenCount() {
        return this._parent.getNestedSize();
    }
}

