/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseCopyAction;
import org.eclipse.rse.ui.dialogs.SystemRenameSingleDialog;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentElement;
import org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter;
import org.eclipse.swt.widgets.Shell;

public class SystemFilterMoveFilterPoolAction
extends SystemBaseCopyAction {
    private String promptString = null;
    private SystemSimpleContentElement initialSelectionElement = null;
    private SystemSimpleContentElement root = null;

    public SystemFilterMoveFilterPoolAction(Shell parent) {
        super(parent, SystemResources.ACTION_MOVE_FILTERPOOL_LABEL, 1);
        this.setToolTipText(SystemResources.ACTION_MOVE_FILTERPOOL_TOOLTIP);
        this.promptString = SystemResources.RESID_MOVE_PROMPT;
    }

    protected void reset() {
        super.reset();
        this.initialSelectionElement = null;
        this.root = null;
    }

    public void setHelpContextId(String id) {
        this.setHelp(id);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enable = false;
        if (!selection.isEmpty()) {
            enable = true;
            Iterator e = selection.iterator();
            HashSet<ISystemFilterPoolManager> managers = new HashSet<ISystemFilterPoolManager>();
            while (enable && e.hasNext()) {
                Object selectedObject = e.next();
                if (selectedObject instanceof SystemSimpleContentElement) {
                    selectedObject = ((SystemSimpleContentElement)selectedObject).getData();
                }
                ISystemFilterPool pool = null;
                if (selectedObject instanceof ISystemFilterPool) {
                    pool = (ISystemFilterPool)selectedObject;
                } else if (selectedObject instanceof ISystemFilterPoolReference) {
                    pool = ((ISystemFilterPoolReference)selectedObject).getReferencedFilterPool();
                }
                if (pool != null) {
                    String ownerName = pool.getOwningParentName();
                    ISystemFilterPoolManager manager = pool.getSystemFilterPoolManager();
                    managers.add(manager);
                    enable = managers.size() == 1 && ownerName == null;
                    continue;
                }
                enable = false;
            }
        }
        return enable;
    }

    public boolean isValidTargetParent(SystemSimpleContentElement selectedElement) {
        if (selectedElement == null) {
            return false;
        }
        Object data = selectedElement.getData();
        return data instanceof ISystemFilterPoolManager;
    }

    protected String checkForCollision(Shell shell, IProgressMonitor monitor, Object targetContainer, Object oldObject, String oldName) {
        ISystemFilterPoolManager newMgr = (ISystemFilterPoolManager)targetContainer;
        String newName = oldName;
        ISystemFilterPool match = newMgr.getSystemFilterPool(oldName);
        if (match != null) {
            SystemRenameSingleDialog dlg = new SystemRenameSingleDialog(shell, true, (Object)match, null);
            dlg.open();
            newName = !dlg.wasCancelled() ? dlg.getNewName() : null;
        }
        return newName;
    }

    protected boolean doCopy(Object targetContainer, Object oldObject, String newName, IProgressMonitor monitor) throws Exception {
        Object data;
        ISystemFilterPool oldFilterPool = (ISystemFilterPool)oldObject;
        ISystemFilterPoolManager oldMgr = oldFilterPool.getSystemFilterPoolManager();
        ISystemFilterPoolManager newMgr = (ISystemFilterPoolManager)targetContainer;
        ISystemFilterPool newFilterPool = oldMgr.moveSystemFilterPool(newMgr, oldFilterPool, newName);
        if (this.root != null && newFilterPool != null && (data = this.root.getData()) != null && data instanceof TreeViewer) {
            ((TreeViewer)data).refresh();
        }
        return newFilterPool != null;
    }

    protected SystemSimpleContentElement getTreeModel() {
        ISystemFilterPool firstPool = this.getFirstSelectedFilterPool();
        ISystemFilterPoolManagerProvider provider = firstPool.getProvider();
        return this.getPoolMgrTreeModel(provider, firstPool.getSystemFilterPoolManager());
    }

    protected SystemSimpleContentElement getTreeInitialSelection() {
        return this.initialSelectionElement;
    }

    public void setPromptString(String promptString) {
        this.promptString = promptString;
    }

    protected String getPromptString() {
        return this.promptString;
    }

    protected SystemMessage getCopyingMessage() {
        return RSEUIPlugin.getPluginMessage("RSEG1086");
    }

    protected SystemMessage getCopyingMessage(String oldName) {
        return RSEUIPlugin.getPluginMessage("RSEG1087").makeSubstitution((Object)oldName);
    }

    public SystemMessage getCompletionMessage(Object targetContainer, String[] oldNames, String[] newNames) {
        return RSEUIPlugin.getPluginMessage("RSEG1092").makeSubstitution((Object)((ISystemFilterPoolManager)targetContainer).getName());
    }

    protected Object[] getOldObjects() {
        return this.getSelectedFilterPools();
    }

    protected String[] getOldNames() {
        ISystemFilterPool[] filterPools = this.getSelectedFilterPools();
        String[] names = new String[filterPools.length];
        int idx = 0;
        while (idx < filterPools.length) {
            names[idx] = filterPools[idx].getName();
            ++idx;
        }
        return names;
    }

    protected ISystemFilterPool[] getSelectedFilterPools() {
        IStructuredSelection selection = this.getSelection();
        ISystemFilterPool[] filterPools = new ISystemFilterPool[selection.size()];
        Iterator i = selection.iterator();
        int idx = 0;
        while (i.hasNext()) {
            Object next = i.next();
            if (next instanceof SystemSimpleContentElement) {
                next = ((SystemSimpleContentElement)next).getData();
            }
            filterPools[idx++] = next instanceof ISystemFilterPoolReference ? ((ISystemFilterPoolReference)next).getReferencedFilterPool() : (ISystemFilterPool)next;
        }
        return filterPools;
    }

    protected ISystemFilterPoolManager[] getSelectedFilterPoolManagers() {
        ISystemFilterPoolManager[] mgrs = null;
        Vector<ISystemFilterPoolManager> v = new Vector<ISystemFilterPoolManager>();
        ISystemFilterPool[] pools = this.getSelectedFilterPools();
        int idx = 0;
        while (idx < pools.length) {
            ISystemFilterPoolManager mgr = pools[idx].getSystemFilterPoolManager();
            if (!v.contains(mgr)) {
                v.addElement(mgr);
            }
            ++idx;
        }
        mgrs = new ISystemFilterPoolManager[v.size()];
        idx = 0;
        while (idx < mgrs.length) {
            mgrs[idx] = (ISystemFilterPoolManager)v.elementAt(idx);
            ++idx;
        }
        return mgrs;
    }

    protected ISystemFilterPool getFirstSelectedFilterPool() {
        Object first = this.getFirstSelection();
        if (first instanceof SystemSimpleContentElement) {
            this.root = ((SystemSimpleContentElement)first).getRoot();
            first = ((SystemSimpleContentElement)first).getData();
        }
        if (first == null) {
            return null;
        }
        if (first instanceof ISystemFilterPoolReference) {
            return ((ISystemFilterPoolReference)first).getReferencedFilterPool();
        }
        if (first instanceof ISystemFilterPool) {
            return (ISystemFilterPool)first;
        }
        return null;
    }

    protected SystemSimpleContentElement getPoolMgrTreeModel(ISystemFilterPoolManagerProvider poolMgrProvider, ISystemFilterPoolManager poolMgr) {
        SystemSimpleContentElement veryRootElement = new SystemSimpleContentElement("Root", (Object)null, null, null);
        veryRootElement.setRenamable(false);
        veryRootElement.setDeletable(false);
        ISystemFilterPoolManager[] mgrs = poolMgrProvider.getSystemFilterPoolManagers();
        ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)poolMgrProvider.getAdapter(ISubSystemConfigurationAdapter.class);
        ImageDescriptor image = adapter.getSystemFilterPoolManagerImage();
        if (mgrs == null || mgrs.length == 0) {
            return veryRootElement;
        }
        Vector<SystemSimpleContentElement> veryRootChildren = new Vector<SystemSimpleContentElement>();
        int idx = 0;
        while (idx < mgrs.length) {
            if (mgrs[idx] != poolMgr) {
                SystemSimpleContentElement mgrElement = new SystemSimpleContentElement(mgrs[idx].getName(), (Object)mgrs[idx], veryRootElement, null);
                mgrElement.setRenamable(false);
                mgrElement.setDeletable(false);
                mgrElement.setImageDescriptor(image);
                veryRootChildren.addElement(mgrElement);
                if (this.initialSelectionElement == null) {
                    this.initialSelectionElement = mgrElement;
                }
            }
            ++idx;
        }
        veryRootElement.setChildren(veryRootChildren);
        return veryRootElement;
    }
}

