/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.wizards.newconnection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISubSystemConfigurator;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.SystemPerspectiveHelpers;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemConnectionForm;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter;
import org.eclipse.rse.ui.wizards.newconnection.ISystemNewConnectionWizardPage;
import org.eclipse.rse.ui.wizards.newconnection.RSEAbstractNewConnectionWizard;
import org.eclipse.rse.ui.wizards.newconnection.RSEDefaultNewConnectionWizardMainPage;

public class RSEDefaultNewConnectionWizard
extends RSEAbstractNewConnectionWizard {
    private RSEDefaultNewConnectionWizardMainPage mainPage;
    private ISystemNewConnectionWizardPage[] subsystemConfigurationSuppliedWizardPages;
    private Map ssfWizardPagesPerSystemType = new Hashtable();
    private String defaultUserId;
    private String defaultConnectionName;
    private String defaultHostName;
    private String[] activeProfileNames = null;
    private int privateProfileIndex = -1;
    private ISystemProfile privateProfile = null;
    private IHost selectedContext = null;
    private static String lastProfile = null;
    private IHost createdHost = null;

    public RSEDefaultNewConnectionWizard() {
        String[] profiles = RSECorePlugin.getTheSystemProfileManager().getActiveSystemProfileNames();
        LinkedList<String> normalized = new LinkedList<String>();
        int i = 0;
        while (i < profiles.length) {
            if (profiles[i] != null && !"".equals(profiles[i].trim())) {
                normalized.add(profiles[i]);
            }
            ++i;
        }
        this.activeProfileNames = normalized.toArray(new String[normalized.size()]);
    }

    public void dispose() {
        super.dispose();
        this.mainPage = null;
        this.subsystemConfigurationSuppliedWizardPages = null;
        this.ssfWizardPagesPerSystemType.clear();
        this.defaultUserId = null;
        this.defaultHostName = null;
        this.defaultConnectionName = null;
        this.activeProfileNames = null;
        this.privateProfileIndex = -1;
        this.privateProfile = null;
        this.selectedContext = null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        if (this.mainPage != null && this.getSystemType() != null) {
            IRSESystemType systemType = this.getSystemType();
            this.mainPage.setTitle(this.getPageTitle());
            this.mainPage.setSystemType(systemType);
            this.subsystemConfigurationSuppliedWizardPages = this.getAdditionalWizardPages(systemType);
        }
    }

    public void addPages() {
        try {
            this.createdHost = null;
            this.mainPage = this.createMainPage(this.getSystemType());
            SystemConnectionForm form = this.mainPage.getSystemConnectionForm();
            if (form != null) {
                form.setCurrentlySelectedConnection(this.selectedContext);
                if (this.defaultUserId != null) {
                    form.setUserId(this.defaultUserId);
                }
                if (this.defaultConnectionName != null) {
                    form.setConnectionName(this.defaultConnectionName);
                } else {
                    form.setConnectionName("");
                }
                if (this.defaultHostName != null) {
                    form.setHostName(this.defaultHostName);
                }
            }
            if (this.mainPage != null && this.getSystemType() != null) {
                this.mainPage.setSystemType(this.getSystemType());
            }
            this.updateDefaultSelectedProfile();
            this.addPage((IWizardPage)this.mainPage);
        }
        catch (Exception exc) {
            SystemBasePlugin.logError("New connection: Error in createPages: ", exc);
        }
    }

    protected RSEDefaultNewConnectionWizardMainPage createMainPage(IRSESystemType systemType) {
        if (this.mainPage == null) {
            this.mainPage = new RSEDefaultNewConnectionWizardMainPage((IWizard)this, this.getPageTitle(), SystemResources.RESID_NEWCONN_PAGE1_DESCRIPTION);
            this.mainPage.setTitle(this.getPageTitle());
            this.mainPage.setSystemType(systemType);
            this.subsystemConfigurationSuppliedWizardPages = systemType != null ? this.getAdditionalWizardPages(systemType) : null;
        }
        return this.mainPage;
    }

    public String getPageTitle() {
        String pageTitle = null;
        if (this.getSystemType() == null) {
            pageTitle = SystemResources.RESID_NEWCONN_PAGE1_TITLE;
        } else {
            IRSESystemType onlySystemType = this.getSystemType();
            if (onlySystemType.isLocal()) {
                pageTitle = SystemResources.RESID_NEWCONN_PAGE1_LOCAL_TITLE;
            } else {
                pageTitle = SystemResources.RESID_NEWCONN_PAGE1_REMOTE_TITLE;
                pageTitle = SystemMessage.sub((String)pageTitle, (String)"&1", (String)onlySystemType.getLabel());
            }
        }
        return pageTitle;
    }

    protected void updateDefaultSelectedProfile() {
        String defaultProfileName;
        if (this.mainPage == null) {
            return;
        }
        List<Object> profileNames = this.activeProfileNames != null ? Arrays.asList(this.activeProfileNames) : new ArrayList();
        this.mainPage.getSystemConnectionForm().setProfileNames(this.activeProfileNames);
        String string = defaultProfileName = this.selectedContext != null ? this.selectedContext.getSystemProfileName() : null;
        if (defaultProfileName == null || !profileNames.contains(defaultProfileName)) {
            if (lastProfile != null && "".equals(lastProfile)) {
                lastProfile = null;
            }
            if ((defaultProfileName = lastProfile) == null || !profileNames.contains(defaultProfileName)) {
                ISystemProfile defaultPrivateProfile = RSECorePlugin.getTheSystemRegistry().getSystemProfileManager().getDefaultPrivateSystemProfile();
                if (defaultPrivateProfile != null) {
                    defaultProfileName = defaultPrivateProfile.getName();
                }
                if (!(defaultProfileName != null && profileNames.contains(defaultProfileName) || profileNames.size() <= 0)) {
                    defaultProfileName = (String)profileNames.get(0);
                }
            }
        }
        if (defaultProfileName != null) {
            this.mainPage.getSystemConnectionForm().setProfileNamePreSelection(defaultProfileName);
            if (this.selectedContext == null || !defaultProfileName.equals(this.selectedContext.getSystemProfileName())) {
                lastProfile = defaultProfileName;
            }
        }
    }

    public void setSelectedContext(IHost selectedContext) {
        this.selectedContext = selectedContext;
        this.updateDefaultSelectedProfile();
    }

    public void setUserId(String userId) {
        this.defaultUserId = userId;
        if (this.mainPage != null) {
            this.mainPage.getSystemConnectionForm().setUserId(userId);
        }
    }

    public void setConnectionName(String name) {
        this.defaultConnectionName = name;
        if (this.mainPage != null) {
            this.mainPage.getSystemConnectionForm().setConnectionName(name);
        }
    }

    public void setHostName(String name) {
        this.defaultHostName = name;
        if (this.mainPage != null) {
            this.mainPage.getSystemConnectionForm().setHostName(name);
        }
    }

    private void setPageError(IWizardPage page) {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage != page) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1240");
            if (currentPage instanceof WizardPage) {
                ((WizardPage)currentPage).setErrorMessage(msg.getLevelOneText());
            }
        }
    }

    private ISubSystemConfigurator[] getSubSystemConfigurators() {
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        IRSESystemType systemType = this.getSystemType();
        ISubSystemConfiguration[] configurations = sr.getSubSystemConfigurationsBySystemType(systemType, true);
        ArrayList<Object> configList = new ArrayList<Object>();
        int i = 0;
        while (i < configurations.length) {
            ISubSystemConfiguration configuration = configurations[i];
            ISystemNewConnectionWizardPage firstMatch = null;
            int j = 0;
            while (j < this.subsystemConfigurationSuppliedWizardPages.length) {
                ISystemNewConnectionWizardPage page = this.subsystemConfigurationSuppliedWizardPages[j];
                ISubSystemConfiguration pageConfiguration = page.getSubSystemConfiguration();
                if (configuration == pageConfiguration) {
                    configList.add(page);
                    if (firstMatch == null) {
                        firstMatch = page;
                    }
                }
                ++j;
            }
            if (firstMatch == null) {
                class DefaultConfigurator
                implements ISubSystemConfigurator {
                    private ISubSystemConfiguration _configuration;

                    public DefaultConfigurator(ISubSystemConfiguration configuration) {
                        this._configuration = configuration;
                    }

                    public boolean applyValues(ISubSystem ss) {
                        return true;
                    }

                    public ISubSystemConfiguration getSubSystemConfiguration() {
                        return this._configuration;
                    }
                }
                configList.add(new DefaultConfigurator(configuration));
            }
            ++i;
        }
        return configList.toArray(new ISubSystemConfigurator[configList.size()]);
    }

    public boolean performFinish() {
        boolean ok = this.mainPage.getSystemConnectionForm().verify(true);
        if (!ok) {
            this.setPageError((IWizardPage)this.mainPage);
        } else if (ok && this.hasAdditionalPages()) {
            int idx = 0;
            while (ok && idx < this.subsystemConfigurationSuppliedWizardPages.length) {
                ok = this.subsystemConfigurationSuppliedWizardPages[idx].performFinish();
                if (!ok) {
                    this.setPageError((IWizardPage)this.subsystemConfigurationSuppliedWizardPages[idx]);
                }
                ++idx;
            }
        }
        if (ok) {
            String msg;
            boolean cursorSet = true;
            this.setBusyCursor(true);
            ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
            if (this.privateProfile != null) {
                try {
                    String newName = this.activeProfileNames[this.privateProfileIndex];
                    sr.renameSystemProfile(this.privateProfile, newName);
                }
                catch (SystemMessageException exc) {
                    SystemMessageDialog.displayMessage(this.getShell(), exc);
                    ok = false;
                }
                catch (Exception exc) {
                    this.setBusyCursor(false);
                    cursorSet = false;
                    msg = "Exception renaming profile ";
                    SystemBasePlugin.logError(msg, exc);
                    SystemMessageDialog.displayExceptionMessage(this.getShell(), exc);
                    ok = false;
                }
            }
            if (ok) {
                try {
                    ISubSystemConfigurator[] configurators = this.getSubSystemConfigurators();
                    IRSESystemType systemType = this.getSystemType();
                    SystemConnectionForm form = this.mainPage.getSystemConnectionForm();
                    this.createdHost = sr.createHost(form.getProfileName(), systemType, form.getConnectionName(), form.getHostName(), form.getConnectionDescription(), form.getDefaultUserId(), form.getUserIdLocation(), configurators);
                    this.setBusyCursor(false);
                    cursorSet = false;
                    if (this.createdHost != null && SystemPerspectiveHelpers.isRSEPerspectiveActive()) {
                        if (systemType.getId().equals("org.eclipse.rse.systemtype.iseries")) {
                            ISubSystem[] objSubSystems = sr.getSubSystemsBySubSystemConfigurationCategory("nativefiles", this.createdHost);
                            if (objSubSystems != null && objSubSystems.length > 0) {
                                RSEUIPlugin.getTheSystemRegistryUI().expandSubSystem(objSubSystems[0]);
                            } else {
                                RSEUIPlugin.getTheSystemRegistryUI().expandHost(this.createdHost);
                            }
                        } else {
                            RSEUIPlugin.getTheSystemRegistryUI().expandHost(this.createdHost);
                        }
                    }
                    lastProfile = form.getProfileName();
                }
                catch (Exception exc) {
                    if (cursorSet) {
                        this.setBusyCursor(false);
                    }
                    cursorSet = false;
                    msg = "Exception creating connection ";
                    SystemBasePlugin.logError(msg, exc);
                    SystemMessageDialog.displayExceptionMessage(this.getShell(), exc);
                    ok = false;
                }
            }
            if (cursorSet) {
                this.setBusyCursor(false);
            }
            return ok;
        }
        return ok;
    }

    public IHost getCreatedHost() {
        return this.createdHost;
    }

    private ISystemNewConnectionWizardPage[] getAdditionalWizardPages(IRSESystemType systemType) {
        assert (systemType != null);
        this.subsystemConfigurationSuppliedWizardPages = (ISystemNewConnectionWizardPage[])this.ssfWizardPagesPerSystemType.get(systemType);
        if (this.subsystemConfigurationSuppliedWizardPages == null) {
            Vector<ISystemNewConnectionWizardPage> additionalPages = new Vector<ISystemNewConnectionWizardPage>();
            ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
            ISubSystemConfiguration[] factories = sr.getSubSystemConfigurationsBySystemType(systemType, true);
            int idx = 0;
            while (idx < factories.length) {
                ISystemNewConnectionWizardPage[] pages;
                ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)factories[idx].getAdapter(ISubSystemConfigurationAdapter.class);
                if (adapter == null) {
                    Platform.getAdapterManager().loadAdapter((Object)factories[idx], ISubSystemConfigurationAdapter.class.getName());
                    adapter = (ISubSystemConfigurationAdapter)factories[idx].getAdapter(ISubSystemConfigurationAdapter.class);
                }
                if ((pages = adapter.getNewConnectionWizardPages(factories[idx], (IWizard)this)) != null) {
                    int widx = 0;
                    while (widx < pages.length) {
                        if (pages[widx] instanceof IWizardPage) {
                            ((IWizardPage)pages[widx]).setWizard((IWizard)this);
                        }
                        additionalPages.addElement(pages[widx]);
                        ++widx;
                    }
                }
                ++idx;
            }
            this.subsystemConfigurationSuppliedWizardPages = additionalPages.toArray(new ISystemNewConnectionWizardPage[additionalPages.size()]);
            this.ssfWizardPagesPerSystemType.put(systemType, this.subsystemConfigurationSuppliedWizardPages);
        }
        return this.subsystemConfigurationSuppliedWizardPages;
    }

    protected boolean hasAdditionalPages() {
        return this.subsystemConfigurationSuppliedWizardPages != null && this.subsystemConfigurationSuppliedWizardPages.length > 0;
    }

    protected ISystemNewConnectionWizardPage getFirstAdditionalPage() {
        if (this.subsystemConfigurationSuppliedWizardPages != null && this.subsystemConfigurationSuppliedWizardPages.length > 0) {
            RSEDefaultNewConnectionWizardMainPage previousPage = this.mainPage;
            int idx = 0;
            while (idx < this.subsystemConfigurationSuppliedWizardPages.length) {
                ((IWizardPage)this.subsystemConfigurationSuppliedWizardPages[idx]).setPreviousPage((IWizardPage)previousPage);
                previousPage = (IWizardPage)this.subsystemConfigurationSuppliedWizardPages[idx];
                ++idx;
            }
            return this.subsystemConfigurationSuppliedWizardPages[0];
        }
        return null;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (!this.hasAdditionalPages()) {
            return null;
        }
        int index = this.getAdditionalPageIndex(page);
        if (index == this.subsystemConfigurationSuppliedWizardPages.length - 1) {
            return null;
        }
        return (IWizardPage)this.subsystemConfigurationSuppliedWizardPages[index + 1];
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        return null;
    }

    private int getAdditionalPageIndex(IWizardPage page) {
        int idx = 0;
        while (idx < this.subsystemConfigurationSuppliedWizardPages.length) {
            if (page == this.subsystemConfigurationSuppliedWizardPages[idx]) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public boolean canFinish() {
        boolean ok = this.mainPage.isPageComplete();
        if (ok && this.hasAdditionalPages()) {
            int idx = 0;
            while (ok && idx < this.subsystemConfigurationSuppliedWizardPages.length) {
                ok = this.subsystemConfigurationSuppliedWizardPages[idx].isPageComplete();
                ++idx;
            }
        }
        return ok;
    }
}

