/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.files;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.ISystemResourceSet;
import org.eclipse.rse.core.model.SystemRemoteResourceSet;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.core.model.SystemWorkspaceResourceSet;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISystemDragDropAdapter;
import org.eclipse.rse.files.ui.resources.UniversalFileTransferUtility;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTest;
import org.eclipse.rse.tests.subsystems.files.FileServiceHelper;
import org.eclipse.rse.ui.RSEUIPlugin;

public class FileServiceArchiveTestDStore
extends FileServiceArchiveTest {
    private boolean fPreference_ALERT_SSL;
    private boolean fPreference_ALERT_NONSSL;

    public FileServiceArchiveTestDStore(String name) {
        super(name);
        this.setTargetName("linux");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("FileServiceArchiveTestDStore");
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyBatchToArchiveFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyBatchToVirtualFileLevelOne"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyBatchToVirtualFileLevelTwo"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyBatchVirtualFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyBatchVirtualFileLevelTwo"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyToArchiveFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyToVirtualFileLevelOne"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyToVirtualFileLevelTwo"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyVirtualBatchToArchiveFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyVirtualBatchToVirtualFileLevelOne"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyVirtualBatchToVirtualFileLevelTwo"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyVirtualFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyVirtualFileLevelTwo"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCreateZipFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testMoveToArchiveFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testMoveToVirtualFileLevelOne"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testMoveToVirtualFileLevelTwo"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testMoveVirtualFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testMoveVirtualFileLevelTwo"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testRenameVirtualFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCreateTarFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyTarVirtualFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyTarVirtualFileLevelFour"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyToTarArchiveFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyToTarVirtualFileLevelOne"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyToTarVirtualFileLevelFour"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testDeleteTarVirtualFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testMoveTarVirtualFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testMoveTarVirtualFileLevelFour"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testMoveToTarArchiveFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testMoveToTarVirtualFileLevelOne"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testMoveToVirtualFileLevelFour"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testRenameTarVirtualFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyBatchTarVirtualFileLevelFive"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyBatchToTarArchiveFile"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyBatchToTarVirtualFileLevelFour"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testSuperTransferLocalToRemote"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testSuperTransferDStoreWindowsAndDStore"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testSuperTransferDStoreToLocal"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyVirtualFileFromDStoreToLocal"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyVirtualFileLevelTwoFromDStoreToLocal"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyVirtualFileFromLocalToDStore"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyVirtualFileLevelTwoFromLocalToDStore"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyVFLevelTwoToArchiveFromDStoreToLocal"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyVFLevelTwoToArchiveFromLocalToDStore"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyVFToArchiveFromDStoreToLocal"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyVFToArchiveFromLocalToDStore"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyVFToVFFromDStoreToLocal"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyVFToVFLevelTwoFromDStoreToLocal"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyVFToVFFromLocalToDStore"));
        suite.addTest(TestSuite.createTest(FileServiceArchiveTestDStore.class, (String)"testCopyVFToVFLevelTwoFromLocalToDStore"));
        return suite;
    }

    protected void setupFileSubSystem() {
        IHost dstoreHost = this.getLinuxHost();
        FileServiceArchiveTestDStore.assertNotNull((Object)dstoreHost);
        ISystemRegistry sr = SystemStartHere.getSystemRegistry();
        ISubSystem[] ss = sr.getServiceSubSystems(dstoreHost, IFileService.class);
        int i = 0;
        while (i < ss.length) {
            if (ss[i] instanceof IFileServiceSubSystem) {
                this.fss = (IFileServiceSubSystem)ss[i];
                this.fs = this.fss.getFileService();
            }
            ++i;
        }
        IHost localHost = this.getLocalSystemConnection();
        sr = SystemStartHere.getSystemRegistry();
        ss = sr.getServiceSubSystems(localHost, IFileService.class);
        int i2 = 0;
        while (i2 < ss.length) {
            if (ss[i2] instanceof IFileServiceSubSystem) {
                this.localFss = (IFileServiceSubSystem)ss[i2];
            }
            ++i2;
        }
        try {
            IConnectorService connectionService = this.fss.getConnectorService();
            connectionService.acquireCredentials(false);
            connectionService.connect(this.mon);
        }
        catch (Exception e) {
            FileServiceArchiveTestDStore.assertTrue((String)("Exception creating temp dir " + e.getStackTrace().toString()), (boolean)false);
        }
    }

    public void tearDown() throws Exception {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.rse.preferences.alert.ssl", this.fPreference_ALERT_SSL);
        store.setValue("org.eclipse.rse.preferences.alert.nonssl", this.fPreference_ALERT_NONSSL);
        super.tearDown();
    }

    public void testSuperTransferLocalToRemote() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        String tempPath = FileServiceArchiveTestDStore.getWorkspace().getRoot().getLocation().append("temp").toString();
        IFileStore temp = this.createDir(tempPath, true);
        this.createSuperTransferFolder(temp);
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        boolean preference_DOSUPERTRANSFER = store.getBoolean("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer");
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer", true);
        IRemoteFile sourceFolderToCopy1 = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.folderToCopyName3, this.mon);
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)((IAdaptable)sourceFolderToCopy1).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet3.addResource((Object)sourceFolderToCopy1);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        Object[] children = this.fss.resolveFilterString((Object)this.tempDir, null, this.mon);
        FileServiceArchiveTestDStore.assertTrue((children.length == 1 ? 1 : 0) != 0);
        Object theCopiedFolder = this.getChildFromFolder(this.tempDir, this.folderToCopyName3);
        FileServiceArchiveTestDStore.assertNotNull((Object)theCopiedFolder);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedFolder, childrenToCheck, typesToCheck);
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer", preference_DOSUPERTRANSFER);
        temp.delete(0, this.mon);
    }

    public void testSuperTransferDStoreWindowsAndDStore() throws Exception {
        this.getWindowsHost();
        if (this.isTestDisabled()) {
            return;
        }
        String tempPath = FileServiceArchiveTestDStore.getWorkspace().getRoot().getLocation().append("temp").toString();
        IFileStore temp = this.createDir(tempPath, true);
        this.createSuperTransferFolder(temp);
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        boolean preference_DOSUPERTRANSFER = store.getBoolean("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer");
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer", true);
        IRemoteFile sourceFolderToCopy1 = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.folderToCopyName3, this.mon);
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)((IAdaptable)sourceFolderToCopy1).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet1 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet1.addResource((Object)sourceFolderToCopy1);
        ISystemResourceSet tempObjects1 = srcAdapter1.doDrag(fromSet1, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects1), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        this.fss.resolveFilterString((Object)this.tempDir, null, this.mon);
        IHost dstoreHost = this.getWindowsHost();
        FileServiceArchiveTestDStore.assertNotNull((Object)dstoreHost);
        ISystemRegistry sr = SystemStartHere.getSystemRegistry();
        ISubSystem[] ss = sr.getServiceSubSystems(dstoreHost, IFileService.class);
        IFileServiceSubSystem dstoreWindowsFss = null;
        int i = 0;
        while (i < ss.length) {
            if (ss[i] instanceof IFileServiceSubSystem) {
                dstoreWindowsFss = (IFileServiceSubSystem)ss[i];
            }
            ++i;
        }
        FileServiceArchiveTestDStore.assertNotNull(dstoreWindowsFss);
        IConnectorService dstoreWindowsConnectionService = dstoreWindowsFss.getConnectorService();
        dstoreWindowsConnectionService.acquireCredentials(false);
        dstoreWindowsConnectionService.connect(this.mon);
        IRemoteFile dstoreWindowsTempDir = null;
        try {
            IRemoteFile homeDirectory = dstoreWindowsFss.getRemoteFileObject(".", this.mon);
            String baseFolderName = "rsetest";
            String homeFolderName = homeDirectory.getAbsolutePath();
            String testFolderName = FileServiceHelper.getRandomLocation(dstoreWindowsFss, homeFolderName, baseFolderName, this.mon);
            dstoreWindowsTempDir = this.createFileOrFolder(dstoreWindowsFss, homeFolderName, testFolderName, true);
        }
        catch (Exception e) {
            FileServiceArchiveTestDStore.fail((String)("Problem encountered: " + e.getStackTrace().toString()));
        }
        IRemoteFile sourceFolderToCopy2 = (IRemoteFile)this.getChildFromFolder(this.tempDir, this.folderToCopyName3);
        ISystemDragDropAdapter srcAdapter2 = (ISystemDragDropAdapter)((IAdaptable)sourceFolderToCopy2).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet2 = new SystemRemoteResourceSet((ISubSystem)this.fss, srcAdapter2);
        fromSet2.addResource((Object)sourceFolderToCopy2);
        ISystemResourceSet tempObjects2 = srcAdapter2.doDrag(fromSet2, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects2), (IRemoteFile)dstoreWindowsTempDir, (IProgressMonitor)this.mon, (boolean)true);
        Object[] children = dstoreWindowsFss.resolveFilterString((Object)dstoreWindowsTempDir, null, this.mon);
        FileServiceArchiveTestDStore.assertTrue((children.length == 1 ? 1 : 0) != 0);
        Object theCopiedFolder = this.getChildFromFolder(dstoreWindowsFss, dstoreWindowsTempDir, this.folderToCopyName3);
        FileServiceArchiveTestDStore.assertNotNull((Object)theCopiedFolder);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents(dstoreWindowsFss, (IRemoteFile)theCopiedFolder, childrenToCheck, typesToCheck);
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer", preference_DOSUPERTRANSFER);
        try {
            dstoreWindowsFss.delete(dstoreWindowsTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
        temp.delete(0, this.mon);
    }

    public void testSuperTransferDStoreToLocal() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        String tempPath = FileServiceArchiveTestDStore.getWorkspace().getRoot().getLocation().append("temp").toString();
        IFileStore temp = this.createDir(tempPath, true);
        this.createSuperTransferFolder(temp);
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        boolean preference_DOSUPERTRANSFER = store.getBoolean("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer");
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer", true);
        IRemoteFile sourceFolderToCopy1 = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.folderToCopyName3, this.mon);
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)((IAdaptable)sourceFolderToCopy1).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet1 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet1.addResource((Object)sourceFolderToCopy1);
        ISystemResourceSet tempObjects1 = srcAdapter1.doDrag(fromSet1, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects1), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        this.fss.resolveFilterString((Object)this.tempDir, null, this.mon);
        IRemoteFile localTempDir = null;
        try {
            IRemoteFile homeDirectory = this.localFss.getRemoteFileObject(".", this.mon);
            String baseFolderName = "rsetest";
            String homeFolderName = homeDirectory.getAbsolutePath();
            String testFolderName = FileServiceHelper.getRandomLocation(this.localFss, homeFolderName, baseFolderName, this.mon);
            localTempDir = this.createFileOrFolder(this.localFss, homeFolderName, testFolderName, true);
        }
        catch (Exception e) {
            FileServiceArchiveTestDStore.fail((String)("Problem encountered: " + e.getStackTrace().toString()));
        }
        IRemoteFile sourceFolderToCopy2 = (IRemoteFile)this.getChildFromFolder(this.tempDir, this.folderToCopyName3);
        ISystemDragDropAdapter srcAdapter2 = (ISystemDragDropAdapter)((IAdaptable)sourceFolderToCopy2).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet2 = new SystemRemoteResourceSet((ISubSystem)this.fss, srcAdapter2);
        fromSet2.addResource((Object)sourceFolderToCopy2);
        ISystemResourceSet tempObjects2 = srcAdapter2.doDrag(fromSet2, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects2), (IRemoteFile)localTempDir, (IProgressMonitor)this.mon, (boolean)true);
        Object[] localChildren = this.localFss.resolveFilterString((Object)localTempDir, null, this.mon);
        FileServiceArchiveTestDStore.assertTrue((localChildren.length == 1 ? 1 : 0) != 0);
        Object theCopiedFolderLocal = this.getChildFromFolder(this.localFss, localTempDir, this.folderToCopyName3);
        FileServiceArchiveTestDStore.assertNotNull((Object)theCopiedFolderLocal);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents(this.localFss, (IRemoteFile)theCopiedFolderLocal, childrenToCheck, typesToCheck);
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer", preference_DOSUPERTRANSFER);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
        temp.delete(0, this.mon);
    }

    public void testCopyVirtualFileFromDStoreToLocal() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.createSourceZipFiles();
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile localTempDir = null;
        try {
            IRemoteFile homeDirectory = this.localFss.getRemoteFileObject(".", this.mon);
            String baseFolderName = "rsetest";
            String homeFolderName = homeDirectory.getAbsolutePath();
            String testFolderName = FileServiceHelper.getRandomLocation(this.localFss, homeFolderName, baseFolderName, this.mon);
            localTempDir = this.createFileOrFolder(this.localFss, homeFolderName, testFolderName, true);
        }
        catch (Exception e) {
            FileServiceArchiveTestDStore.fail((String)("Problem encountered: " + e.getStackTrace().toString()));
        }
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.localFss, localTempDir.getAbsolutePath(), folderName, true);
        FileServiceArchiveTestDStore.assertNotNull((Object)folder1);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(sourceZipFile, this.folderToCopyName1);
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)((IAdaptable)firstLevelChild).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.fss, srcAdapter1);
        fromSet3.addResource((Object)firstLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)folder1, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.localFss, folder1, this.folderToCopyName1);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Team", "TypeFilters", "xuanchentp", ".compatibility", ".project"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents(this.localFss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVirtualFileLevelTwoFromDStoreToLocal() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.createSourceZipFiles();
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile localTempDir = null;
        try {
            IRemoteFile homeDirectory = this.localFss.getRemoteFileObject(".", this.mon);
            String baseFolderName = "rsetest";
            String homeFolderName = homeDirectory.getAbsolutePath();
            String testFolderName = FileServiceHelper.getRandomLocation(this.localFss, homeFolderName, baseFolderName, this.mon);
            localTempDir = this.createFileOrFolder(this.localFss, homeFolderName, testFolderName, true);
        }
        catch (Exception e) {
            FileServiceArchiveTestDStore.fail((String)("Problem encountered: " + e.getStackTrace().toString()));
        }
        String folderName = "folder1";
        String secondLeveChildName = "Team";
        IRemoteFile folder1 = this.createFileOrFolder(this.localFss, localTempDir.getAbsolutePath(), folderName, true);
        FileServiceArchiveTestDStore.assertNotNull((Object)folder1);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(sourceZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(firstLevelChild, "Team");
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)((IAdaptable)secondLevelChild).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.fss, srcAdapter1);
        fromSet3.addResource((Object)secondLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)folder1, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.localFss, folder1, secondLeveChildName);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Connections", "Filters", "profile.xmi"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents(this.localFss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVirtualFileFromLocalToDStore() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        IRemoteFile sourceZipLocation = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.localFss, sourceZipLocation, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.fss, this.tempDir.getAbsolutePath(), folderName, true);
        FileServiceArchiveTestDStore.assertNotNull((Object)folder1);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(this.localFss, sourceZipFile, this.folderToCopyName1);
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)((IAdaptable)firstLevelChild).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet3.addResource((Object)firstLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)folder1, (IProgressMonitor)this.mon, (boolean)true);
        Object copiedVirtualFolder = this.getChildFromFolder(this.fss, folder1, this.folderToCopyName1);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Team", "TypeFilters", "xuanchentp", ".compatibility", ".project"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents(this.fss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(sourceZipLocation, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVirtualFileLevelTwoFromLocalToDStore() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        IRemoteFile sourceZipLocation = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.localFss, sourceZipLocation, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.fss, this.tempDir.getAbsolutePath(), folderName, true);
        FileServiceArchiveTestDStore.assertNotNull((Object)folder1);
        String secondLeveChildName = "Team";
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(this.localFss, sourceZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(this.localFss, firstLevelChild, secondLeveChildName);
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)((IAdaptable)secondLevelChild).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet3.addResource((Object)secondLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)folder1, (IProgressMonitor)this.mon, (boolean)true);
        Object copiedVirtualFolder = this.getChildFromFolder(this.fss, folder1, secondLeveChildName);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Connections", "Filters", "profile.xmi"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents(this.fss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(sourceZipLocation, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVFToArchiveFromDStoreToLocal() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.createSourceZipFiles();
        IRemoteFile localTempDir = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile destinationArchiveFile = (IRemoteFile)this.getChildFromFolder(this.localFss, localTempDir, this.zipSourceFileName2);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(sourceZipFile, this.folderToCopyName1);
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)((IAdaptable)firstLevelChild).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.fss, srcAdapter1);
        fromSet3.addResource((Object)firstLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)destinationArchiveFile, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.localFss, destinationArchiveFile, this.folderToCopyName1);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Team", "TypeFilters", "xuanchentp", ".compatibility", ".project"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents(this.localFss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVFLevelTwoToArchiveFromDStoreToLocal() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.createSourceZipFiles();
        IRemoteFile localTempDir = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile destinationArchiveFile = (IRemoteFile)this.getChildFromFolder(this.localFss, localTempDir, this.zipSourceFileName2);
        String secondLeveChildName = "Team";
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(this.fss, sourceZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(this.fss, firstLevelChild, secondLeveChildName);
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)((IAdaptable)secondLevelChild).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.fss, srcAdapter1);
        fromSet3.addResource((Object)secondLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)destinationArchiveFile, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.localFss, destinationArchiveFile, secondLeveChildName);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Connections", "Filters", "profile.xmi"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents(this.localFss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVFToArchiveFromLocalToDStore() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.createSourceZipFiles();
        IRemoteFile localTempDir = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.localFss, localTempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile destinationArchiveFile = (IRemoteFile)this.getChildFromFolder(this.fss, this.tempDir, this.zipSourceFileName2);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(this.localFss, sourceZipFile, this.folderToCopyName1);
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)((IAdaptable)firstLevelChild).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet3.addResource((Object)firstLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)destinationArchiveFile, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.fss, destinationArchiveFile, this.folderToCopyName1);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Team", "TypeFilters", "xuanchentp", ".compatibility", ".project"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents(this.fss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVFLevelTwoToArchiveFromLocalToDStore() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.createSourceZipFiles();
        IRemoteFile localTempDir = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.localFss, localTempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile destinationArchiveFile = (IRemoteFile)this.getChildFromFolder(this.fss, this.tempDir, this.zipSourceFileName2);
        String secondLeveChildName = "Team";
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(this.localFss, sourceZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(this.localFss, firstLevelChild, secondLeveChildName);
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)((IAdaptable)secondLevelChild).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet3.addResource((Object)secondLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)destinationArchiveFile, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.fss, destinationArchiveFile, secondLeveChildName);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Connections", "Filters", "profile.xmi"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents(this.fss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVFToVFFromDStoreToLocal() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.createSourceZipFiles();
        IRemoteFile localTempDir = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile destinationArchiveFile = (IRemoteFile)this.getChildFromFolder(this.localFss, localTempDir, this.zipSourceFileName2);
        IRemoteFile destinationVirtualFolder = (IRemoteFile)this.getChildFromFolder(this.localFss, destinationArchiveFile, this.folderToCopyName2);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(sourceZipFile, this.folderToCopyName1);
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)((IAdaptable)firstLevelChild).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.fss, srcAdapter1);
        fromSet3.addResource((Object)firstLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)destinationVirtualFolder, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.localFss, destinationVirtualFolder, this.folderToCopyName1);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Team", "TypeFilters", "xuanchentp", ".compatibility", ".project"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents(this.localFss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVFToVFLevelTwoFromDStoreToLocal() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.createSourceZipFiles();
        IRemoteFile localTempDir = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile destinationArchiveFile = (IRemoteFile)this.getChildFromFolder(this.localFss, localTempDir, this.zipSourceFileName2);
        IRemoteFile firstChild = (IRemoteFile)this.getChildFromFolder(this.localFss, destinationArchiveFile, this.folderToCopyName2);
        IRemoteFile destinationVirtualFolder = (IRemoteFile)this.getChildFromFolder(this.localFss, firstChild, "20070319");
        String secondLeveChildName = "Team";
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(this.fss, sourceZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(this.fss, firstLevelChild, secondLeveChildName);
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)((IAdaptable)secondLevelChild).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.fss, srcAdapter1);
        fromSet3.addResource((Object)secondLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)destinationVirtualFolder, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.localFss, destinationVirtualFolder, secondLeveChildName);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Connections", "Filters", "profile.xmi"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents(this.localFss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVFToVFFromLocalToDStore() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.createSourceZipFiles();
        IRemoteFile localTempDir = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.localFss, localTempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile destinationArchiveFile = (IRemoteFile)this.getChildFromFolder(this.fss, this.tempDir, this.zipSourceFileName2);
        IRemoteFile destinationVirtualFolder = (IRemoteFile)this.getChildFromFolder(this.fss, destinationArchiveFile, this.folderToCopyName2);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(this.localFss, sourceZipFile, this.folderToCopyName1);
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)((IAdaptable)firstLevelChild).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet3.addResource((Object)firstLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)destinationVirtualFolder, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.fss, destinationVirtualFolder, this.folderToCopyName1);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Team", "TypeFilters", "xuanchentp", ".compatibility", ".project"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents(this.fss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVFToVFLevelTwoFromLocalToDStore() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.createSourceZipFiles();
        IRemoteFile localTempDir = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.localFss, localTempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile destinationArchiveFile = (IRemoteFile)this.getChildFromFolder(this.fss, this.tempDir, this.zipSourceFileName2);
        IRemoteFile firstChild = (IRemoteFile)this.getChildFromFolder(this.fss, destinationArchiveFile, this.folderToCopyName2);
        IRemoteFile destinationVirtualFolder = (IRemoteFile)this.getChildFromFolder(this.fss, firstChild, "20070319");
        String secondLeveChildName = "Team";
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(this.localFss, sourceZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(this.localFss, firstLevelChild, secondLeveChildName);
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)((IAdaptable)secondLevelChild).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet3.addResource((Object)secondLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)destinationVirtualFolder, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.fss, destinationVirtualFolder, secondLeveChildName);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Connections", "Filters", "profile.xmi"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents(this.fss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }
}

