/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.files.compile;

import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.internal.useractions.ui.compile.ISystemCompileCommandSubstitutor;
import org.eclipse.rse.shells.ui.RemoteCommandHelpers;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;

public class UniversalCompileSubstitutor
implements ISystemCompileCommandSubstitutor {
    private IHost connection;

    public UniversalCompileSubstitutor(IHost connection) {
        this.connection = connection;
    }

    public void setConnection(IHost connection) {
        this.connection = connection;
    }

    public String getSubstitutionValue(String substitutionVariable, Object context) {
        if (substitutionVariable.equals("${system_filesep}")) {
            return this.getFileSeparator();
        }
        if (substitutionVariable.equals("${system_homedir}")) {
            return this.getHomeDirectory();
        }
        if (substitutionVariable.equals("${system_pathsep}")) {
            return this.getPathSeparator();
        }
        if (substitutionVariable.equals("${system_tempdir}")) {
            return this.getTempDirectory();
        }
        if (substitutionVariable.equals("${user_id}")) {
            return this.getUserId();
        }
        if (substitutionVariable.equals("${resource_name}")) {
            return this.getResourceName(context);
        }
        if (substitutionVariable.equals("${resource_name_root}")) {
            return this.getResourceNameRoot(context);
        }
        if (substitutionVariable.equals("${resource_path}")) {
            return this.getResourcePath(context);
        }
        if (substitutionVariable.equals("${resource_path_root}")) {
            return this.getPathRoot(context);
        }
        if (substitutionVariable.equals("${resource_path_drive}")) {
            return this.getPathDrive(context);
        }
        if (substitutionVariable.equals("${container_name}")) {
            return this.getContainerName(context);
        }
        if (substitutionVariable.equals("${container_path}")) {
            return this.getContainerPath(context);
        }
        return null;
    }

    protected IRemoteCmdSubSystem getCmdsSubSystem() {
        return RemoteCommandHelpers.getCmdSubSystem((IHost)this.connection);
    }

    protected IRemoteFileSubSystem getFilesSubSystem() {
        return RemoteFileUtility.getFileSubSystem((IHost)this.connection);
    }

    protected IRemoteFileSubSystemConfiguration getFilesSubSystemFactory() {
        return RemoteFileUtility.getFileSubSystem((IHost)this.connection).getParentRemoteFileSubSystemConfiguration();
    }

    protected String getFileSeparator() {
        return this.getFilesSubSystemFactory().getSeparator();
    }

    protected String getPathSeparator() {
        return this.getFilesSubSystemFactory().getPathSeparator();
    }

    protected String getHomeDirectory() {
        return this.getCmdsSubSystem().getConnectorService().getHomeDirectory();
    }

    protected String getTempDirectory() {
        return this.getCmdsSubSystem().getConnectorService().getTempDirectory();
    }

    protected String getUserId() {
        return this.getCmdsSubSystem().getConnectorService().getUserId();
    }

    protected String getResourceName(Object context) {
        return SystemAdapterHelpers.getRemoteAdapter((Object)context).getName(context);
    }

    protected String getResourceNameRoot(Object context) {
        IRemoteFile selectedFile = (IRemoteFile)context;
        String name = selectedFile.getName();
        int dotIdx = name.lastIndexOf(46);
        if (dotIdx == 0) {
            return "";
        }
        if (dotIdx > 0) {
            return name.substring(0, dotIdx);
        }
        return name;
    }

    protected String getResourcePath(Object context) {
        return SystemAdapterHelpers.getRemoteAdapter((Object)context).getAbsoluteName(context);
    }

    protected String getPathRoot(Object context) {
        IRemoteFile selectedFile = (IRemoteFile)context;
        String name = selectedFile.getAbsolutePath();
        if (name != null) {
            if (name.startsWith("/") || name.startsWith("\\")) {
                return name.substring(0, 1);
            }
            int idx = name.indexOf(":\\");
            if (idx > 0) {
                return name.substring(0, idx + 2);
            }
        }
        return "";
    }

    protected String getPathDrive(Object context) {
        int idx;
        IRemoteFile selectedFile = (IRemoteFile)context;
        String name = selectedFile.getAbsolutePath();
        if (name != null && name.length() > 1 && (idx = name.indexOf(58)) > 0) {
            return name.substring(0, idx);
        }
        return "";
    }

    protected String getContainerName(Object context) {
        IRemoteFile selectedFile = (IRemoteFile)context;
        String fn = selectedFile.getParentName();
        if (fn != null) {
            return fn;
        }
        return "";
    }

    protected String getContainerPath(Object context) {
        int idx;
        IRemoteFile selectedFile = (IRemoteFile)context;
        String name = selectedFile.getAbsolutePath();
        if (name != null && name.length() > 1 && (idx = name.indexOf(58)) > 0) {
            return name.substring(0, idx);
        }
        return "";
    }
}

