/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.serial;

import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm.internal.terminal.provisional.api.AbstractSettingsPage;
import org.eclipse.tm.internal.terminal.serial.SerialMessages;
import org.eclipse.tm.internal.terminal.serial.SerialProperties;
import org.eclipse.tm.internal.terminal.serial.SerialSettings;

public class SerialSettingsPage
extends AbstractSettingsPage {
    private Combo fSerialPortCombo;
    private Combo fBaudRateCombo;
    private Combo fDataBitsCombo;
    private Combo fStopBitsCombo;
    private Combo fParityCombo;
    private Combo fFlowControlCombo;
    private Text fTimeout;
    private final SerialSettings fTerminalSettings;

    public SerialSettingsPage(SerialSettings settings) {
        this.fTerminalSettings = settings;
    }

    public void saveSettings() {
        this.fTerminalSettings.setSerialPort(this.getComboValue(this.fSerialPortCombo));
        this.fTerminalSettings.setBaudRate(this.getComboValue(this.fBaudRateCombo));
        this.fTerminalSettings.setDataBits(this.getComboValue(this.fDataBitsCombo));
        this.fTerminalSettings.setStopBits(this.getComboValue(this.fStopBitsCombo));
        this.fTerminalSettings.setParity(this.getComboValue(this.fParityCombo));
        this.fTerminalSettings.setFlowControl(this.getComboValue(this.fFlowControlCombo));
        this.fTerminalSettings.setTimeout(this.fTimeout.getText());
    }

    public void loadSettings() {
        SerialProperties properties = this.fTerminalSettings.getProperties();
        List list = properties.getSerialPortTable();
        this.loadCombo(this.fSerialPortCombo, list);
        list = properties.getBaudRateTable();
        this.loadCombo(this.fBaudRateCombo, list);
        list = properties.getDataBitsTable();
        this.loadCombo(this.fDataBitsCombo, list);
        list = properties.getStopBitsTable();
        this.loadCombo(this.fStopBitsCombo, list);
        list = properties.getParityTable();
        this.loadCombo(this.fParityCombo, list);
        list = properties.getFlowControlTable();
        this.loadCombo(this.fFlowControlCombo, list);
        this.setCombo(this.fSerialPortCombo, this.fTerminalSettings.getSerialPort());
        this.setCombo(this.fBaudRateCombo, this.fTerminalSettings.getBaudRateString());
        this.setCombo(this.fDataBitsCombo, this.fTerminalSettings.getDataBitsString());
        this.setCombo(this.fStopBitsCombo, this.fTerminalSettings.getStopBitsString());
        this.setCombo(this.fParityCombo, this.fTerminalSettings.getParityString());
        this.setCombo(this.fFlowControlCombo, this.fTerminalSettings.getFlowControlString());
        this.fTimeout.setText(this.fTerminalSettings.getTimeoutString());
    }

    private void setCombo(Combo combo, String value) {
        if (value == null) {
            return;
        }
        int nIndex = combo.indexOf(value);
        if (nIndex == -1) {
            if ((combo.getStyle() & 8) == 0) {
                combo.add(value);
                nIndex = combo.indexOf(value);
            } else {
                return;
            }
        }
        combo.select(nIndex);
    }

    private String getComboValue(Combo combo) {
        int nIndex = combo.getSelectionIndex();
        if (nIndex == -1) {
            if ((combo.getStyle() & 8) != 0) {
                return "";
            }
            return combo.getText();
        }
        return combo.getItem(nIndex);
    }

    public boolean validateSettings() {
        try {
            int p = Integer.parseInt(this.fTimeout.getText().trim());
            return p >= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(768));
        this.fSerialPortCombo = this.addLabeledCombo(composite, String.valueOf(SerialMessages.PORT) + ":", false);
        this.fBaudRateCombo = this.addLabeledCombo(composite, String.valueOf(SerialMessages.BAUDRATE) + ":");
        this.fDataBitsCombo = this.addLabeledCombo(composite, String.valueOf(SerialMessages.DATABITS) + ":");
        this.fStopBitsCombo = this.addLabeledCombo(composite, String.valueOf(SerialMessages.STOPBITS) + ":");
        this.fParityCombo = this.addLabeledCombo(composite, String.valueOf(SerialMessages.PARITY) + ":");
        this.fFlowControlCombo = this.addLabeledCombo(composite, String.valueOf(SerialMessages.FLOWCONTROL) + ":");
        new Label(composite, 131072).setText(String.valueOf(SerialMessages.TIMEOUT) + ":");
        this.fTimeout = new Text(composite, 2048);
        this.fTimeout.setLayoutData((Object)new GridData(768));
        this.fTimeout.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SerialSettingsPage.this.fireListeners((Control)SerialSettingsPage.this.fTimeout);
            }
        });
        this.loadSettings();
    }

    private Combo addLabeledCombo(Composite composite, String label) {
        return this.addLabeledCombo(composite, label, true);
    }

    private Combo addLabeledCombo(Composite composite, String label, boolean readonly) {
        new Label(composite, 131072).setText(label);
        int flags = 4;
        if (readonly) {
            flags |= 8;
        }
        final Combo combo = new Combo(composite, flags);
        combo.setLayoutData((Object)new GridData(768));
        if (!readonly) {
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SerialSettingsPage.this.fireListeners((Control)combo);
                }
            });
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SerialSettingsPage.this.fireListeners((Control)combo);
            }
        });
        return combo;
    }

    private void loadCombo(Combo ctlCombo, List table) {
        for (String label : table) {
            ctlCombo.add(label);
        }
    }
}

