/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.trace4cps.analysis.signal.impl.PsopHelper;
import org.eclipse.trace4cps.core.ClaimEventType;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.IClaimEvent;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.IInterval;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.IResource;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.impl.Interval;

public class TraceHelper {
    private TraceHelper() {
    }

    public static Set<String> getAttributeValues(ITrace trace, String att) {
        HashSet<String> result = new HashSet<String>();
        TraceHelper.getAttributeValues(trace.getClaims(), att, result);
        TraceHelper.getAttributeValues(trace.getResources(), att, result);
        TraceHelper.getAttributeValues(trace.getEvents(), att, result);
        TraceHelper.getAttributeValues(trace.getDependencies(), att, result);
        TraceHelper.getAttributeValues(trace.getSignals(), att, result);
        return result;
    }

    public static Set<String> getAttributeValues(Collection<? extends IAttributeAware> list, String att) {
        HashSet<String> result = new HashSet<String>();
        TraceHelper.getAttributeValues(list, att, result);
        return result;
    }

    private static void getAttributeValues(Collection<? extends IAttributeAware> list, String att, Set<String> result) {
        for (IAttributeAware iAttributeAware : list) {
            String val = iAttributeAware.getAttributeValue(att);
            if (val == null) continue;
            result.add(val);
        }
    }

    public static Set<String> getAttributeNames(Collection<? extends IAttributeAware> list) {
        HashSet<String> result = new HashSet<String>();
        TraceHelper.getAttributeNames(list, result);
        return result;
    }

    public static Set<String> getAttributeNames(ITrace trace) {
        HashSet<String> result = new HashSet<String>();
        TraceHelper.getAttributeNames(trace.getClaims(), result);
        TraceHelper.getAttributeNames(trace.getResources(), result);
        TraceHelper.getAttributeNames(trace.getEvents(), result);
        TraceHelper.getAttributeNames(trace.getDependencies(), result);
        TraceHelper.getAttributeNames(trace.getSignals(), result);
        return result;
    }

    private static void getAttributeNames(Collection<? extends IAttributeAware> list, Set<String> result) {
        for (IAttributeAware iAttributeAware : list) {
            result.addAll(iAttributeAware.getAttributes().keySet());
        }
    }

    public static boolean hasNonClaimEvents(ITrace trace) {
        for (IEvent e : trace.getEvents()) {
            if (e instanceof IClaimEvent) continue;
            return true;
        }
        return false;
    }

    public static List<IEvent> getEvents(ITrace trace, boolean includeClaimEvents) {
        ArrayList<IEvent> r = new ArrayList<IEvent>();
        for (IEvent e : trace.getEvents()) {
            if (e instanceof IClaimEvent && !includeClaimEvents) continue;
            r.add(e);
        }
        return r;
    }

    public static List<IAttributeAware> getClaimsAndEvents(ITrace trace, boolean includeClaimEvents) {
        ArrayList<IAttributeAware> r = new ArrayList<IAttributeAware>();
        r.addAll(trace.getClaims());
        for (IEvent e : trace.getEvents()) {
            if (e instanceof IClaimEvent && !includeClaimEvents) continue;
            r.add(e);
        }
        return r;
    }

    public static Map<String, String> toMap(String ... args) {
        HashMap<String, String> r = new HashMap<String, String>();
        if (args != null) {
            int i = 0;
            while (i < args.length - 1) {
                r.put(args[i], args[i + 1]);
                i += 2;
            }
        }
        return r;
    }

    public static IInterval getDomain(ITrace trace) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (IClaim c : trace.getClaims()) {
            min = Math.min(min, c.getStartTime().doubleValue());
            max = Math.max(max, c.getEndTime().doubleValue());
        }
        for (IEvent e : trace.getEvents()) {
            min = Math.min(min, e.getTimestamp().doubleValue());
            max = Math.max(max, e.getTimestamp().doubleValue());
        }
        for (IPsop p : trace.getSignals()) {
            min = Math.min(min, PsopHelper.getDomainLowerBound(p).doubleValue());
            max = Math.max(max, PsopHelper.getDomainUpperBound(p).doubleValue());
        }
        return new Interval(min, false, max, false);
    }

    public static <T extends IAttributeAware> T get(Collection<T> l, String key, String value) {
        List<T> r = TraceHelper.filter(l, key, value);
        if (r.isEmpty()) {
            return null;
        }
        return (T)((IAttributeAware)r.get(0));
    }

    public static boolean matches(IAttributeAware a1, IAttributeAware a2) {
        return TraceHelper.matches(a1.getAttributes(), a2.getAttributes());
    }

    public static boolean matches(Map<String, String> filter, Map<String, String> attributes) {
        for (Map.Entry<String, String> e : filter.entrySet()) {
            String attVal = attributes.get(e.getKey());
            if (e.getValue().equals(attVal)) continue;
            return false;
        }
        return true;
    }

    public static <T extends IAttributeAware> List<T> filter(Collection<T> l, Map<String, String> filter) {
        ArrayList<IAttributeAware> result = new ArrayList<IAttributeAware>();
        for (IAttributeAware aa : l) {
            if (!TraceHelper.matches(filter, aa.getAttributes())) continue;
            result.add(aa);
        }
        return result;
    }

    public static <T extends IAttributeAware> List<T> filter(Collection<T> l, String key, String value) {
        return TraceHelper.filter(l, Collections.singletonMap(key, value));
    }

    public static String represent(IEvent event, boolean includeAttNames, boolean includeAmountOffset) {
        if (event == null) {
            return "<null>";
        }
        StringBuilder b = new StringBuilder();
        TraceHelper.getValues(b, event, includeAttNames);
        if (event instanceof IClaimEvent) {
            IClaimEvent claimEvent = (IClaimEvent)event;
            b.append(",res={");
            IResource resource = claimEvent.getClaim().getResource();
            TraceHelper.getValues(b, resource, includeAttNames);
            if (includeAmountOffset) {
                b.append(",amount=").append(claimEvent.getClaim().getAmount());
                if (resource.useOffset()) {
                    b.append("offset=").append(claimEvent.getClaim().getOffset());
                }
            }
            b.append("}");
            if (claimEvent.getType() == ClaimEventType.START) {
                b.append("S");
            } else {
                b.append("E");
            }
        }
        return b.toString();
    }

    public static String getValues(IAttributeAware aa, boolean includeAttName) {
        return TraceHelper.getValues(aa, aa.getAttributes().keySet(), includeAttName);
    }

    public static String getValues(IAttributeAware aa, Collection<String> atts, boolean includeAttName) {
        StringBuilder b = new StringBuilder();
        TraceHelper.getValues(b, aa, atts, includeAttName);
        return b.toString();
    }

    private static void getValues(StringBuilder b, IAttributeAware aa, boolean includeAttName) {
        TraceHelper.getValues(b, aa, aa.getAttributes().keySet(), includeAttName);
    }

    private static void getValues(StringBuilder b, IAttributeAware aa, Collection<String> atts, boolean includeAttName) {
        ArrayList<String> keys = new ArrayList<String>();
        if (atts != null && atts.size() > 0) {
            keys.addAll(atts);
        } else {
            keys.addAll(aa.getAttributes().keySet());
        }
        Collections.sort(keys);
        boolean addSeparator = false;
        for (String key : keys) {
            String val = aa.getAttributeValue(key);
            if (includeAttName) {
                if (addSeparator) {
                    b.append(",");
                }
                addSeparator = true;
                b.append(key).append("=").append(val);
                continue;
            }
            if (val == null) continue;
            if (addSeparator) {
                b.append(",");
            }
            addSeparator = true;
            b.append(val);
        }
    }
}

