/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpoints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.AbstractSelectionActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.breakpoints.DeleteWorkingsetsMessageDialog;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointContainer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.debug.internal.ui.views.breakpoints.WorkingSetCategory;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class RemoveBreakpointAction
extends AbstractSelectionActionDelegate {
    public void run(IAction action) {
        IStructuredSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        final Iterator itr = selection.iterator();
        CoreException[] exception = new CoreException[1];
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                LinkedHashSet<IBreakpoint> breakpointsToDelete = new LinkedHashSet<IBreakpoint>();
                ArrayList<IWorkingSet> groupsToDelete = new ArrayList<IWorkingSet>();
                boolean deleteAll = false;
                boolean deleteContainer = false;
                boolean prompted = false;
                while (itr.hasNext()) {
                    Object next = itr.next();
                    IBreakpoint breakpoint = (IBreakpoint)DebugPlugin.getAdapter(next, IBreakpoint.class);
                    if (breakpoint != null) {
                        breakpointsToDelete.add(breakpoint);
                        continue;
                    }
                    if (!(next instanceof IBreakpointContainer)) continue;
                    IBreakpointContainer bpc = (IBreakpointContainer)next;
                    if (bpc.getCategory() instanceof WorkingSetCategory) {
                        IWorkingSet set = ((WorkingSetCategory)bpc.getCategory()).getWorkingSet();
                        if (!prompted) {
                            prompted = true;
                            DeleteWorkingsetsMessageDialog dialog = new DeleteWorkingsetsMessageDialog(RemoveBreakpointAction.this.getView().getSite().getShell(), ActionMessages.RemoveBreakpointAction_3, null, ActionMessages.RemoveBreakpointAction_4, 3, new String[]{ActionMessages.RemoveBreakpointAction_5, ActionMessages.RemoveBreakpointAction_6}, 0);
                            if (dialog.open() == 1) {
                                return;
                            }
                            deleteAll = dialog.deleteAllBreakpoints();
                            deleteContainer = dialog.deleteWorkingset();
                        }
                        if (deleteContainer) {
                            groupsToDelete.add(set);
                        }
                    } else if (!prompted) {
                        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
                        prompted = store.getBoolean("org.eclipse.debug.ui.remove_breakpoints_from_container_prompt");
                        if (prompted) {
                            MessageDialogWithToggle mdwt = MessageDialogWithToggle.openYesNoQuestion((Shell)RemoveBreakpointAction.this.getView().getSite().getShell(), (String)ActionMessages.RemoveBreakpointAction_0, (String)ActionMessages.RemoveBreakpointAction_1, (String)ActionMessages.RemoveAllBreakpointsAction_3, (!prompted ? 1 : 0) != 0, null, null);
                            if (mdwt.getReturnCode() == 3) {
                                deleteAll = false;
                            } else {
                                store.setValue("org.eclipse.debug.ui.remove_breakpoints_from_container_prompt", !mdwt.getToggleState());
                                deleteAll = true;
                            }
                        } else {
                            boolean bl = deleteAll = !prompted;
                        }
                    }
                    if (!deleteAll) continue;
                    IBreakpoint[] breakpoints = bpc.getBreakpoints();
                    Collections.addAll(breakpointsToDelete, breakpoints);
                }
                final IBreakpoint[] breakpoints = breakpointsToDelete.toArray(new IBreakpoint[0]);
                final IWorkingSet[] sets = groupsToDelete.toArray(new IWorkingSet[groupsToDelete.size()]);
                if (breakpoints.length > 0) {
                    ((BreakpointsView)RemoveBreakpointAction.this.getView()).preserveSelection(RemoveBreakpointAction.this.getSelection());
                }
                new Job(ActionMessages.RemoveBreakpointAction_2){

                    protected IStatus run(IProgressMonitor pmonitor) {
                        try {
                            Shell shell = RemoveBreakpointAction.this.getView() != null ? RemoveBreakpointAction.this.getView().getSite().getShell() : null;
                            DebugUITools.deleteBreakpoints(breakpoints, shell, pmonitor);
                            IWorkingSet[] iWorkingSetArray = sets;
                            int n = sets.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IWorkingSet set = iWorkingSetArray[n2];
                                PlatformUI.getWorkbench().getWorkingSetManager().removeWorkingSet(set);
                                ++n2;
                            }
                            return Status.OK_STATUS;
                        }
                        catch (CoreException e) {
                            DebugUIPlugin.log(e);
                            return Status.CANCEL_STATUS;
                        }
                    }
                }.schedule();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null, 0, null);
        }
        catch (CoreException ce) {
            exception[0] = ce;
        }
        if (exception[0] != null) {
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                DebugUIPlugin.errorDialog(window.getShell(), ActionMessages.RemoveBreakpointAction_Removing_a_breakpoint_4, ActionMessages.RemoveBreakpointAction_Exceptions_occurred_attempting_to_remove_a_breakpoint__5, exception[0]);
            } else {
                DebugUIPlugin.log(exception[0]);
            }
        }
    }

    @Override
    protected boolean isEnabledFor(Object element) {
        if (element instanceof IBreakpointContainer) {
            if (((IBreakpointContainer)element).getCategory() instanceof WorkingSetCategory) {
                return true;
            }
            return ((IBreakpointContainer)element).getBreakpoints().length > 0;
        }
        return DebugPlugin.getAdapter((Object)element, IBreakpoint.class) != null;
    }
}

