/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.chart.ui.swtchart;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterators;
import java.text.Format;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisSet;
import org.eclipse.swtchart.IAxisTick;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.model.CartesianSeriesModel;
import org.eclipse.swtchart.model.DoubleArraySeriesModel;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartData;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartModel;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartSeries;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartNumericalDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartStringDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.IDescriptorVisitor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.INumericalResolver;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.IStringResolver;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.signal.ChartSelectionUpdateSignal;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.ui.chart.IChartViewer;
import org.eclipse.tracecompass.internal.tmf.chart.core.aggregator.IConsumerAggregator;
import org.eclipse.tracecompass.internal.tmf.chart.core.consumer.IDataConsumer;
import org.eclipse.tracecompass.internal.tmf.chart.core.consumer.NumericalConsumer;
import org.eclipse.tracecompass.internal.tmf.chart.ui.aggregator.NumericalConsumerAggregator;
import org.eclipse.tracecompass.internal.tmf.chart.ui.consumer.ScatterStringConsumer;
import org.eclipse.tracecompass.internal.tmf.chart.ui.consumer.XYChartConsumer;
import org.eclipse.tracecompass.internal.tmf.chart.ui.consumer.XYSeriesConsumer;
import org.eclipse.tracecompass.internal.tmf.chart.ui.data.ChartRangeMap;
import org.eclipse.tracecompass.internal.tmf.chart.ui.dialog.Messages;
import org.eclipse.tracecompass.internal.tmf.chart.ui.format.LabelFormat;
import org.eclipse.tracecompass.internal.tmf.chart.ui.swtchart.SwtChartPoint;
import org.eclipse.tracecompass.internal.tmf.chart.ui.swtchart.SwtXYChartViewer;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;

public final class SwtScatterChart
extends SwtXYChartViewer {
    private static final int SELECTION_SNAP_RANGE_MULTIPLIER = 20;
    private final BiMap<String, Integer> fXStringMap = HashBiMap.create();
    private final BiMap<String, Integer> fYStringMap = HashBiMap.create();
    private ChartRangeMap fXRanges = new ChartRangeMap();
    private ChartRangeMap fYRanges = new ChartRangeMap();
    private BiMap<String, Integer> fVisibleXMap = HashBiMap.create();
    private BiMap<String, Integer> fVisibleYMap = HashBiMap.create();
    private Point fHoveringPoint = new Point(-1, -1);
    private @Nullable SwtChartPoint fHoveredPoint;

    public SwtScatterChart(Composite parent, ChartData data, ChartModel model) {
        super(parent, data, model);
        this.getChart().getPlotArea().getControl().addMouseMoveListener((MouseMoveListener)new MouseHoveringListener());
        this.getChart().getPlotArea().getControl().addListener(7, (Listener)new MouseExitListener());
        this.getChart().getPlotArea().getControl().addMouseListener((MouseListener)new MouseDownListener());
        this.getChart().getPlotArea().getControl().addPaintListener((PaintListener)new ScatterPainterListener());
        this.populate();
    }

    @Override
    protected IDataConsumer getXConsumer(@NonNull ChartSeries series) {
        ConsumerCreatorVisitor visitor = new ConsumerCreatorVisitor(this.getModel().isXLogscale(), this.fXStringMap);
        series.getX().accept((IDescriptorVisitor)visitor);
        return visitor.getConsumer();
    }

    @Override
    protected IDataConsumer getYConsumer(@NonNull ChartSeries series) {
        ConsumerCreatorVisitor visitor = new ConsumerCreatorVisitor(this.getModel().isYLogscale(), this.fYStringMap);
        series.getY().accept((IDescriptorVisitor)visitor);
        return visitor.getConsumer();
    }

    @Override
    protected @Nullable IConsumerAggregator getXAggregator() {
        if (this.getXDescriptorsInfo().areNumerical()) {
            return new NumericalConsumerAggregator();
        }
        return null;
    }

    @Override
    protected @Nullable IConsumerAggregator getYAggregator() {
        if (this.getYDescriptorsInfo().areNumerical()) {
            return new NumericalConsumerAggregator();
        }
        return null;
    }

    @Override
    protected ISeries createSwtSeries(ChartSeries chartSeries, ISeriesSet swtSeriesSet, @NonNull Color color) {
        String title = chartSeries.getY().getName();
        if (this.getXDescriptors().stream().distinct().count() > 1L) {
            title = NLS.bind((String)Messages.ChartSeries_MultiSeriesTitle, (Object)title, (Object)chartSeries.getX().getLabel());
        }
        ILineSeries swtSeries = (ILineSeries)swtSeriesSet.createSeries(ISeries.SeriesType.LINE, title);
        swtSeries.setLineStyle(LineStyle.NONE);
        swtSeries.setSymbolColor(color);
        return swtSeries;
    }

    @Override
    protected void configureSeries(Map<@NonNull ISeries, Object[]> mapper) {
        NumericalConsumerAggregator yAggregator;
        XYChartConsumer chartConsumer = this.getChartConsumer();
        NumericalConsumerAggregator xAggregator = (NumericalConsumerAggregator)chartConsumer.getXAggregator();
        if (xAggregator != null) {
            this.fXRanges = this.getModel().isXLogscale() ? SwtScatterChart.clampInputDataRange(xAggregator.getChartRanges()) : xAggregator.getChartRanges();
        }
        if ((yAggregator = (NumericalConsumerAggregator)chartConsumer.getYAggregator()) != null) {
            this.fYRanges = this.getModel().isYLogscale() ? SwtScatterChart.clampInputDataRange(yAggregator.getChartRanges()) : yAggregator.getChartRanges();
        }
        for (XYSeriesConsumer seriesConsumer : chartConsumer.getSeries()) {
            double[] yData;
            int i;
            List<String> list;
            double[] xData;
            List data;
            Object consumer;
            Object[] object = seriesConsumer.getConsumedElements().toArray();
            if (this.getXDescriptorsInfo().areNumerical()) {
                consumer = (NumericalConsumer)seriesConsumer.getXConsumer();
                data = consumer.getData();
                int size = data.size();
                xData = new double[size];
                int i2 = 0;
                while (i2 < size) {
                    Number number = (Number)NonNullUtils.checkNotNull((Object)((Number)data.get(i2)));
                    xData[i2] = this.fXRanges.getInternalValue(number).doubleValue();
                    ++i2;
                }
            } else {
                consumer = (ScatterStringConsumer)seriesConsumer.getXConsumer();
                list = ((ScatterStringConsumer)consumer).getList();
                xData = new double[list.size()];
                i = 0;
                while (i < xData.length) {
                    String str = list.get(i);
                    xData[i] = ((Integer)NonNullUtils.checkNotNull((Object)((Integer)this.fXStringMap.get((Object)str)))).intValue();
                    ++i;
                }
            }
            if (this.getYDescriptorsInfo().areNumerical()) {
                consumer = (NumericalConsumer)seriesConsumer.getYConsumer();
                data = consumer.getData();
                yData = new double[data.size()];
                i = 0;
                while (i < yData.length) {
                    Number number = (Number)NonNullUtils.checkNotNull((Object)((Number)data.get(i)));
                    yData[i] = this.fYRanges.getInternalValue(number).doubleValue();
                    ++i;
                }
            } else {
                consumer = (ScatterStringConsumer)seriesConsumer.getYConsumer();
                list = ((ScatterStringConsumer)consumer).getList();
                yData = new double[list.size()];
                i = 0;
                while (i < yData.length) {
                    String str = list.get(i);
                    yData[i] = ((Integer)NonNullUtils.checkNotNull((Object)((Integer)this.fYStringMap.get((Object)str)))).intValue();
                    ++i;
                }
            }
            ISeries series = (ISeries)NonNullUtils.checkNotNull((Object)this.getSeriesMap().get(seriesConsumer.getSeries()));
            series.setDataModel((CartesianSeriesModel)new DoubleArraySeriesModel(xData, yData));
            mapper.put(series, (Object[])NonNullUtils.checkNotNull((Object)object));
        }
    }

    @Override
    protected void configureAxes() {
        Stream.of(this.getChart().getAxisSet().getXAxes()).forEach(a -> {
            Format format;
            IAxisTick tick = (IAxisTick)NonNullUtils.checkNotNull((Object)a.getTick());
            if (this.getXDescriptorsInfo().areNumerical()) {
                format = SwtScatterChart.getContinuousAxisFormatter(this.fXRanges, this.getXDescriptorsInfo());
            } else {
                this.fVisibleXMap = HashBiMap.create(this.fXStringMap);
                format = new LabelFormat(this.fVisibleXMap);
                SwtScatterChart.updateTickMark(this.fVisibleXMap, tick, this.getChart().getPlotArea().getSize().x);
            }
            tick.setFormat(format);
        });
        Stream.of(this.getChart().getAxisSet().getYAxes()).forEach(a -> {
            Format format;
            IAxisTick tick = (IAxisTick)NonNullUtils.checkNotNull((Object)a.getTick());
            if (this.getYDescriptorsInfo().areNumerical()) {
                format = SwtScatterChart.getContinuousAxisFormatter(this.fYRanges, this.getYDescriptorsInfo());
            } else {
                this.fVisibleYMap = HashBiMap.create(this.fYStringMap);
                format = new LabelFormat(this.fVisibleYMap);
                SwtScatterChart.updateTickMark(this.fVisibleYMap, tick, this.getChart().getPlotArea().getSize().y);
            }
            tick.setFormat(format);
        });
    }

    @Override
    protected void refreshDisplayLabels() {
        Chart chart = this.getChart();
        IAxisSet axisSet = chart.getAxisSet();
        IAxis xAxis = axisSet.getXAxis(0);
        if (!xAxis.getTick().isVisible()) {
            return;
        }
        Rectangle rect = chart.getClientArea();
        int lengthLimit = (int)((double)rect.height * 0.4);
        GC gc = new GC((Drawable)this.getParent());
        gc.setFont(xAxis.getTick().getFont());
        if (!this.fXStringMap.isEmpty()) {
            String longestString = Collections.max(this.fXStringMap.keySet(), Comparator.comparingInt(String::length));
            Point pixels = gc.stringExtent(longestString);
            int cutLen = 5;
            if (pixels.x > lengthLimit) {
                for (Map.Entry entry : this.fXStringMap.entrySet()) {
                    String reference = (String)NonNullUtils.checkNotNull((Object)((String)entry.getKey()));
                    if (reference.length() > cutLen) {
                        String key = String.valueOf(reference.substring(0, cutLen)) + '\u2026';
                        this.fVisibleXMap.remove((Object)reference);
                        this.fVisibleXMap.put((Object)key, (Object)((Integer)entry.getValue()));
                        continue;
                    }
                    this.fVisibleXMap.inverse().remove(entry.getValue());
                    this.fVisibleXMap.put((Object)reference, (Object)((Integer)entry.getValue()));
                }
            } else {
                SwtScatterChart.resetBiMap(this.fXStringMap, this.fVisibleXMap);
            }
            IAxis[] iAxisArray = axisSet.getXAxes();
            int n = iAxisArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAxis axis = iAxisArray[n2];
                IAxisTick tick = axis.getTick();
                tick.setFormat((Format)new LabelFormat(this.fVisibleXMap));
                ++n2;
            }
        }
        gc.dispose();
    }

    @Override
    protected void setSelection(@NonNull Set<@NonNull Object> set) {
        super.setSelection(set);
        Iterator colorsIt = Iterators.cycle((Iterable)COLORS);
        Iterator lightColorsIt = Iterators.cycle((Iterable)COLORS_LIGHT);
        ISeries[] iSeriesArray = this.getChart().getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            Color lightColor = (Color)NonNullUtils.checkNotNull((Object)((Color)lightColorsIt.next()));
            Color color = (Color)NonNullUtils.checkNotNull((Object)((Color)colorsIt.next()));
            if (set.isEmpty()) {
                ((ILineSeries)series).setSymbolColor(color);
            } else {
                ((ILineSeries)series).setSymbolColor(lightColor);
            }
            ++n2;
        }
    }

    public static <K, V> void resetBiMap(BiMap<K, V> reference, BiMap<K, V> map) {
        map.clear();
        map.putAll(reference);
    }

    private class ConsumerCreatorVisitor
    implements IDescriptorVisitor {
        private final boolean fLogScale;
        private final BiMap<String, Integer> fMap;
        private @Nullable IDataConsumer fConsumer;

        ConsumerCreatorVisitor(boolean logScale, BiMap<String, Integer> bimap) {
            this.fLogScale = logScale;
            this.fMap = bimap;
        }

        public void visit(@NonNull DataChartStringDescriptor<?> desc) {
            this.fConsumer = new ScatterStringConsumer((IStringResolver<Object>)((IStringResolver)IStringResolver.class.cast(desc.getResolver())), this.fMap);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public void visit(@NonNull DataChartNumericalDescriptor<?, ? extends @NonNull Number> desc) {
            INumericalResolver resolver = (INumericalResolver)INumericalResolver.class.cast(desc.getResolver());
            @Nullable SwtXYChartViewer.LogarithmicPredicate predicate = this.fLogScale ? new SwtXYChartViewer.LogarithmicPredicate(resolver) : Objects::nonNull;
            this.fConsumer = new NumericalConsumer(resolver, (Predicate)predicate);
        }

        public IDataConsumer getConsumer() {
            IDataConsumer consumer = this.fConsumer;
            if (consumer == null) {
                throw new NullPointerException("The getConsumer method of the visitor should not be called before visiting a descriptor");
            }
            return consumer;
        }
    }

    private final class MouseDownListener
    extends MouseAdapter {
        private MouseDownListener() {
        }

        public void mouseDown(@Nullable MouseEvent event) {
            if (event == null || event.button != 1) {
                return;
            }
            SwtChartPoint selection = SwtScatterChart.this.fHoveredPoint;
            if (selection == null) {
                SwtScatterChart.this.getSelection().clear();
            } else {
                boolean ctrl = (event.stateMask & 0x40000) != 0;
                SwtScatterChart.this.getSelection().touch(selection, ctrl);
            }
            SwtScatterChart.this.refresh();
            HashSet<Object> set = new HashSet<Object>();
            for (SwtChartPoint point : SwtScatterChart.this.getSelection().getPoints()) {
                Object[] objects = (Object[])NonNullUtils.checkNotNull((Object)SwtScatterChart.this.getObjectMap().get(point.getSeries()));
                Object obj = objects[point.getIndex()];
                if (obj == null) continue;
                set.add(obj);
            }
            SwtScatterChart.this.setSelection(set);
            ChartSelectionUpdateSignal signal = new ChartSelectionUpdateSignal((Object)SwtScatterChart.this, SwtScatterChart.this.getData().getDataProvider(), set);
            TmfSignalManager.dispatchSignal((TmfSignal)signal);
        }
    }

    private final class MouseExitListener
    implements Listener {
        private MouseExitListener() {
        }

        public void handleEvent(@Nullable Event event) {
            if (event != null) {
                ((SwtScatterChart)SwtScatterChart.this).fHoveringPoint.x = -1;
                ((SwtScatterChart)SwtScatterChart.this).fHoveringPoint.y = -1;
                SwtScatterChart.this.fHoveredPoint = null;
                SwtScatterChart.this.refresh();
            }
        }
    }

    private final class MouseHoveringListener
    implements MouseMoveListener {
        private MouseHoveringListener() {
        }

        public void mouseMove(@Nullable MouseEvent event) {
            if (event == null) {
                return;
            }
            double closestDistance = -1.0;
            boolean found = false;
            ISeries[] iSeriesArray = SwtScatterChart.this.getChart().getSeriesSet().getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries swtSeries = iSeriesArray[n2];
                ILineSeries series = (ILineSeries)swtSeries;
                Iterator iterator = series.getDataModel().iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    Point dataPoint = series.getPixelCoordinates(i);
                    int snapRangeRadius = series.getSymbolSize() * 20;
                    double distance = Math.hypot(dataPoint.x - event.x, dataPoint.y - event.y);
                    if (!(distance < (double)snapRangeRadius) || closestDistance != -1.0 && !(distance < closestDistance)) continue;
                    ((SwtScatterChart)SwtScatterChart.this).fHoveringPoint.x = dataPoint.x;
                    ((SwtScatterChart)SwtScatterChart.this).fHoveringPoint.y = dataPoint.y;
                    SwtScatterChart.this.fHoveredPoint = new SwtChartPoint((ISeries)series, i);
                    closestDistance = distance;
                    found = true;
                }
                ++n2;
            }
            if (!found) {
                SwtScatterChart.this.fHoveredPoint = null;
            }
            SwtScatterChart.this.refresh();
        }
    }

    private final class ScatterPainterListener
    implements PaintListener {
        private ScatterPainterListener() {
        }

        public void paintControl(@Nullable PaintEvent event) {
            if (event == null) {
                return;
            }
            GC gc = event.gc;
            if (gc == null) {
                return;
            }
            this.drawHoveringCross(gc);
            if (!SwtScatterChart.this.getSelection().getPoints().isEmpty()) {
                this.drawSelectedDot(gc);
            }
        }

        private void drawHoveringCross(GC gc) {
            if (SwtScatterChart.this.fHoveredPoint == null) {
                return;
            }
            gc.setLineWidth(1);
            gc.setLineStyle(1);
            gc.setForeground(Display.getCurrent().getSystemColor(2));
            gc.setBackground(Display.getCurrent().getSystemColor(1));
            gc.drawLine(((SwtScatterChart)SwtScatterChart.this).fHoveringPoint.x, 0, ((SwtScatterChart)SwtScatterChart.this).fHoveringPoint.x, SwtScatterChart.this.getChart().getPlotArea().getSize().y);
            gc.drawLine(0, ((SwtScatterChart)SwtScatterChart.this).fHoveringPoint.y, SwtScatterChart.this.getChart().getPlotArea().getSize().x, ((SwtScatterChart)SwtScatterChart.this).fHoveringPoint.y);
        }

        private void drawSelectedDot(GC gc) {
            for (SwtChartPoint point : SwtScatterChart.this.getSelection().getPoints()) {
                ISeries series = point.getSeries();
                Point coor = series.getPixelCoordinates(point.getIndex());
                int symbolSize = ((ILineSeries)series).getSymbolSize();
                Color symbolColor = ((ILineSeries)series).getSymbolColor();
                if (symbolColor == null) continue;
                Color darkColor = IChartViewer.getCorrespondingColor(symbolColor);
                gc.setBackground(darkColor);
                gc.fillOval(coor.x - symbolSize, coor.y - symbolSize, symbolSize * 2, symbolSize * 2);
                gc.setLineWidth(2);
                gc.setLineStyle(1);
                int drawingDelta = 2 * symbolSize;
                gc.drawLine(coor.x, coor.y - drawingDelta, coor.x, coor.y + drawingDelta);
                gc.drawLine(coor.x - drawingDelta, coor.y, coor.x + drawingDelta, coor.y);
            }
        }
    }
}

