/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.io.IOException;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.internal.dialogs.FileEditorsPreferencePage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.registry.UnassociatedEditorStrategyRegistry;

public class ExtendedFileEditorsPreferencePage
extends FileEditorsPreferencePage {
    private IPreferenceStore idePreferenceStore;

    protected Composite createContents(Composite parent) {
        Composite res = (Composite)super.createContents(parent);
        final UnassociatedEditorStrategyRegistry registry = IDEWorkbenchPlugin.getDefault().getUnassociatedEditorStrategyRegistry();
        Composite defaultStrategyComposite = new Composite(res, 0);
        Optional<Control> cLink = Stream.of(res.getChildren()).filter(c -> c instanceof Link).findFirst();
        defaultStrategyComposite.moveBelow(cLink.get());
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        defaultStrategyComposite.setLayout((Layout)layout);
        defaultStrategyComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label unknownTypeStrategyLabel = new Label(defaultStrategyComposite, 0);
        unknownTypeStrategyLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        unknownTypeStrategyLabel.setText(IDEWorkbenchMessages.ExtendedFileEditorsPreferencePage_strategyForUnassociatedFiles);
        ComboViewer viewer = new ComboViewer(defaultStrategyComposite);
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object o) {
                String id = (String)o;
                String label = registry.getLabel(id);
                if (label != null) {
                    return label;
                }
                IDEWorkbenchPlugin.log("Could not resolve unknownEditorStrategy '" + id + "'");
                return NLS.bind((String)IDEWorkbenchMessages.ExtendedFileEditorsPreferencePage_labelNotResolved, (Object)id);
            }
        });
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput(registry.retrieveAllStrategies());
        this.idePreferenceStore = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        viewer.setSelection((ISelection)new StructuredSelection((Object)this.idePreferenceStore.getString("unassociatedEditorStrategy")));
        viewer.addSelectionChangedListener(event -> this.idePreferenceStore.setValue("unassociatedEditorStrategy", (String)event.getStructuredSelection().getFirstElement()));
        return res;
    }

    public boolean performOk() {
        if (this.idePreferenceStore != null && this.idePreferenceStore.needsSaving() && this.idePreferenceStore instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)this.idePreferenceStore).save();
            }
            catch (IOException e) {
                String message = JFaceResources.format((String)"PreferenceDialog.saveErrorMessage", (Object[])new Object[]{this.getTitle(), e.getMessage()});
                Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.jface", message, (Throwable)e), JFaceResources.getString((String)"PreferenceDialog.saveErrorTitle"));
            }
        }
        return super.performOk();
    }

    public void performDefaults() {
        super.performDefaults();
        this.idePreferenceStore.setToDefault("unassociatedEditorStrategy");
    }
}

