/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.executioncomparison.ui;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICallGraphProvider2;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTreeProvider;
import org.eclipse.tracecompass.incubator.internal.executioncomparison.core.DifferentialSeqCallGraphAnalysis;
import org.eclipse.tracecompass.incubator.internal.executioncomparison.ui.Activator;
import org.eclipse.tracecompass.incubator.internal.executioncomparison.ui.Messages;
import org.eclipse.tracecompass.internal.analysis.profiling.core.flamegraph.FlameGraphDataProvider;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.FlameChartEntryModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TmfFilterAppliedSignal;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TraceCompassFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.widgets.timegraph.BaseDataProviderTimeGraphPresentationProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.model.IOutputElement;
import org.eclipse.tracecompass.tmf.core.model.ITimeElement;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.TmfUiRefreshHandler;
import org.eclipse.tracecompass.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.tracecompass.tmf.ui.symbols.TmfSymbolProviderUpdatedSignal;
import org.eclipse.tracecompass.tmf.ui.views.SaveImageUtil;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NamedTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class DifferentialFlameGraphView
extends TmfView {
    public static final String ID = DifferentialFlameGraphView.class.getPackage().getName() + ".diffflamegraphView";
    private static final int DEFAULT_BUFFER_SIZE = 3;
    private static final String DIRTY_UNDERFLOW = "Dirty underflow";
    protected static final Logger LOGGER = Logger.getLogger(DifferentialFlameGraphView.class.getName());
    private @Nullable DifferentialWeightedTreeProvider<?> fDataProvider;
    private @Nullable TimeGraphViewer fTimeGraphViewer;
    private @Nullable BaseDataProviderTimeGraphPresentationProvider fPresentationProvider;
    private @Nullable ITmfTrace fTrace = null;
    private final Semaphore fLock = new Semaphore(1);
    private final AtomicInteger fDirty = new AtomicInteger();
    private final Map<ITmfTrace, Job> fBuildJobMap = new HashMap<ITmfTrace, Job>();
    private final Map<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Map<Long, TimeGraphEntry>> fEntries = new HashMap<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Map<Long, TimeGraphEntry>>();
    private Set<TimeGraphEntry> fVisibleEntries = Collections.emptySet();
    private long fEndTime = Long.MIN_VALUE;
    private final Map<ITmfTrace, List<TimeGraphEntry>> fEntryListMap = new HashMap<ITmfTrace, List<TimeGraphEntry>>();
    private int fDisplayWidth;
    private @Nullable ZoomThread fZoomThread;
    private final Object fZoomThreadResultLock = new Object();
    private Semaphore fBuildEntryLock = new Semaphore(1);

    public DifferentialFlameGraphView() {
        this(ID);
    }

    protected DifferentialFlameGraphView(String id) {
        super(id);
    }

    public void createPartControl(@Nullable Composite parent) {
        super.createPartControl(parent);
        this.fDisplayWidth = Display.getDefault().getBounds().width;
        final TimeGraphViewer timeGraphViewer = new TimeGraphViewer(parent, 0);
        this.fPresentationProvider = new BaseDataProviderTimeGraphPresentationProvider();
        timeGraphViewer.setTimeGraphProvider((ITimeGraphPresentationProvider)this.fPresentationProvider);
        timeGraphViewer.setTimeFormat(Utils.TimeFormat.NUMBER);
        IEditorPart editor = this.getSite().getPage().getActiveEditor();
        ITmfTrace trace = DifferentialFlameGraphView.getCurrentTrace(editor);
        if (trace != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
        TmfSignalManager.register((Object)((Object)this));
        this.getSite().setSelectionProvider(timeGraphViewer.getSelectionProvider());
        timeGraphViewer.getTimeGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(@Nullable MouseEvent e) {
                DifferentialFlameGraphView.handleDoubleClick(timeGraphViewer);
            }
        });
        timeGraphViewer.addRangeListener(event -> this.startZoomThread(event.getStartTime(), event.getEndTime(), false, timeGraphViewer));
        final TimeGraphControl timeGraphControl = timeGraphViewer.getTimeGraphControl();
        timeGraphControl.addPaintListener(new PaintListener(){

            public void paintControl(@Nullable PaintEvent e) {
                TmfUiRefreshHandler.getInstance().queueUpdate((Object)this, () -> {
                    if (timeGraphControl.isDisposed()) {
                        return;
                    }
                    Set<TimeGraphEntry> newSet = DifferentialFlameGraphView.getVisibleItems(3, timeGraphViewer);
                    if (!DifferentialFlameGraphView.this.fVisibleEntries.equals(newSet)) {
                        DifferentialFlameGraphView.this.fVisibleEntries = newSet;
                        DifferentialFlameGraphView.this.startZoomThread(timeGraphViewer.getTime0(), timeGraphViewer.getTime1(), false, timeGraphViewer);
                    }
                });
            }
        });
        this.fTimeGraphViewer = timeGraphViewer;
    }

    private static void handleDoubleClick(TimeGraphViewer timeGraphViewer) {
        TimeGraphControl timeGraphControl = timeGraphViewer.getTimeGraphControl();
        ISelection selection = timeGraphControl.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object object : structuredSelection.toList()) {
                if (!(object instanceof TimeEvent)) continue;
                TimeEvent event = (TimeEvent)object;
                long startTime = event.getTime();
                long endTime = startTime + event.getDuration();
                timeGraphViewer.setStartFinishTime(startTime, endTime);
                break;
            }
        }
    }

    private static @Nullable ITmfTrace getCurrentTrace(@Nullable IEditorPart editor) {
        ITmfTrace trace = null;
        trace = editor instanceof ITmfTraceEditor ? ((ITmfTraceEditor)editor).getTrace() : TmfTraceManager.getInstance().getActiveTrace();
        return trace;
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.ScopeLog sl = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, "DifferentialFlameGraphView::traceSelected", new Object[0]);){
            ITmfTrace trace;
            this.fTrace = trace = signal.getTrace();
            if (trace == null) {
                return;
            }
            List<TimeGraphEntry> list = this.fEntryListMap.get(trace);
            if (list == null) {
                this.refresh();
                Display.getDefault().asyncExec(() -> this.buildFlameGraph(trace, null, null));
            } else {
                long endTime = Long.MIN_VALUE;
                for (TimeGraphEntry entry : list) {
                    endTime = Math.max(endTime, entry.getEndTime());
                }
                this.fEndTime = endTime;
                this.refresh();
                if (this.fTimeGraphViewer != null) {
                    this.startZoomThread(0L, endTime, false, this.fTimeGraphViewer);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected Iterable<ICallGraphProvider2> getCallgraphModules() {
        ITmfTrace trace = this.fTrace;
        if (trace == null) {
            return Collections.emptyList();
        }
        String analysisId = NonNullUtils.nullToEmptyString((Object)this.getViewSite().getSecondaryId());
        Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ICallGraphProvider2.class);
        return StreamSupport.stream(modules.spliterator(), false).filter(m -> {
            if (m instanceof IAnalysisModule) {
                return ((IAnalysisModule)m).getId().equals(analysisId);
            }
            return true;
        }).collect(Collectors.toSet());
    }

    private static BiFunction<ITimeEvent, Long, Map<String, String>> getTooltipResolver(ITimeGraphDataProvider<? extends TimeGraphEntryModel> provider) {
        return (event, time) -> DifferentialFlameGraphView.getTooltip(event, time, provider, false);
    }

    private static Map<String, String> getTooltip(ITimeEvent event, Long time, ITimeGraphDataProvider<? extends TimeGraphEntryModel> provider, boolean getActions) {
        TmfModelResponse response;
        Map tooltip;
        ITimeGraphEntry entry = event.getEntry();
        if (!(entry instanceof TimeGraphEntry)) {
            return Collections.emptyMap();
        }
        long entryId = ((TimeGraphEntry)entry).getEntryModel().getId();
        ITimeElement element = null;
        if (event instanceof TimeEvent) {
            element = ((TimeEvent)event).getModel();
        }
        Map<String, Object> parameters = DifferentialFlameGraphView.getFetchTooltipParameters(time, entryId, (IOutputElement)element);
        if (getActions) {
            parameters.put("actions", true);
        }
        return (tooltip = (Map)(response = provider.fetchTooltip(parameters, (IProgressMonitor)new NullProgressMonitor())).getModel()) == null ? Collections.emptyMap() : tooltip;
    }

    private static Map<String, Object> getFetchTooltipParameters(long time, long item, @Nullable IOutputElement element) {
        @NonNull HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("requested_times", Collections.singletonList(time));
        parameters.put("requested_items", Collections.singletonList(item));
        if (element != null) {
            parameters.put("requested_element", element);
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void startZoomThread(long startTime, long endTime, boolean force, TimeGraphViewer timeGraphViewer) {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        this.fDirty.incrementAndGet();
        try {
            Throwable throwable = null;
            Object var9_8 = null;
            try {
                long clampedEndTime;
                long clampedStartTime;
                TraceCompassLogUtils.FlowScopeLog log;
                block21: {
                    log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameGraphView:ZoomThreadCreated", new Object[0]).setCategory(this.getViewId()).build();
                    clampedStartTime = Math.max(0L, Math.min(startTime, this.fEndTime));
                    clampedEndTime = Math.min(this.fEndTime, Math.max(endTime, 0L));
                    if (clampedEndTime >= clampedStartTime) break block21;
                    if (log == null) return;
                    log.close();
                    return;
                }
                try {
                    int timeSpace;
                    ZoomThread zoomThread = this.fZoomThread;
                    if (zoomThread != null) {
                        zoomThread.cancel();
                    }
                    if ((timeSpace = timeGraphViewer.getTimeSpace()) > 0) {
                        long resolution = Long.max(1L, (clampedEndTime - clampedStartTime) / (long)timeSpace);
                        zoomThread = new ZoomThread(DifferentialFlameGraphView.getVisibleItems(3, timeGraphViewer), clampedStartTime, clampedEndTime, resolution, force);
                    } else {
                        zoomThread = null;
                    }
                    this.fZoomThread = zoomThread;
                    if (zoomThread == null) return;
                    zoomThread.setScopeId(log.getId());
                    Object object = this.fZoomThreadResultLock;
                    synchronized (object) {
                        zoomThread.start();
                        this.fDirty.incrementAndGet();
                        return;
                    }
                }
                finally {
                    if (log != null) {
                        log.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        finally {
            if (this.fDirty.decrementAndGet() < 0) {
                Activator.getDefault().getLog().error(DIRTY_UNDERFLOW, new Throwable());
            }
        }
    }

    private static Set<TimeGraphEntry> getVisibleItems(int buffer, TimeGraphViewer timeGraphViewer) {
        TimeGraphControl timeGraphControl = timeGraphViewer.getTimeGraphControl();
        if (timeGraphControl.isDisposed()) {
            return Collections.emptySet();
        }
        int start = Integer.max(0, timeGraphViewer.getTopIndex() - buffer);
        int end = Integer.min(timeGraphViewer.getExpandedElementCount() - 1, timeGraphViewer.getTopIndex() + timeGraphControl.countPerPage() + buffer);
        HashSet<TimeGraphEntry> visible = new HashSet<TimeGraphEntry>(end - start + 1);
        int i = start;
        while (i <= end) {
            TimeGraphEntry element = (TimeGraphEntry)timeGraphControl.getExpandedElement(i);
            if (element != null) {
                visible.add(element);
            }
            ++i;
        }
        return visible;
    }

    private void zoomEntries(Iterable<TimeGraphEntry> normalEntries, long zoomStartTime, long zoomEndTime, long resolution, IProgressMonitor monitor) {
        if (resolution < 0L) {
            return;
        }
        long start = Long.min(zoomStartTime, zoomEndTime);
        long end = Long.max(zoomStartTime, zoomEndTime);
        List times = StateSystemUtils.getTimes((long)start, (long)end, (long)resolution);
        Multimap<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Long> providersToModelIds = DifferentialFlameGraphView.filterGroupEntries(normalEntries, zoomStartTime, zoomEndTime);
        if (providersToModelIds != null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)(((Object)((Object)this)).getClass().getSimpleName() + "#zoomEntries"), (int)providersToModelIds.size());
            Map.Entry entry = providersToModelIds.asMap().entrySet().iterator().next();
            ITimeGraphDataProvider dataProvider = Objects.requireNonNull((ITimeGraphDataProvider)entry.getKey());
            SelectionTimeQueryFilter filter = new SelectionTimeQueryFilter(times, (Collection)entry.getValue());
            Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter);
            Multimap<Integer, String> regexesMap = this.getRegexes();
            if (regexesMap != null && !regexesMap.isEmpty()) {
                parameters.put("regex_map_filters", Objects.requireNonNull(regexesMap.asMap()));
            }
            TmfModelResponse response = dataProvider.fetchRowModel(parameters, monitor);
            TimeGraphModel model = (TimeGraphModel)response.getModel();
            Map<Long, TimeGraphEntry> entries = this.fEntries.get(dataProvider);
            if (model != null && entries != null) {
                this.zoomEntries(entries, model.getRows());
            }
            subMonitor.worked(1);
            this.redraw();
        }
    }

    private @Nullable Multimap<Integer, String> getRegexes() {
        HashMultimap regexes = HashMultimap.create();
        if (regexes != null) {
            ITmfTrace trace = this.getTrace();
            if (trace == null) {
                return regexes;
            }
            TraceCompassFilter globalFilter = TraceCompassFilter.getFilterForTrace((ITmfTrace)trace);
            if (globalFilter == null) {
                return regexes;
            }
            regexes.putAll((Object)1, (Iterable)globalFilter.getRegexes());
        }
        return regexes;
    }

    private void zoomEntries(Map<Long, TimeGraphEntry> map, List<ITimeGraphRowModel> model) {
        for (ITimeGraphRowModel rowModel : model) {
            TimeGraphEntry entry = map.get(rowModel.getEntryID());
            if (entry == null) continue;
            List<ITimeEvent> events = this.createTimeEvents(entry, rowModel.getStates());
            entry.setEventList(events);
        }
    }

    private List<ITimeEvent> createTimeEvents(TimeGraphEntry entry, List<ITimeGraphState> values) {
        ArrayList<ITimeEvent> events = new ArrayList<ITimeEvent>(values.size());
        TimeEvent prev = null;
        for (ITimeGraphState state : values) {
            long prevEnd;
            TimeEvent event = this.createTimeEvent(entry, state);
            if (prev != null && (prevEnd = prev.getTime() + prev.getDuration()) < event.getTime()) {
                TimeEvent timeEvent = new TimeEvent((ITimeGraphEntry)entry, prevEnd, event.getTime() - prevEnd);
                events.add((ITimeEvent)timeEvent);
            }
            prev = event;
            events.add((ITimeEvent)event);
        }
        return events;
    }

    protected TimeEvent createTimeEvent(TimeGraphEntry entry, ITimeGraphState state) {
        String label = state.getLabel();
        if (state.getValue() == Integer.MIN_VALUE && label == null && state.getStyle() == null) {
            return new NullTimeEvent((ITimeGraphEntry)entry, state.getStartTime(), state.getDuration());
        }
        if (label != null) {
            return new NamedTimeEvent((ITimeGraphEntry)entry, label, state);
        }
        return new TimeEvent((ITimeGraphEntry)entry, (ITimeElement)state);
    }

    private static @Nullable Multimap<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Long> filterGroupEntries(Iterable<TimeGraphEntry> visible, long zoomStartTime, long zoomEndTime) {
        HashMultimap providersToModelIds = HashMultimap.create();
        for (TimeGraphEntry entry : visible) {
            if (zoomStartTime > entry.getEndTime() || zoomEndTime < entry.getStartTime() || !entry.hasTimeEvents()) continue;
            ITimeGraphDataProvider<? extends TimeGraphEntryModel> provider = DifferentialFlameGraphView.getProvider((ITimeGraphEntry)entry);
            providersToModelIds.put(provider, (Object)entry.getEntryModel().getId());
        }
        return providersToModelIds;
    }

    public static ITimeGraphDataProvider<? extends TimeGraphEntryModel> getProvider(ITimeGraphEntry entry) {
        ITimeGraphEntry parent = entry;
        while (parent != null) {
            if (parent instanceof ParentEntry) {
                return ((ParentEntry)parent).getProvider();
            }
            parent = parent.getParent();
        }
        throw new IllegalStateException(String.valueOf(entry) + " should have a TraceEntry parent");
    }

    protected @Nullable ITmfTrace getTrace() {
        return this.fTrace;
    }

    private void refresh() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TraceCompassLogUtils.FlowScopeLog parentLogger = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameGraphView:RefreshRequested", new Object[0]).setCategory(this.getViewId()).build();){
            boolean isZoomThread = Thread.currentThread() instanceof ZoomThread;
            TmfUiRefreshHandler.getInstance().queueUpdate((Object)this, () -> this.lambda$4(parentLogger, isZoomThread));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void redraw() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TraceCompassLogUtils.FlowScopeLog flowParent = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameGraphView:RedrawRequested", new Object[0]).setCategory(this.getViewId()).build();){
            Display.getDefault().asyncExec(() -> {
                Throwable throwable = null;
                Object var3_4 = null;
                try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameGraphView:Redraw", new Object[0]).setParentScope(flowParent).build();){
                    if (this.fTimeGraphViewer != null && this.fTimeGraphViewer.getControl().isDisposed()) {
                        return;
                    }
                    if (this.fTimeGraphViewer != null) {
                        this.fTimeGraphViewer.getControl().redraw();
                        if (this.fTimeGraphViewer != null) {
                            this.fTimeGraphViewer.getControl().update();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetEntries(ITmfTrace trace) {
        Map<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Map<Long, TimeGraphEntry>> map = this.fEntries;
        synchronized (map) {
            Map<ITmfTrace, List<TimeGraphEntry>> map2 = this.fEntryListMap;
            synchronized (map2) {
                List<TimeGraphEntry> entries = this.fEntryListMap.remove(trace);
                if (entries == null) {
                    return;
                }
                for (TimeGraphEntry entry : entries) {
                    if (!(entry instanceof ParentEntry)) continue;
                    this.fEntries.remove(((ParentEntry)entry).getProvider());
                }
                this.refresh();
            }
        }
    }

    public void buildFlameGraph(final ITmfTrace viewTrace, final @Nullable ITmfTimestamp selStart, final @Nullable ITmfTimestamp selEnd) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (final TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DifferentialFlameGraphView:Building", new Object[0]).setCategory(this.getViewId()).build();){
            Job buildJob;
            try {
                this.fLock.acquire();
            }
            catch (InterruptedException e) {
                Activator.getDefault().getLog().error(e.getMessage(), (Throwable)e);
                this.fLock.release();
            }
            IWorkbenchSiteProgressService service = null;
            IWorkbenchPartSite site = this.getSite();
            if (site != null) {
                service = Objects.requireNonNull((IWorkbenchSiteProgressService)site.getService(IWorkbenchSiteProgressService.class));
            }
            if ((buildJob = this.fBuildJobMap.remove(viewTrace)) != null) {
                buildJob.cancel();
            }
            this.resetEntries(viewTrace);
            buildJob = new Job(this.getTitle() + Messages.flameGraphViewRetrievingData){

                protected IStatus run(@Nullable IProgressMonitor monitor) {
                    Objects.requireNonNull(monitor);
                    new BuildRunnable(viewTrace, viewTrace, selStart, selEnd, log).run(monitor);
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            this.fBuildJobMap.put(viewTrace, buildJob);
            if (service != null) {
                service.schedule(buildJob);
            } else {
                buildJob.schedule();
            }
            this.fLock.release();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean isDirty() throws InterruptedException {
        this.fLock.acquire();
        this.fLock.release();
        return this.fDirty.get() != 0;
    }

    public void setTrace(ITmfTrace trace) {
        this.fTrace = trace;
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (signal.getTrace() == this.fTrace && this.fTimeGraphViewer != null) {
            this.fTimeGraphViewer.setInput(null);
        }
    }

    public void setFocus() {
        if (this.fTimeGraphViewer != null) {
            this.fTimeGraphViewer.setFocus();
        }
    }

    @TmfSignalHandler
    public void symbolMapUpdated(TmfSymbolProviderUpdatedSignal signal) {
        if (signal.getSource() != this && this.fTimeGraphViewer != null) {
            TimeGraphViewer timeGraphViewer = this.fTimeGraphViewer;
            this.startZoomThread(timeGraphViewer.getTime0(), timeGraphViewer.getTime1(), true, timeGraphViewer);
        }
    }

    protected @Nullable IAction createSaveAction() {
        if (this.fTimeGraphViewer != null) {
            return SaveImageUtil.createSaveAction((String)this.getName(), () -> this.fTimeGraphViewer);
        }
        return null;
    }

    public void restartZoomThread() {
        ZoomThread zoomThread = this.fZoomThread;
        if (zoomThread != null) {
            zoomThread.cancel();
            this.fZoomThread = null;
        }
        if (this.fTimeGraphViewer != null) {
            TimeGraphViewer timeGraphViewer = this.fTimeGraphViewer;
            this.startZoomThread(timeGraphViewer.getTime0(), timeGraphViewer.getTime1(), true, timeGraphViewer);
        }
    }

    @TmfSignalHandler
    public void regexFilterApplied(TmfFilterAppliedSignal signal) {
        Display.getDefault().asyncExec(this::restartZoomThread);
    }

    private static @Nullable DifferentialWeightedTreeProvider<?> getDataProvider(IProgressMonitor monitor) {
        DifferentialSeqCallGraphAnalysis analysis;
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null && (analysis = (DifferentialSeqCallGraphAnalysis)trace.getAnalysisModule("org.eclipse.tracecompass.incubator.executioncomparison.diffcallgraph")) != null) {
            return analysis.getDifferentialTreeProvider(monitor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void lambda$4(TraceCompassLogUtils.FlowScopeLog var1_1, boolean var2_2) {
        block25: {
            block26: {
                var3_3 = null;
                var4_5 = null;
                try {
                    block23: {
                        log = new TraceCompassLogUtils.FlowScopeLogBuilder(DifferentialFlameGraphView.LOGGER, Level.FINE, "FlameGraphView:Refresh", new Object[0]).setParentScope(var1_1).build();
                        this.fDirty.incrementAndGet();
                        if (this.fTimeGraphViewer != null && this.fTimeGraphViewer.getControl().isDisposed()) {
                            if (log == null) break block23;
                        }
                        ** GOTO lbl-1000
                        log.close();
                    }
                    if (this.fDirty.decrementAndGet() >= 0) return;
                }
                catch (Throwable var4_6) {
                    if (var3_3 == null) {
                        var3_3 = var4_6;
                        throw var3_3;
                    }
                    if (var3_3 == var4_6) throw var3_3;
                    var3_3.addSuppressed(var4_6);
                    throw var3_3;
                }
                Activator.getDefault().getLog().error("Dirty underflow", new Throwable());
                return;
lbl-1000:
                // 1 sources

                {
                    var7_8 = this.fEntryListMap;
                    synchronized (var7_8) {
                        entries = this.fEntryListMap.get(this.getTrace());
                        if (entries == null) {
                            entries = new CopyOnWriteArrayList<TimeGraphEntry>();
                        }
                    }
                    if (this.fTimeGraphViewer == null) return;
                    v1 = inputChanged = entries != this.fTimeGraphViewer.getInput();
                    if (inputChanged && this.fTimeGraphViewer != null) {
                        this.fTimeGraphViewer.setInput(entries);
                        break block25;
                    }
                    if (!inputChanged && this.fTimeGraphViewer != null) {
                        this.fTimeGraphViewer.refresh();
                        break block25;
                    }
                    if (log == null) break block26;
                }
                log.close();
            }
            if (this.fDirty.decrementAndGet() >= 0) return;
            Activator.getDefault().getLog().error("Dirty underflow", new Throwable());
            return;
        }
        ** try [egrp 8[TRYBLOCK] [4 : 266->335)] { 
lbl56:
        // 1 sources

        startBound = 0L;
        endBound = this.fEndTime;
        v2 = endBound = endBound == -9223372036854775808L ? -1L : endBound;
        if (this.fTimeGraphViewer != null) {
            this.fTimeGraphViewer.setTimeBounds(startBound, endBound);
        }
        if (inputChanged == false) return;
        if (var2_2 != false) return;
        if (this.fTimeGraphViewer == null) return;
        this.fTimeGraphViewer.resetStartFinishTime();
        return;
lbl66:
        // 1 sources

        finally {
            if (log != null) {
                log.close();
            }
        }
    }

    private class BuildRunnable {
        private final ITmfTrace fBuildTrace;
        private final ITmfTrace fParentTrace;
        private final TraceCompassLogUtils.FlowScopeLog fScope;
        private final Map<String, Object> fParameters;

        public BuildRunnable(ITmfTrace trace, @Nullable ITmfTrace parentTrace, @Nullable ITmfTimestamp selStart, ITmfTimestamp selEnd, TraceCompassLogUtils.FlowScopeLog log) {
            this.fBuildTrace = trace;
            this.fParentTrace = parentTrace;
            this.fScope = log;
            this.fParameters = selStart != null && selEnd != null ? ImmutableMap.of((Object)"selection_range", (Object)ImmutableList.of((Object)selStart.toNanos(), (Object)selEnd.toNanos())) : Collections.emptyMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(IProgressMonitor monitor) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameGraphView:BuildThread", new Object[]{"trace", this.fBuildTrace.getName()}).setParentScope(this.fScope).build();){
                this.buildEntryList(this.fBuildTrace, this.fParentTrace, this.fParameters, Objects.requireNonNull(monitor));
                Map<ITmfTrace, Job> map = DifferentialFlameGraphView.this.fBuildJobMap;
                synchronized (map) {
                    DifferentialFlameGraphView.this.fBuildJobMap.remove(this.fBuildTrace);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private void buildEntryList(@Nullable ITmfTrace trace, ITmfTrace parentTrace, Map<String, Object> additionalParams, IProgressMonitor monitor) {
            if (trace != null) {
                DifferentialWeightedTreeProvider<?> dataProvider = DifferentialFlameGraphView.getDataProvider(monitor);
                if (dataProvider == null) {
                    return;
                }
                DifferentialFlameGraphView.this.fDataProvider = dataProvider;
                @NonNull FlameGraphDataProvider dataProviderGroup = new FlameGraphDataProvider(trace, DifferentialFlameGraphView.this.fDataProvider, "org.eclipse.tracecompass.analysis.profiling.core.flamegraph:org.eclipse.tracecompass.incubator.executioncomparison.diffcallgraph");
                BaseDataProviderTimeGraphPresentationProvider presentationProvider = DifferentialFlameGraphView.this.fPresentationProvider;
                if (presentationProvider != null) {
                    presentationProvider.addProvider((ITimeGraphDataProvider)dataProviderGroup, DifferentialFlameGraphView.getTooltipResolver((ITimeGraphDataProvider<? extends TimeGraphEntryModel>)dataProviderGroup));
                }
                this.fetchAndBuildEntries(trace, parentTrace, additionalParams, monitor, (ITimeGraphDataProvider<FlameChartEntryModel>)dataProviderGroup);
            }
        }

        /*
         * Exception decompiling
         */
        private void fetchAndBuildEntries(@Nullable ITmfTrace trace, ITmfTrace parentTrace, Map<String, Object> additionalParams, IProgressMonitor monitor, ITimeGraphDataProvider<@NonNull FlameChartEntryModel> dataProviderGroup) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 17[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processAndDisplayEntries(TmfTreeModel<@NonNull FlameChartEntryModel> groupAModel, ITmfTrace parentTrace, IProgressMonitor monitor, ITimeGraphDataProvider<@NonNull FlameChartEntryModel> dataProviderGroup) {
            Map entries;
            Map<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Map<Long, TimeGraphEntry>> map = DifferentialFlameGraphView.this.fEntries;
            synchronized (map) {
                entries = DifferentialFlameGraphView.this.fEntries.computeIfAbsent(dataProviderGroup, dp -> new HashMap());
                ArrayList<TimeGraphEntry> orphaned = new ArrayList<TimeGraphEntry>();
                for (TimeGraphEntryModel entry : groupAModel.getEntries()) {
                    if (entry.getParentId() != -1L) {
                        this.updateOrCreateOrphanedEntry(entry, entries, orphaned, monitor);
                        continue;
                    }
                    this.updateOrCreateEntry(entry, entries, parentTrace, monitor, dataProviderGroup);
                }
                this.findMissingParents(entries, orphaned);
            }
            long start = 0L;
            long resolutionN = Long.max(1L, (DifferentialFlameGraphView.this.fEndTime - start) / (long)this.getDisplayWidth());
            if (!monitor.isCanceled()) {
                DifferentialFlameGraphView.this.zoomEntries((Iterable<TimeGraphEntry>)ImmutableList.copyOf(entries.values()), start, DifferentialFlameGraphView.this.fEndTime, resolutionN, monitor);
            }
        }

        private void updateOrCreateOrphanedEntry(TimeGraphEntryModel entry, Map<Long, TimeGraphEntry> entries, List<TimeGraphEntry> orphaned, IProgressMonitor monitor) {
            TimeGraphEntry uiEntry = entries.get(entry.getId());
            if (uiEntry == null) {
                uiEntry = new TimeGraphEntry(entry);
                TimeGraphEntry parent = entries.get(entry.getParentId());
                if (parent != null) {
                    parent.addChild(uiEntry);
                } else {
                    orphaned.add(uiEntry);
                }
                entries.put(entry.getId(), uiEntry);
            } else if (!monitor.isCanceled()) {
                uiEntry.updateModel(entry);
            }
        }

        private void updateOrCreateEntry(TimeGraphEntryModel entry, Map<Long, TimeGraphEntry> entries, ITmfTrace parentTrace, IProgressMonitor monitor, ITimeGraphDataProvider<@NonNull FlameChartEntryModel> dataProviderGroup) {
            long endTimeN = DifferentialFlameGraphView.this.fEndTime;
            TimeGraphEntry uiEntry = entries.get(entry.getId());
            DifferentialFlameGraphView.this.fEndTime = Long.max(endTimeN, entry.getEndTime() + 1L);
            ArrayList<String> lables = new ArrayList<String>();
            lables.add("GroupB-GroupA");
            TimeGraphEntryModel newEntry = new TimeGraphEntryModel(0L, -1L, lables, entry.getStartTime(), entry.getEndTime(), entry.hasRowModel());
            if (uiEntry != null) {
                if (!monitor.isCanceled()) {
                    uiEntry.updateModel(newEntry);
                }
            } else {
                uiEntry = new ParentEntry(newEntry, dataProviderGroup);
                entries.put(entry.getId(), uiEntry);
                this.addToEntryList(parentTrace, Collections.singletonList(uiEntry));
            }
        }

        private void findMissingParents(Map<Long, TimeGraphEntry> entries, List<TimeGraphEntry> orphaned) {
            for (TimeGraphEntry orphanedEntry : orphaned) {
                TimeGraphEntry parent = entries.get(orphanedEntry.getEntryModel().getParentId());
                if (parent == null) continue;
                parent.addChild(orphanedEntry);
            }
        }

        private void waitForDataProvider() throws InterruptedException {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Activator.getDefault().getLog().error("Failed to wait for data provider", (Throwable)e);
                throw e;
            }
        }

        private int getDisplayWidth() {
            int displayWidth = DifferentialFlameGraphView.this.fDisplayWidth;
            return displayWidth <= 0 ? 1 : displayWidth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addToEntryList(ITmfTrace trace, List<TimeGraphEntry> list) {
            Map<ITmfTrace, List<TimeGraphEntry>> map = DifferentialFlameGraphView.this.fEntryListMap;
            synchronized (map) {
                List<TimeGraphEntry> entryList = DifferentialFlameGraphView.this.fEntryListMap.get(trace);
                if (entryList == null) {
                    DifferentialFlameGraphView.this.fEntryListMap.put(trace, new CopyOnWriteArrayList<TimeGraphEntry>(list));
                } else {
                    for (TimeGraphEntry entry : list) {
                        if (entryList.contains(entry)) continue;
                        entryList.add(entry);
                    }
                }
            }
        }
    }

    private static class ParentEntry
    extends TimeGraphEntry {
        private final ITimeGraphDataProvider<? extends TimeGraphEntryModel> fProvider;

        public ParentEntry(TimeGraphEntryModel model, ITimeGraphDataProvider<? extends TimeGraphEntryModel> provider) {
            super(model);
            this.fProvider = provider;
        }

        public ITimeGraphDataProvider<? extends TimeGraphEntryModel> getProvider() {
            return this.fProvider;
        }
    }

    protected class ZoomThread
    extends Thread {
        private final long fZoomStartTime;
        private final long fZoomEndTime;
        private final long fResolution;
        private int fScopeId;
        private final IProgressMonitor fMonitor;
        private Collection<TimeGraphEntry> fCurrentEntries;
        private boolean fForce;

        public ZoomThread(Collection<TimeGraphEntry> entries, long startTime, long endTime, long resolution, boolean force) {
            super(DifferentialFlameGraphView.this.getName() + " zoom");
            this.fScopeId = -1;
            this.fZoomStartTime = startTime;
            this.fZoomEndTime = endTime;
            this.fResolution = resolution;
            this.fCurrentEntries = entries;
            this.fMonitor = new NullProgressMonitor();
            this.fForce = force;
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            try {
                Throwable throwable = null;
                Object var2_3 = null;
                try {
                    TraceCompassLogUtils.FlowScopeLog log;
                    block14: {
                        log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameGraphView:ZoomThread", new Object[]{"start", this.fZoomStartTime, "end", this.fZoomEndTime}).setCategoryAndId(DifferentialFlameGraphView.this.getViewId(), this.fScopeId).build();
                        if (!this.fCurrentEntries.isEmpty()) break block14;
                        if (log == null) return;
                        log.close();
                        return;
                    }
                    try {
                        TimeGraphEntry.Sampling sampling = new TimeGraphEntry.Sampling(this.fZoomStartTime, this.fZoomEndTime, this.fResolution);
                        Collection<TimeGraphEntry> incorrectSample = this.fForce ? this.fCurrentEntries : (Iterable)this.fCurrentEntries.stream().filter(entry -> !sampling.equals((Object)entry.getSampling())).collect(Collectors.toList());
                        Objects.requireNonNull(incorrectSample);
                        DifferentialFlameGraphView.this.zoomEntries(incorrectSample, this.fZoomStartTime, this.fZoomEndTime, this.fResolution, this.fMonitor);
                        return;
                    }
                    finally {
                        if (log != null) {
                            log.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            finally {
                if (DifferentialFlameGraphView.this.fDirty.decrementAndGet() < 0) {
                    Activator.getDefault().getLog().error(DifferentialFlameGraphView.DIRTY_UNDERFLOW, new Throwable());
                }
            }
        }

        public void setScopeId(int scopeId) {
            this.fScopeId = scopeId;
        }
    }
}

