/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.tools;

import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.debug.dwarf.Dwarf;
import org.eclipse.cdt.utils.debug.stabs.Stabs;
import org.eclipse.cdt.utils.debug.tools.DebugSym;
import org.eclipse.cdt.utils.debug.tools.DebugSymsRequestor;
import org.eclipse.cdt.utils.elf.Elf;

public class DebugAddr2line {
    DebugSymsRequestor symreq;

    public DebugAddr2line(String file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Elf elf = new Elf(file);){
            this.init(elf);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public DebugAddr2line(Elf elf) throws IOException {
        this.init(elf);
    }

    void init(Elf elf) throws IOException {
        block12: {
            this.symreq = new DebugSymsRequestor();
            Elf.Attribute attribute = elf.getAttributes();
            int type = attribute.getDebugType();
            if (type == 1) {
                Stabs stabs = new Stabs(elf);
                stabs.parse(this.symreq);
            } else {
                if (type == 2) {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (Dwarf dwarf = new Dwarf(elf);){
                        dwarf.parse(this.symreq);
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                throw new IOException(CCorePlugin.getResourceString("Util.unknownFormat"));
            }
        }
    }

    public void dispose() {
    }

    public int getStartLine(long address) throws IOException {
        DebugSym entry = this.symreq.getEntry(address);
        if (entry != null) {
            return entry.startLine;
        }
        return 0;
    }

    public int getEndLine(long address) throws IOException {
        DebugSym entry = this.symreq.getEntry(address);
        if (entry != null) {
            return entry.endLine;
        }
        return 0;
    }

    public String getFunction(long address) throws IOException {
        DebugSym entry = this.symreq.getEntry(address);
        if (entry != null) {
            return entry.name;
        }
        return null;
    }

    public String getFileName(long address) throws IOException {
        DebugSym entry = this.symreq.getEntry(address);
        if (entry != null) {
            return entry.filename;
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            DebugAddr2line addr2line = new DebugAddr2line(args[0]);
            long address = Integer.decode(args[1]).longValue();
            int startLine = addr2line.getStartLine(address);
            int endLine = addr2line.getEndLine(address);
            String function = addr2line.getFunction(address);
            String filename = addr2line.getFileName(address);
            System.out.println(Long.toHexString(address));
            System.out.println(filename + ":" + function + ":" + startLine + ":" + endLine);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

