/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.signal;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

@NonNullByDefault
public class TmfSelectionRangeUpdatedSignal
extends TmfSignal {
    private final ITmfTimestamp fBeginTime;
    private final ITmfTimestamp fEndTime;
    private final @Nullable ITmfTrace fTrace;

    public TmfSelectionRangeUpdatedSignal(@Nullable Object source, ITmfTimestamp ts) {
        this(source, ts, ts, TmfTraceManager.getInstance().getActiveTrace());
    }

    public TmfSelectionRangeUpdatedSignal(@Nullable Object source, ITmfTimestamp begin, ITmfTimestamp end) {
        this(source, begin, end, TmfTraceManager.getInstance().getActiveTrace());
    }

    public TmfSelectionRangeUpdatedSignal(@Nullable Object source, ITmfTimestamp begin, ITmfTimestamp end, @Nullable ITmfTrace trace) {
        super(source);
        this.fBeginTime = begin;
        this.fEndTime = end;
        this.fTrace = trace;
    }

    public ITmfTimestamp getBeginTime() {
        return this.fBeginTime;
    }

    public ITmfTimestamp getEndTime() {
        return this.fEndTime;
    }

    public @Nullable ITmfTrace getTrace() {
        return this.fTrace;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        sb.append(this.fBeginTime.toString());
        if (!this.fBeginTime.equals(this.fEndTime)) {
            sb.append('-');
            sb.append(this.fEndTime.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

