/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.callstack.core.instrumented.statesystem;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.AggregatedCallSite;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IDataPalette;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeGroupDescriptor;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.incubator.callstack.core.base.EdgeStateValue;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.CallGraph;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.ICallGraphProvider;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.SymbolAspect;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.IFlameChartProvider;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.statesystem.CallStackHostUtils;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.statesystem.CallStackSeries;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.FunctionTidAspect;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph.CallGraphAnalysis;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

@Deprecated(since="0.10.0", forRemoval=true)
public abstract class InstrumentedCallStackAnalysis
extends TmfStateSystemAnalysisModule
implements IFlameChartProvider,
ICallGraphProvider {
    public static final String CALL_STACK = "CallStack";
    private static final String[] DEFAULT_PROCESSES_PATTERN = new String[]{"Processes", "*"};
    private static final String[] DEFAULT_THREADS_PATTERN = new String[]{"*"};
    private static final List<String[]> PATTERNS = ImmutableList.of((Object)DEFAULT_PROCESSES_PATTERN, (Object)DEFAULT_THREADS_PATTERN);
    private @Nullable CallStackSeries fCallStacks;
    private final CallGraphAnalysis fCallGraph;
    private final ListenerList<IAnalysisProgressListener> fListeners = new ListenerList(1);
    private boolean fAutomaticCallgraph = true;

    protected InstrumentedCallStackAnalysis() {
        this.fCallGraph = new CallGraphAnalysis(this);
    }

    public boolean setTrace(@NonNull ITmfTrace trace) throws TmfAnalysisException {
        if (!super.setTrace(trace)) {
            return false;
        }
        return this.fCallGraph.setTrace(trace);
    }

    public void setName(String name) {
        super.setName(name);
        this.fCallGraph.setName(name);
    }

    @Override
    public synchronized @Nullable CallStackSeries getCallStackSeries() {
        CallStackSeries callstacks = this.fCallStacks;
        if (callstacks == null) {
            ITmfStateSystem ss = this.getStateSystem();
            ITmfTrace trace = this.getTrace();
            if (ss == null || trace == null) {
                return null;
            }
            this.fCallStacks = callstacks = new CallStackSeries(ss, this.getPatterns(), 0, "", this.getCallStackHostResolver(trace), this.getCallStackTidResolver());
        }
        return callstacks;
    }

    protected CallStackHostUtils.TraceHostIdResolver getCallStackHostResolver(ITmfTrace trace) {
        return new CallStackHostUtils.TraceHostIdResolver(trace);
    }

    protected @Nullable CallStackSeries.IThreadIdResolver getCallStackTidResolver() {
        return new CallStackSeries.AttributeValueThreadResolver(1);
    }

    protected boolean executeAnalysis(@Nullable IProgressMonitor monitor) {
        this.fCallGraph.setId(this.getId());
        boolean ret = super.executeAnalysis(monitor);
        if (!ret) {
            return ret;
        }
        ISegmentStore<ISegment> segmentStore = this.getSegmentStore();
        if (segmentStore != null) {
            this.sendUpdate(segmentStore);
        }
        if (this.fAutomaticCallgraph) {
            this.fCallGraph.schedule();
        }
        return true;
    }

    protected List<String[]> getPatterns() {
        return PATTERNS;
    }

    @Override
    public @NonNull String getHostId() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return "";
        }
        return trace.getHostId();
    }

    public List<ITmfStateInterval> getLinks(long start, long end, IProgressMonitor monitor) {
        ITmfStateSystem ss = this.getStateSystem();
        if (ss == null) {
            return Collections.emptyList();
        }
        Collection<Integer> quarks = this.getEdgeQuarks();
        if (quarks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ITmfStateInterval> list = new ArrayList<ITmfStateInterval>();
        try {
            for (ITmfStateInterval interval : ss.query2D(quarks, start, end)) {
                Object value = interval.getValue();
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                if (!(value instanceof EdgeStateValue)) continue;
                list.add(interval);
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException e) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public CallGraph getCallGraph(ITmfTimestamp start, ITmfTimestamp end) {
        this.fCallGraph.schedule();
        this.fCallGraph.waitForCompletion();
        return this.fCallGraph.getCallGraph(start, end);
    }

    @Override
    public CallGraph getCallGraph() {
        this.fCallGraph.schedule();
        this.fCallGraph.waitForCompletion();
        return this.fCallGraph.getCallGraph();
    }

    @Override
    public Collection<IWeightedTreeGroupDescriptor> getGroupDescriptors() {
        this.fCallGraph.schedule();
        this.fCallGraph.waitForCompletion();
        return this.fCallGraph.getGroupDescriptors();
    }

    public String getTitle() {
        return this.fCallGraph.getTitle();
    }

    public void dispose() {
        super.dispose();
        this.fCallGraph.dispose();
    }

    @Override
    public AggregatedCallSite createCallSite(Object symbol) {
        return this.fCallGraph.createCallSite(symbol);
    }

    public @Nullable ISegmentStore<ISegment> getSegmentStore() {
        CallStackSeries series = this.getCallStackSeries();
        if (series == null) {
            return null;
        }
        return series;
    }

    public void addListener(@NonNull IAnalysisProgressListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeListener(@NonNull IAnalysisProgressListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public Iterable<ISegmentAspect> getSegmentAspects() {
        if (this.getCallStackTidResolver() != null) {
            return ImmutableList.of((Object)FunctionTidAspect.TID_ASPECT, (Object)SymbolAspect.SYMBOL_ASPECT);
        }
        return Collections.singletonList(SymbolAspect.SYMBOL_ASPECT);
    }

    protected Iterable<IAnalysisProgressListener> getListeners() {
        ArrayList<IAnalysisProgressListener> listeners = new ArrayList<IAnalysisProgressListener>();
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener != null) {
                listeners.add((IAnalysisProgressListener)listener);
            }
            ++n2;
        }
        return listeners;
    }

    protected void sendUpdate(ISegmentStore<ISegment> store) {
        for (IAnalysisProgressListener listener : this.getListeners()) {
            listener.onComplete((ISegmentStoreProvider)this, store);
        }
    }

    public void triggerAutomatically(boolean trigger) {
        this.fAutomaticCallgraph = trigger;
    }

    protected Collection<Integer> getEdgeQuarks() {
        return Collections.emptyList();
    }

    @Override
    public boolean isComplete() {
        if (!this.waitForInitialization()) {
            return true;
        }
        ITmfStateSystem stateSystem = this.getStateSystem();
        if (stateSystem == null) {
            throw new IllegalStateException("The initialiation is complete, so the state system must not be null");
        }
        return stateSystem.waitUntilBuilt(0L);
    }

    @Override
    public long getEnd() {
        if (!this.waitForInitialization()) {
            return Integer.MIN_VALUE;
        }
        ITmfStateSystem stateSystem = this.getStateSystem();
        if (stateSystem == null) {
            throw new IllegalStateException("The initialiation is complete, so the state system must not be null");
        }
        return stateSystem.getCurrentEndTime();
    }

    public @NonNull List<@NonNull String> getExtraDataSets() {
        return this.fCallGraph.getExtraDataSets();
    }

    public IWeightedTreeProvider.MetricType getWeightType() {
        return this.fCallGraph.getWeightType();
    }

    public List<IWeightedTreeProvider.MetricType> getAdditionalMetrics() {
        return this.fCallGraph.getAdditionalMetrics();
    }

    public String toDisplayString(AggregatedCallSite object) {
        return this.fCallGraph.toDisplayString(object);
    }

    public Object getAdditionalMetric(AggregatedCallSite object, int metricIndex) {
        return this.fCallGraph.getAdditionalMetric(object, metricIndex);
    }

    @Override
    public IDataPalette getPalette() {
        this.fCallGraph.schedule();
        return this.fCallGraph.getPalette();
    }
}

