/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.analysis.core.model.IHostModel;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.ICalledFunction;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph.AbstractCalledFunction;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph.CalledFunction;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph.CalledStringFunction;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph.Messages;

public final class CalledFunctionFactory {
    private CalledFunctionFactory() {
    }

    public static AbstractCalledFunction create(long start, long end, @Nullable Object symbolValue, int processId, int threadId, @Nullable ICalledFunction parent, IHostModel model) {
        if (symbolValue == null) {
            throw new IllegalArgumentException("Symbol value is null");
        }
        if (symbolValue instanceof Number) {
            return CalledFunctionFactory.create(start, end, ((Number)symbolValue).longValue(), processId, threadId, parent, model);
        }
        return CalledFunctionFactory.create(start, end, String.valueOf(symbolValue), processId, threadId, parent, model);
    }

    private static CalledFunction create(long start, long end, long value, int processId, int threadId, @Nullable ICalledFunction parent, IHostModel model) {
        if (start > end) {
            throw new IllegalArgumentException(Messages.TimeError + "[" + start + "," + end + "]");
        }
        return new CalledFunction(start, end, value, processId, threadId, parent, model);
    }

    public static CalledStringFunction create(long start, long end, String value, int processId, int threadId, @Nullable ICalledFunction parent, IHostModel model) {
        if (start > end) {
            throw new IllegalArgumentException(Messages.TimeError + "[" + start + "," + end + "]");
        }
        return new CalledStringFunction(start, end, value, processId, threadId, parent, model);
    }
}

