/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.Map;

final class Es6RenameReferences
extends NodeTraversal.AbstractPostOrderCallback {
    private final Map<Node, Map<String, String>> renameMap;

    Es6RenameReferences(Map<Node, Map<String, String>> renameMap) {
        this.renameMap = renameMap;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo info;
        if (NodeUtil.isReferenceName(n)) {
            this.renameReference(t, n);
        }
        if ((info = n.getJSDocInfo()) != null) {
            this.renameTypeNode(t, info.getTypeNodes());
        }
    }

    private void renameTypeNode(NodeTraversal t, Iterable<Node> typeNodes) {
        for (Node type : typeNodes) {
            if (type.isString()) {
                this.renameReference(t, type);
            }
            this.renameTypeNode(t, type.children());
        }
    }

    private void renameReference(NodeTraversal t, Node n) {
        Scope referencedIn = t.getScope();
        String oldName = n.getString();
        boolean doRename = false;
        String newName = null;
        for (Scope current = referencedIn; current != null; current = current.getParent()) {
            Map<String, String> renamesAtCurrentLevel = this.renameMap.get(current.getRootNode());
            if (renamesAtCurrentLevel != null && renamesAtCurrentLevel.containsKey(oldName)) {
                doRename = true;
                newName = renamesAtCurrentLevel.get(oldName);
                break;
            }
            if (!current.isDeclared(oldName, false)) continue;
            return;
        }
        if (doRename) {
            n.setString(newName);
            t.getCompiler().reportCodeChange();
        }
    }
}

