/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.core.flamegraph;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.AllGroupDescriptor;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IDataPalette;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.ITree;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeGroupDescriptor;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeSet;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.WeightedTree;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.WeightedTreeGroupBy;
import org.eclipse.tracecompass.incubator.internal.callstack.core.flamegraph.DataProviderUtils;
import org.eclipse.tracecompass.incubator.internal.callstack.core.flamegraph.Messages;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.provider.FlameChartEntryModel;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.CustomStateValue;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class FlameGraphDataProvider<@NonNull N, E, @NonNull T extends WeightedTree<@NonNull N>>
extends AbstractTmfTraceDataProvider
implements ITimeGraphDataProvider<FlameChartEntryModel>,
IOutputStyleProvider {
    public static final String ID = "org.eclipse.tracecompass.incubator.internal.callstack.core.flamegraph.provider";
    public static final String GROUP_BY_KEY = "group_by";
    public static final String SELECTION_RANGE_KEY = "selection_range";
    public static final String TOOLTIP_ACTION_KEY = "actions";
    private static final AtomicLong ENTRY_ID = new AtomicLong();
    private final Comparator<WeightedTree<N>> CCT_COMPARATOR2 = Comparator.comparing(WeightedTree::getWeight).thenComparing(s -> String.valueOf(s.getObject()));
    private static final Logger LOGGER = TraceCompassLog.getLogger(FlameGraphDataProvider.class);
    private static final String FUNCTION_LEVEL = "::Function";
    private final IWeightedTreeProvider<N, E, T> fWtProvider;
    private final String fAnalysisId;
    private final long fTraceId = ENTRY_ID.getAndIncrement();
    private final ReentrantReadWriteLock fLock = new ReentrantReadWriteLock(false);
    private @Nullable Pair<CacheKey, TmfModelResponse<TmfTreeModel<FlameChartEntryModel>>> fCached;
    private final Map<Long, FlameChartEntryModel> fEntries = new HashMap<Long, FlameChartEntryModel>();
    private final Map<Long, WeightedTreeEntry> fCgEntries = new HashMap<Long, WeightedTreeEntry>();
    private final Map<Long, Long> fEndTimes = new HashMap<Long, Long>();

    public FlameGraphDataProvider(ITmfTrace trace, IWeightedTreeProvider<N, E, T> module, String secondaryId) {
        super(trace);
        this.fWtProvider = module;
        this.fAnalysisId = secondaryId;
    }

    public String getId() {
        return this.fAnalysisId;
    }

    /*
     * Exception decompiling
     */
    public @NonNull TmfModelResponse<@NonNull TmfTreeModel<@NonNull FlameChartEntryModel>> fetchTree(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private @Nullable IWeightedTreeSet<N, Object, WeightedTree<N>> getCallGraph(Map<String, Object> fetchParameters, SubMonitor subMonitor) {
        IWeightedTreeSet callGraph;
        IWeightedTreeProvider<N, E, T> wtProvider = this.fWtProvider;
        if (wtProvider instanceof IAnalysisModule) {
            ((IAnalysisModule)wtProvider).waitForCompletion((IProgressMonitor)subMonitor);
        }
        if (subMonitor.isCanceled()) {
            return null;
        }
        List selectionRange = DataProviderParameterUtils.extractLongList(fetchParameters, (String)SELECTION_RANGE_KEY);
        if (selectionRange == null || selectionRange.size() != 2) {
            callGraph = wtProvider.getTreeSet();
        } else {
            long time0 = (Long)selectionRange.get(0);
            long time1 = (Long)selectionRange.get(1);
            callGraph = wtProvider.getSelection(TmfTimestamp.fromNanos((long)Math.min(time0, time1)), TmfTimestamp.fromNanos((long)Math.max(time0, time1)));
        }
        if (callGraph == null) {
            return null;
        }
        IWeightedTreeGroupDescriptor groupDescriptor = FlameGraphDataProvider.extractGroupDescriptor(fetchParameters, wtProvider);
        if (groupDescriptor != null) {
            return WeightedTreeGroupBy.groupWeightedTreeBy((IWeightedTreeGroupDescriptor)groupDescriptor, (IWeightedTreeSet)callGraph, wtProvider);
        }
        return callGraph;
    }

    private static @Nullable IWeightedTreeGroupDescriptor extractGroupDescriptor(Map<String, Object> fetchParameters, IWeightedTreeProvider<?, ?, ?> fcProvider) {
        Object groupBy = fetchParameters.get(GROUP_BY_KEY);
        if (groupBy == null) {
            return null;
        }
        String groupName = String.valueOf(groupBy);
        if (groupName.equals(AllGroupDescriptor.getInstance().getName())) {
            return AllGroupDescriptor.getInstance();
        }
        IWeightedTreeGroupDescriptor groupDescriptor = fcProvider.getGroupDescriptor();
        while (groupDescriptor != null) {
            if (groupDescriptor.getName().equals(groupName)) {
                return groupDescriptor;
            }
            groupDescriptor = groupDescriptor.getNextGroup();
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void buildWeightedTreeEntries(IWeightedTreeSet<N, Object, WeightedTree<N>> callGraph, List<FlameChartEntryModel.Builder> builder, FlameChartEntryModel.Builder traceEntry) {
        IWeightedTreeProvider<N, E, T> wtProvider = this.fWtProvider;
        @NonNull Collection elements = callGraph.getElements();
        for (Object element : elements) {
            this.buildChildrenEntries(element, wtProvider, callGraph, builder, traceEntry);
        }
    }

    private ITmfStateSystem elementToStateSystem(IWeightedTreeProvider<N, E, T> wtProvider, IWeightedTreeSet<N, Object, WeightedTree<N>> callGraph, Object element) {
        IStateHistoryBackend backend = StateHistoryBackendFactory.createInMemoryBackend((String)"org.eclipse.tracecompass.incubator.callgraph.ss", (long)0L);
        ITmfStateSystemBuilder ssb = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
        ArrayList<WeightedTree<N>> rootFunctions = new ArrayList<WeightedTree<N>>(callGraph.getTreesFor(element));
        rootFunctions.sort(this.CCT_COMPARATOR2);
        int quarkFct = ssb.getQuarkAbsoluteAndAdd(new String[]{FUNCTION_LEVEL});
        ArrayDeque<Long> timestampStack = new ArrayDeque<Long>();
        timestampStack.push(0L);
        for (WeightedTree weightedTree : rootFunctions) {
            this.recursivelyAddChildren(wtProvider, ssb, quarkFct, weightedTree, timestampStack);
        }
        Long l = (Long)timestampStack.pop();
        ssb.closeHistory(l.longValue());
        return ssb;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void recursivelyAddChildren(IWeightedTreeProvider<N, E, T> wtProvider, ITmfStateSystemBuilder ssb, int quarkFct, WeightedTree<N> callSite, Deque<Long> timestampStack) {
        Long lastEnd = timestampStack.peek();
        if (lastEnd == null) {
            return;
        }
        ssb.pushAttribute(lastEnd.longValue(), new CalleeCustomValue<N>(callSite), quarkFct);
        timestampStack.push(lastEnd);
        ArrayList<WeightedTree<N>> children = new ArrayList<WeightedTree<N>>(callSite.getChildren());
        children.sort(this.CCT_COMPARATOR2);
        for (WeightedTree weightedTree : children) {
            this.recursivelyAddChildren(wtProvider, ssb, quarkFct, weightedTree, timestampStack);
        }
        timestampStack.pop();
        List list = wtProvider.getExtraDataSets();
        int i = 0;
        while (i < list.size()) {
            @NonNull Collection extraDataTrees = callSite.getExtraDataTrees(i);
            if (!extraDataTrees.isEmpty()) {
                String dataSetName = (String)list.get(i);
                int quarkExtra = ssb.getQuarkAbsoluteAndAdd(new String[]{dataSetName});
                long extraStartTime = lastEnd;
                for (WeightedTree extraTree : extraDataTrees) {
                    ssb.modifyAttribute(extraStartTime, new CalleeCustomValue(extraTree), quarkExtra);
                    extraStartTime += extraTree.getWeight();
                }
            }
            ++i;
        }
        long currentEnd = timestampStack.pop() + callSite.getWeight();
        timestampStack.push(currentEnd);
        ssb.popAttribute(currentEnd, quarkFct);
    }

    private void buildChildrenEntries(Object element, IWeightedTreeProvider<N, E, T> wtProvider, IWeightedTreeSet<N, Object, WeightedTree<N>> callGraph, List<FlameChartEntryModel.Builder> builder, FlameChartEntryModel.Builder parent) {
        FlameChartEntryModel.Builder entry = new FlameChartEntryModel.Builder(ENTRY_ID.getAndIncrement(), parent.getId(), element instanceof ITree ? String.valueOf(((ITree)element).getName()) : String.valueOf(element), 0L, FlameChartEntryModel.EntryType.LEVEL, -1);
        builder.add(entry);
        if (element instanceof ITree) {
            for (ITree child : ((ITree)element).getChildren()) {
                this.buildChildrenEntries(child, wtProvider, callGraph, builder, entry);
            }
        }
        long endTime = entry.getEndTime();
        for (FlameChartEntryModel.Builder childEntry : builder) {
            if (childEntry.getParentId() != entry.getId()) continue;
            endTime = Math.max(childEntry.getEndTime(), endTime);
        }
        entry.setEndTime(endTime);
        ArrayList rootTrees = new ArrayList(callGraph.getTreesFor(element));
        if (rootTrees.isEmpty()) {
            return;
        }
        ArrayDeque<Long> timestampStack = new ArrayDeque<Long>();
        timestampStack.push(0L);
        ITmfStateSystem ss = this.elementToStateSystem(wtProvider, callGraph, element);
        entry.setEndTime(ss.getCurrentEndTime());
        int quark = ss.optQuarkAbsolute(new String[]{FUNCTION_LEVEL});
        if (quark == -2) {
            return;
        }
        int i = 0;
        for (Integer subQuark : ss.getSubAttributes(quark, false)) {
            FlameChartEntryModel.Builder child = new FlameChartEntryModel.Builder(ENTRY_ID.getAndIncrement(), entry.getId(), String.valueOf(i), 0L, FlameChartEntryModel.EntryType.FUNCTION, i);
            child.setEndTime(ss.getCurrentEndTime());
            builder.add(child);
            ++i;
            this.fCgEntries.put(child.getId(), new WeightedTreeEntry(ss, subQuark));
        }
        List extraDataSets = wtProvider.getExtraDataSets();
        int set = 0;
        while (set < extraDataSets.size()) {
            String dataSetName = (String)extraDataSets.get(set);
            quark = ss.optQuarkAbsolute(new String[]{dataSetName});
            if (quark != -2) {
                FlameChartEntryModel.Builder child = new FlameChartEntryModel.Builder(ENTRY_ID.getAndIncrement(), entry.getId(), dataSetName, 0L, FlameChartEntryModel.EntryType.KERNEL, -1);
                child.setEndTime(ss.getCurrentEndTime());
                builder.add(child);
                this.fCgEntries.put(child.getId(), new WeightedTreeEntry(ss, quark));
            }
            ++set;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull TmfModelResponse<@NonNull TimeGraphModel> fetchRowModel(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        SubMonitor subMonitor = Objects.requireNonNull(SubMonitor.convert((IProgressMonitor)monitor, (String)"FlameGraphDataProvider#fetchRowModel", (int)2));
        List times = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
        if (times == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        ArrayList<ITimeGraphRowModel> rowModels = new ArrayList<ITimeGraphRowModel>();
        Collection<Object> selected = DataProviderParameterUtils.extractSelectedItems(fetchParameters);
        if (selected == null) {
            selected = this.fEntries.keySet();
        }
        ArrayList<WeightedTreeEntry> selectedEntries = new ArrayList<WeightedTreeEntry>();
        HashMultimap requested = HashMultimap.create();
        for (Long l : selected) {
            WeightedTreeEntry entry = this.fCgEntries.get(l);
            if (entry == null) continue;
            selectedEntries.add(entry);
            requested.put((Object)entry, (Object)new Pair((Object)entry.fQuark, (Object)l));
        }
        HashMap<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> hashMap = new HashMap<Integer, Predicate<Multimap<String, Object>>>();
        @NonNull @NonNull Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(fetchParameters);
        if (regexesMap != null) {
            hashMap.putAll(this.computeRegexPredicate(regexesMap));
        }
        if (subMonitor.isCanceled()) {
            return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
        }
        try {
            for (WeightedTreeEntry element : requested.keySet()) {
                if (subMonitor.isCanceled()) {
                    return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                }
                Collection depths = Objects.requireNonNull(requested.get((Object)element));
                rowModels.addAll(this.getStatesForElement(times, hashMap, (IProgressMonitor)subMonitor, element.fSs, depths));
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return new TmfModelResponse((Object)new TimeGraphModel(rowModels), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private List<ITimeGraphRowModel> getStatesForElement(List<Long> times, Map<Integer, Predicate<Multimap<String, Object>>> predicates, IProgressMonitor monitor, ITmfStateSystem ss, Collection<Pair<Integer, Long>> depths) throws StateSystemDisposedException {
        ArrayList<Integer> quarks = new ArrayList<Integer>();
        for (Pair<Integer, Long> pair : depths) {
            quarks.add((Integer)pair.getFirst());
        }
        TreeMultimap intervals = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        long ssEndTime = ss.getCurrentEndTime();
        for (ITmfStateInterval interval : ss.query2D(quarks, times)) {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            if (interval.getStartTime() == ssEndTime && interval.getStartTime() == interval.getEndTime() && interval.getValue() == null) continue;
            intervals.put((Object)interval.getAttribute(), (Object)interval);
        }
        ArrayList<ITimeGraphRowModel> rows = new ArrayList<ITimeGraphRowModel>();
        for (Pair<Integer, Long> pair : depths) {
            int quark = (Integer)pair.getFirst();
            NavigableSet states = intervals.get((Object)quark);
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            ArrayList eventList = new ArrayList();
            Long key = Objects.requireNonNull((Long)pair.getSecond());
            states.forEach(i -> {
                ITimeGraphState timegraphState = this.createTimeGraphState((ITmfStateInterval)i, ssEndTime);
                this.applyFilterAndAddState(eventList, timegraphState, key, predicates, monitor);
            });
            rows.add((ITimeGraphRowModel)new TimeGraphRowModel(key.longValue(), eventList));
        }
        return rows;
    }

    private ITimeGraphState createTimeGraphState(ITmfStateInterval interval, long ssEndTime) {
        IWeightedTreeProvider<N, E, T> wtProvider = this.fWtProvider;
        long startTime = interval.getStartTime();
        long duration = interval.getEndTime() - startTime + (long)(ssEndTime == interval.getEndTime() ? 0 : 1);
        Object valueObject = interval.getValue();
        if (valueObject instanceof CalleeCustomValue) {
            WeightedTree callsite = ((CalleeCustomValue)((Object)valueObject)).fCallSite;
            String displayString = wtProvider.toDisplayString(callsite);
            return new TimeGraphState(startTime, duration, displayString, this.fWtProvider.getPalette().getStyleFor(callsite));
        }
        return new TimeGraphState(startTime, duration, Integer.MIN_VALUE);
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(Collections.emptyList(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        List times = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
        if (times == null || times.size() != 1) {
            return new TmfModelResponse(Collections.emptyMap(), ITmfResponse.Status.FAILED, "Invalid time requested for tooltip");
        }
        List items = DataProviderParameterUtils.extractSelectedItems(fetchParameters);
        if (items == null || items.size() != 1) {
            return new TmfModelResponse(Collections.emptyMap(), ITmfResponse.Status.FAILED, "Invalid selection requested for tooltip");
        }
        Long time = (Long)times.get(0);
        Long item = (Long)items.get(0);
        WeightedTreeEntry callGraphEntry = this.fCgEntries.get(item);
        if (callGraphEntry == null) {
            return new TmfModelResponse(Collections.emptyMap(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        WeightedTree<@NonNull N> callSite = this.findCallSite(callGraphEntry, time);
        if (callSite != null) {
            Object actions = fetchParameters.get(TOOLTIP_ACTION_KEY);
            if (actions == null) {
                return new TmfModelResponse(this.getTooltip(callSite), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
            }
            return new TmfModelResponse(this.getTooltipActions(callSite), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        return new TmfModelResponse(Collections.emptyMap(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private Map<String, String> getTooltipActions(WeightedTree<@NonNull N> callSite) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        IStatistics statistics = this.fWtProvider.getStatistics(callSite, -1);
        if (statistics != null) {
            Object maxObject;
            Object minObject = statistics.getMinObject();
            if (minObject instanceof ISegment) {
                ISegment minimum = (ISegment)minObject;
                builder.put((Object)("#" + Messages.FlameGraph_GoToMin), (Object)DataProviderUtils.createGoToTimeAction(minimum.getStart(), minimum.getEnd()));
            }
            if ((maxObject = statistics.getMaxObject()) instanceof ISegment) {
                ISegment maximum = (ISegment)maxObject;
                builder.put((Object)("#" + Messages.FlameGraph_GoToMax), (Object)DataProviderUtils.createGoToTimeAction(maximum.getStart(), maximum.getEnd()));
            }
        }
        return builder.build();
    }

    private Map<String, String> getTooltip(WeightedTree<@NonNull N> callSite) {
        IWeightedTreeProvider.MetricType otherMetric;
        String displayString;
        String string;
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)Objects.requireNonNull(Messages.FlameGraph_Object), (string = callSite.getObject().toString()).equals(displayString = this.fWtProvider.toDisplayString(callSite)) ? displayString : displayString + " (" + string + ")");
        List additionalMetrics = this.fWtProvider.getAdditionalMetrics();
        IWeightedTreeProvider.MetricType metric = this.fWtProvider.getWeightType();
        if (!metric.hasStatistics()) {
            builder.put((Object)metric.getTitle(), (Object)metric.format((Object)callSite.getWeight()));
        }
        int i = 0;
        while (i < additionalMetrics.size()) {
            otherMetric = (IWeightedTreeProvider.MetricType)additionalMetrics.get(i);
            if (!otherMetric.hasStatistics()) {
                builder.put((Object)otherMetric.getTitle(), (Object)otherMetric.format(this.fWtProvider.getAdditionalMetric(callSite, i)));
            }
            ++i;
        }
        if (metric.hasStatistics()) {
            builder.putAll(this.getMetricWithStatTooltip(metric, callSite, -1));
        }
        i = 0;
        while (i < additionalMetrics.size()) {
            otherMetric = (IWeightedTreeProvider.MetricType)additionalMetrics.get(i);
            if (otherMetric.hasStatistics()) {
                builder.putAll(this.getMetricWithStatTooltip(otherMetric, callSite, i));
            }
            ++i;
        }
        return builder.build();
    }

    private Map<String, String> getMetricWithStatTooltip(IWeightedTreeProvider.MetricType metric, WeightedTree<@NonNull N> callSite, int metricIndex) {
        Long metricValue = metricIndex < 0 ? Long.valueOf(callSite.getWeight()) : this.fWtProvider.getAdditionalMetric(callSite, metricIndex);
        IStatistics statistics = this.fWtProvider.getStatistics(callSite, metricIndex);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (statistics == null || statistics.getMax() == -1L) {
            map.put(metric.getTitle(), metric.format((Object)metricValue));
        } else {
            map.put(metric.getTitle(), "");
            String lowerTitle = metric.getTitle().toLowerCase();
            map.put("\t" + Messages.FlameGraph_Total + " " + lowerTitle, metric.format((Object)statistics.getTotal()));
            map.put("\t" + Messages.FlameGraph_Average + " " + lowerTitle, metric.format((Object)statistics.getMean()));
            map.put("\t" + Messages.FlameGraph_Max + " " + lowerTitle, metric.format((Object)statistics.getMax()));
            map.put("\t" + Messages.FlameGraph_Min + " " + lowerTitle, metric.format((Object)statistics.getMin()));
            map.put("\t" + Messages.FlameGraph_Deviation + " " + lowerTitle, metric.format((Object)statistics.getStdDev()));
        }
        return map;
    }

    private @Nullable WeightedTree<@NonNull N> findCallSite(WeightedTreeEntry cgEntry, Long time) {
        try {
            ITmfStateInterval interval = cgEntry.fSs.querySingleState(time.longValue(), cgEntry.fQuark.intValue());
            Object valueObject = interval.getValue();
            if (valueObject instanceof CalleeCustomValue) {
                return ((CalleeCustomValue)((Object)valueObject)).fCallSite;
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return null;
    }

    public TmfModelResponse<OutputStyleModel> fetchStyle(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        IDataPalette palette = this.fWtProvider.getPalette();
        return new TmfModelResponse((Object)new OutputStyleModel(palette.getStyles()), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private /* synthetic */ void lambda$2(FlameChartEntryModel entry) {
        this.fEntries.put(entry.getId(), entry);
        this.fEndTimes.put(entry.getId(), entry.getEndTime());
    }

    private class CacheKey {
        private final Map<String, Object> fParameters;
        private final IWeightedTreeSet<N, Object, WeightedTree<N>> fTreeSet;

        public CacheKey(Map<String, Object> parameters, IWeightedTreeSet<N, Object, WeightedTree<N>> treeset) {
            this.fParameters = parameters;
            this.fTreeSet = treeset;
        }

        public int hashCode() {
            return Objects.hash(this.fParameters, this.fTreeSet);
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            return Objects.equals(this.fParameters, ((CacheKey)obj).fParameters) && Objects.equals(this.fTreeSet, ((CacheKey)obj).fTreeSet);
        }
    }

    private static class CalleeCustomValue<@NonNull N>
    extends CustomStateValue {
        private WeightedTree<N> fCallSite;

        public CalleeCustomValue(WeightedTree<N> rootFunction) {
            this.fCallSite = rootFunction;
        }

        public int compareTo(ITmfStateValue o) {
            if (!(o instanceof CalleeCustomValue)) {
                return -1;
            }
            return this.fCallSite.compareTo(((CalleeCustomValue)o).fCallSite);
        }

        protected Byte getCustomTypeId() {
            return (byte)103;
        }

        protected void serializeValue(ISafeByteBufferWriter buffer) {
            throw new UnsupportedOperationException("This state value is not meant to be written to disk");
        }

        protected int getSerializedValueSize() {
            throw new UnsupportedOperationException("This state value is not meant to be written to disk");
        }
    }

    private class WeightedTreeEntry {
        private ITmfStateSystem fSs;
        private Integer fQuark;

        public WeightedTreeEntry(ITmfStateSystem ss, Integer quark) {
            this.fSs = ss;
            this.fQuark = quark;
        }
    }
}

