/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.core.criticalpath;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.AbstractCriticalPathModule;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IDataPalette;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeSet;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.WeightedTree;
import org.eclipse.tracecompass.incubator.internal.kernel.core.criticalpath.CriticalPathAggregatedPalette;
import org.eclipse.tracecompass.incubator.internal.kernel.core.criticalpath.CriticalPathWeighted;
import org.eclipse.tracecompass.tmf.core.TmfStrings;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartAnalysisSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class CriticalPathAggregatedModule
extends TmfAbstractAnalysisModule
implements IWeightedTreeProvider<Object, String, WeightedTree<Object>> {
    private static final IWeightedTreeProvider.MetricType DURATION_METRIC = new IWeightedTreeProvider.MetricType(Objects.requireNonNull(TmfStrings.duration()), IWeightedTreeProvider.DataType.NANOSECONDS, null);
    private @Nullable AbstractCriticalPathModule fModule = null;
    private @Nullable CriticalPathWeighted fCritPathCg = null;

    protected boolean executeAnalysis(IProgressMonitor monitor) throws TmfAnalysisException {
        AbstractCriticalPathModule module = this.fModule;
        if (module == null) {
            return false;
        }
        if (!module.waitForCompletion(Objects.requireNonNull(monitor))) {
            return false;
        }
        this.fCritPathCg = CriticalPathWeighted.create(module.getCriticalPathGraph());
        return true;
    }

    @TmfSignalHandler
    public void analysisStarted(TmfStartAnalysisSignal signal) {
        IAnalysisModule analysis = signal.getAnalysisModule();
        if (analysis instanceof AbstractCriticalPathModule) {
            AbstractCriticalPathModule criticalPath = (AbstractCriticalPathModule)analysis;
            Collection traces = TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)this.getTrace());
            if (traces.contains(criticalPath.getTrace())) {
                this.cancel();
                this.fModule = criticalPath;
                this.fCritPathCg = null;
                this.resetAnalysis();
                this.schedule();
            }
        }
    }

    protected void canceling() {
    }

    public IWeightedTreeProvider.MetricType getWeightType() {
        return DURATION_METRIC;
    }

    public String getTitle() {
        return "What the process is waiting for";
    }

    public IWeightedTreeSet<Object, String, WeightedTree<Object>> getTreeSet() {
        CriticalPathWeighted critPathCg = this.fCritPathCg;
        if (critPathCg != null) {
            return critPathCg;
        }
        AbstractCriticalPathModule module = this.fModule;
        if (module == null) {
            return CriticalPathWeighted.create(null);
        }
        return CriticalPathWeighted.create(module.getCriticalPathGraph());
    }

    public IDataPalette getPalette() {
        return CriticalPathAggregatedPalette.getInstance();
    }
}

