/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.timegraph;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.widgets.ViewFilterDialog;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.widgets.timegraph.BaseDataProviderTimeGraphPresentationProvider;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.views.timegraph.Messages;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.tmf.core.TmfStrings;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.event.lookup.TmfCallsite;
import org.eclipse.tracecompass.tmf.core.model.IOutputElement;
import org.eclipse.tracecompass.tmf.core.model.ITimeElement;
import org.eclipse.tracecompass.tmf.core.model.annotations.Annotation;
import org.eclipse.tracecompass.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.tmf.core.model.annotations.IAnnotation;
import org.eclipse.tracecompass.tmf.core.model.annotations.IOutputAnnotationProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.actions.OpenSourceCodeAction;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NamedTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeLinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;

public class BaseDataProviderTimeGraphView
extends AbstractTimeGraphView {
    protected static final long BUILD_UPDATE_TIMEOUT = 500L;
    private static final Pattern SOURCE_REGEX = Pattern.compile("(.*):(\\d+)");
    protected final Table<ITimeGraphDataProvider<? extends @NonNull TimeGraphEntryModel>, Long, @NonNull TimeGraphEntry> fEntries = HashBasedTable.create();
    protected final Table<@NonNull TimeGraphEntry, ITimeGraphDataProvider<? extends @NonNull TimeGraphEntryModel>, Long> fEntryIds = HashBasedTable.create();
    protected final Table<Object, Long, @NonNull TimeGraphEntry> fScopedEntries = HashBasedTable.create();
    private final Multimap<ITmfTrace, ITimeGraphDataProvider<? extends @NonNull TimeGraphEntryModel>> fProviders = HashMultimap.create();
    private final Multimap<ITmfTrace, Object> fScopes = HashMultimap.create();
    private final Map<ITimeGraphDataProvider<? extends @NonNull TimeGraphEntryModel>, List<String>> fMarkerCategories = new HashMap<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, List<String>>();
    private final String fProviderId;

    public BaseDataProviderTimeGraphView(String id, TimeGraphPresentationProvider pres, String providerId) {
        super(id, pres);
        this.fProviderId = providerId;
    }

    protected String getProviderId() {
        return this.fProviderId;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.createTimeEventContextMenu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void buildEntryList(@NonNull ITmfTrace trace, @NonNull ITmfTrace parentTrace, @NonNull IProgressMonitor monitor) {
        @NonNull ITimeGraphDataProvider dataProvider = (ITimeGraphDataProvider)DataProviderManager.getInstance().getOrCreateDataProvider(trace, this.getProviderId(), ITimeGraphDataProvider.class);
        if (dataProvider == null) {
            return;
        }
        ITimeGraphPresentationProvider presentationProvider = this.getPresentationProvider();
        if (presentationProvider instanceof BaseDataProviderTimeGraphPresentationProvider) {
            ((BaseDataProviderTimeGraphPresentationProvider)presentationProvider).addProvider(dataProvider, this.getTooltipResolver((ITimeGraphDataProvider<? extends TimeGraphEntryModel>)dataProvider));
        }
        double factor = 1.0;
        boolean complete = false;
        while (!complete && !monitor.isCanceled()) {
            Map<@NonNull String, @NonNull Object> parameters = this.getFetchTreeParameters();
            @NonNull TmfModelResponse response = dataProvider.fetchTree(parameters, monitor);
            if (response.getStatus() == ITmfResponse.Status.FAILED) {
                Activator.getDefault().logError(String.valueOf(this.getClass().getSimpleName()) + " Data Provider failed: " + response.getStatusMessage());
                return;
            }
            if (response.getStatus() == ITmfResponse.Status.CANCELLED) {
                return;
            }
            complete = response.getStatus() == ITmfResponse.Status.COMPLETED;
            @NonNull TmfTreeModel model = (TmfTreeModel)response.getModel();
            if (model != null) {
                ImmutableList entries;
                Table<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Long, TimeGraphEntry> table = this.fEntries;
                synchronized (table) {
                    Object scope = model.getScope() == null ? dataProvider : model.getScope();
                    this.fProviders.put((Object)parentTrace, (Object)dataProvider);
                    this.fScopes.put((Object)parentTrace, scope);
                    ArrayList<TimeGraphEntry> orphaned = new ArrayList<TimeGraphEntry>();
                    HashMap<Long, AtomicInteger> indexMap = new HashMap<Long, AtomicInteger>();
                    HashSet<Long> entries2 = new HashSet<Long>();
                    for (TimeGraphEntryModel entry : model.getEntries()) {
                        TimeGraphEntry uiEntry = (TimeGraphEntry)this.fScopedEntries.get(scope, (Object)entry.getId());
                        if (entry.getParentId() != -1L) {
                            if (uiEntry == null) {
                                uiEntry = new TimeGraphEntry(entry);
                                TimeGraphEntry parent = (TimeGraphEntry)this.fScopedEntries.get(scope, (Object)entry.getParentId());
                                if (parent != null) {
                                    int index = indexMap.computeIfAbsent(entry.getParentId(), l -> new AtomicInteger()).getAndIncrement();
                                    parent.addChild(index, uiEntry);
                                } else {
                                    orphaned.add(uiEntry);
                                }
                                this.fScopedEntries.put(scope, (Object)entry.getId(), (Object)uiEntry);
                            } else {
                                if (!entries2.contains(entry.getId())) {
                                    indexMap.computeIfAbsent(entry.getParentId(), l -> new AtomicInteger()).getAndIncrement();
                                }
                                uiEntry.updateModel(entry);
                            }
                        } else {
                            if (entry.getStartTime() != Long.MIN_VALUE) {
                                this.setStartTime(Long.min(this.getStartTime(), entry.getStartTime()));
                            }
                            this.setEndTime(Long.max(this.getEndTime(), entry.getEndTime() + 1L));
                            if (uiEntry != null) {
                                uiEntry.updateModel(entry);
                            } else {
                                uiEntry = new TraceEntry(entry, trace, (ITimeGraphDataProvider<? extends TimeGraphEntryModel>)dataProvider);
                                this.fScopedEntries.put(scope, (Object)entry.getId(), (Object)uiEntry);
                                this.addToEntryList(parentTrace, Collections.singletonList(uiEntry));
                            }
                        }
                        this.fEntries.put((Object)dataProvider, (Object)entry.getId(), (Object)uiEntry);
                        this.fEntryIds.put((Object)uiEntry, (Object)dataProvider, (Object)entry.getId());
                        entries2.add(entry.getId());
                    }
                    indexMap.clear();
                    for (TimeGraphEntry orphanedEntry : orphaned) {
                        TimeGraphEntry parent = (TimeGraphEntry)this.fScopedEntries.get(scope, (Object)orphanedEntry.getEntryModel().getParentId());
                        if (parent == null) continue;
                        int index = indexMap.computeIfAbsent(parent.getEntryModel().getId(), l -> new AtomicInteger()).getAndIncrement();
                        parent.addChild(index, orphanedEntry);
                    }
                }
                long start = this.getStartTime();
                long end = this.getEndTime();
                long resolution = Long.max(1L, (end - start) / (long)this.getDisplayWidth());
                Table<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Long, TimeGraphEntry> table2 = this.fEntries;
                synchronized (table2) {
                    entries = ImmutableList.copyOf((Collection)this.fEntries.values());
                }
                this.zoomEntries((Iterable<TimeGraphEntry>)entries, start, end, resolution, monitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (parentTrace.equals(this.getTrace())) {
                this.synchingToTime(this.getTimeGraphViewer().getSelectionBegin());
                this.refresh();
            }
            monitor.worked(1);
            if (complete || monitor.isCanceled()) continue;
            try {
                Thread.sleep((long)(500.0 * factor));
                factor = Math.min(20.0, factor + 1.0);
            }
            catch (InterruptedException e) {
                Activator.getDefault().logError("Failed to wait for data provider", e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public static @NonNull ITmfTrace getTrace(TimeGraphEntry entry) {
        return BaseDataProviderTimeGraphView.getTraceEntry(entry).getTrace();
    }

    public static ITimeGraphDataProvider<? extends TimeGraphEntryModel> getProvider(TimeGraphEntry entry) {
        TraceEntry traceEntry = BaseDataProviderTimeGraphView.getTraceEntry(entry);
        return traceEntry.getProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ITimeGraphDataProvider<? extends @NonNull TimeGraphEntryModel>> getProviders(ITmfTrace viewTrace) {
        ArrayList<ITimeGraphDataProvider<? extends TimeGraphEntryModel>> providers;
        Table<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Long, TimeGraphEntry> table = this.fEntries;
        synchronized (table) {
            providers = this.fProviders.get((Object)viewTrace);
        }
        if (!providers.isEmpty()) {
            return providers;
        }
        List<@NonNull TimeGraphEntry> traceEntries = this.getEntryList(viewTrace);
        if (traceEntries == null) {
            return Collections.emptyList();
        }
        providers = new ArrayList<ITimeGraphDataProvider<? extends TimeGraphEntryModel>>();
        for (TraceEntry traceEntry : Iterables.filter(traceEntries, TraceEntry.class)) {
            providers.add(traceEntry.getProvider());
        }
        return providers;
    }

    private static TraceEntry getTraceEntry(TimeGraphEntry entry) {
        ITimeGraphEntry parent = entry;
        while (parent != null) {
            if (parent instanceof TraceEntry) {
                return (TraceEntry)parent;
            }
            parent = parent.getParent();
        }
        throw new IllegalStateException(entry + " should have a TraceEntry parent");
    }

    @Override
    protected void zoomEntries(@NonNull Iterable<@NonNull TimeGraphEntry> entries, long zoomStartTime, long zoomEndTime, long resolution, boolean fullSearch, @NonNull IProgressMonitor monitor) {
        if (resolution < 0L) {
            return;
        }
        long start = Long.min(zoomStartTime, zoomEndTime);
        long end = Long.max(zoomStartTime, zoomEndTime);
        TimeGraphEntry.Sampling sampling = new TimeGraphEntry.Sampling(start, end, resolution);
        Multimap<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Long> providersToModelIds = this.filterGroupEntries(entries, zoomStartTime, zoomEndTime);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)(String.valueOf(this.getClass().getSimpleName()) + "#zoomEntries"), (int)providersToModelIds.size());
        for (Map.Entry entry : providersToModelIds.asMap().entrySet()) {
            Map<String, Object> parameters;
            ITimeGraphDataProvider dataProvider = (ITimeGraphDataProvider)entry.getKey();
            TmfModelResponse response = dataProvider.fetchRowModel(parameters = this.getFetchRowModelParameters(start, end, resolution, fullSearch, (Collection)entry.getValue()), monitor);
            TimeGraphModel model = (TimeGraphModel)response.getModel();
            if (model != null) {
                this.zoomEntries(this.fEntries.row((Object)dataProvider), model.getRows(), response.getStatus() == ITmfResponse.Status.COMPLETED, sampling);
            }
            subMonitor.worked(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Multimap<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Long> filterGroupEntries(Iterable<TimeGraphEntry> visible, long zoomStartTime, long zoomEndTime) {
        HashMultimap providersToModelIds = HashMultimap.create();
        for (TimeGraphEntry entry : visible) {
            if (zoomStartTime <= entry.getEndTime() && zoomEndTime >= entry.getStartTime() && entry.hasTimeEvents()) {
                Table<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Long, TimeGraphEntry> table = this.fEntries;
                synchronized (table) {
                    if (!this.fEntryIds.isEmpty()) {
                        this.fEntryIds.row((Object)entry).forEach((arg_0, arg_1) -> ((Multimap)providersToModelIds).put(arg_0, arg_1));
                    } else {
                        ITimeGraphDataProvider<? extends TimeGraphEntryModel> provider = BaseDataProviderTimeGraphView.getProvider(entry);
                        if (provider != null) {
                            providersToModelIds.put(provider, (Object)entry.getEntryModel().getId());
                        }
                    }
                    continue;
                }
            }
            entry.setZoomedEventList(null);
        }
        return providersToModelIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zoomEntries(Map<Long, TimeGraphEntry> map, List<ITimeGraphRowModel> model, boolean completed, TimeGraphEntry.Sampling sampling) {
        boolean isZoomThread = Thread.currentThread() instanceof AbstractTimeGraphView.ZoomThread;
        for (ITimeGraphRowModel rowModel : model) {
            TimeGraphEntry entry;
            Table<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Long, TimeGraphEntry> table = this.fEntries;
            synchronized (table) {
                entry = map.get(rowModel.getEntryID());
            }
            if (entry == null) continue;
            List<ITimeEvent> events = this.createTimeEvents(entry, rowModel.getStates());
            if (isZoomThread) {
                this.applyResults(() -> {
                    entry.setZoomedEventList(events);
                    if (completed) {
                        entry.setSampling(sampling);
                    }
                });
                continue;
            }
            entry.setEventList(events);
        }
    }

    protected List<ITimeEvent> createTimeEvents(TimeGraphEntry entry, List<ITimeGraphState> values) {
        ArrayList<ITimeEvent> events = new ArrayList<ITimeEvent>(values.size());
        ITimeEvent prev = null;
        for (ITimeGraphState state : values) {
            TimeEvent event = this.createTimeEvent(entry, state);
            if (prev != null) {
                long prevEnd = prev.getTime() + prev.getDuration();
                ViewFilterDialog viewFilterDialog = this.getViewFilterDialog();
                long duration = event.getTime() - prevEnd;
                if (!(duration <= 0L || viewFilterDialog != null && viewFilterDialog.hasActiveSavedFilters())) {
                    TimeEvent timeEvent = new TimeEvent(entry, prevEnd, duration);
                    if (viewFilterDialog != null && viewFilterDialog.isFilterActive()) {
                        timeEvent.setProperty(1, true);
                    }
                    events.add(timeEvent);
                }
            }
            prev = event;
            events.add(event);
        }
        return events;
    }

    protected TimeEvent createTimeEvent(TimeGraphEntry entry, ITimeGraphState state) {
        String label = state.getLabel();
        if (state.getValue() == Integer.MIN_VALUE && label == null && state.getStyle() == null) {
            return new NullTimeEvent(entry, state.getStartTime(), state.getDuration());
        }
        if (label != null) {
            return new NamedTimeEvent((ITimeGraphEntry)entry, label, state);
        }
        return new TimeEvent(entry, (ITimeElement)state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected List<@NonNull ILinkEvent> getLinkList(long zoomStartTime, long zoomEndTime, long resolution, @NonNull IProgressMonitor monitor) {
        Collection<ITimeGraphDataProvider<? extends @NonNull TimeGraphEntryModel>> providers = this.getProviders(this.getTrace());
        if (providers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<@NonNull ILinkEvent> linkList = new ArrayList<ILinkEvent>();
        @NonNull List times = StateSystemUtils.getTimes((long)zoomStartTime, (long)zoomEndTime, (long)resolution);
        Map<@NonNull String, @NonNull Object> parameters = this.getFetchArrowsParameters(times);
        for (ITimeGraphDataProvider<? extends TimeGraphEntryModel> provider : providers) {
            TmfModelResponse response = provider.fetchArrows(parameters, monitor);
            List model = (List)response.getModel();
            if (model == null) continue;
            for (ITimeGraphArrow arrow : model) {
                ITimeGraphEntry nextEntry;
                ITimeGraphEntry prevEntry;
                Table<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Long, TimeGraphEntry> table = this.fEntries;
                synchronized (table) {
                    prevEntry = (ITimeGraphEntry)this.fEntries.get(provider, (Object)arrow.getSourceId());
                    nextEntry = (ITimeGraphEntry)this.fEntries.get(provider, (Object)arrow.getDestinationId());
                }
                if (prevEntry == null || nextEntry == null) continue;
                linkList.add(new TimeLinkEvent(arrow, prevEntry, nextEntry));
            }
        }
        return linkList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected @NonNull List<String> getViewMarkerCategories() {
        List<String> viewMarkerCategories = super.getViewMarkerCategories();
        Collection<ITimeGraphDataProvider<? extends @NonNull TimeGraphEntryModel>> providers = this.getProviders(this.getTrace());
        if (providers.isEmpty()) {
            return viewMarkerCategories;
        }
        for (ITimeGraphDataProvider<? extends TimeGraphEntryModel> provider : providers) {
            Map<String, Object> parameters;
            TmfModelResponse response;
            AnnotationCategoriesModel model;
            if (!(provider instanceof IOutputAnnotationProvider) || (model = (AnnotationCategoriesModel)(response = ((IOutputAnnotationProvider)provider).fetchAnnotationCategories(parameters = this.getFetchAnnotationCategoriesParameters(), (IProgressMonitor)new NullProgressMonitor())).getModel()) == null) continue;
            @NonNull List categories = model.getAnnotationCategories();
            viewMarkerCategories.addAll(categories);
            this.fMarkerCategories.put(provider, categories);
        }
        return viewMarkerCategories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected @NonNull List<IMarkerEvent> getViewMarkerList(Iterable<@NonNull TimeGraphEntry> entries, long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        ArrayList<IMarkerEvent> viewMarkerList = new ArrayList<IMarkerEvent>();
        List<@NonNull TimeGraphEntry> traceEntries = this.getEntryList(this.getTrace());
        if (traceEntries == null) {
            return viewMarkerList;
        }
        @NonNull List times = StateSystemUtils.getTimes((long)startTime, (long)endTime, (long)resolution);
        Multimap<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Long> providersToModelIds = this.filterGroupEntries(entries, startTime, endTime);
        for (ITimeGraphDataProvider provider : providersToModelIds.keySet()) {
            if (!(provider instanceof IOutputAnnotationProvider)) continue;
            List<String> providerCategories = this.fMarkerCategories.get(provider);
            ArrayList<String> categories = providerCategories == null ? new ArrayList<String>() : new ArrayList<String>(providerCategories);
            categories.removeIf(category -> !this.getTimeGraphViewer().isMarkerCategoryVisible((String)category));
            if (categories.isEmpty()) continue;
            Map<@NonNull String, @NonNull Object> parameters = this.getFetchAnnotationsParameters(times, providersToModelIds.get((Object)provider));
            parameters.put("requested_marker_categories", categories);
            @NonNull TmfModelResponse response = ((IOutputAnnotationProvider)provider).fetchAnnotations(parameters, (IProgressMonitor)new NullProgressMonitor());
            AnnotationModel model = (AnnotationModel)response.getModel();
            if (model == null) continue;
            for (Map.Entry entry : model.getAnnotations().entrySet()) {
                String category2 = (String)entry.getKey();
                for (Annotation annotation : (Collection)entry.getValue()) {
                    if (annotation.getType() != IAnnotation.AnnotationType.CHART) continue;
                    ITimeGraphEntry markerEntry = null;
                    if (annotation.getEntryId() != -1L) {
                        Table<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Long, TimeGraphEntry> table = this.fEntries;
                        synchronized (table) {
                            markerEntry = (ITimeGraphEntry)this.fEntries.get((Object)provider, (Object)annotation.getEntryId());
                        }
                    }
                    MarkerEvent markerEvent = new MarkerEvent((IAnnotation)annotation, markerEntry, category2, true);
                    viewMarkerList.add(markerEvent);
                }
            }
        }
        return viewMarkerList;
    }

    protected @NonNull Map<@NonNull String, @NonNull Object> getFetchTreeParameters() {
        return new HashMap<String, Object>();
    }

    protected @NonNull Map<@NonNull String, @NonNull Object> getFetchRowModelParameters(long start, long end, long resolution, boolean fullSearch, @NonNull Collection<Long> items) {
        @NonNull HashMap<@NonNull String, @NonNull Object> parameters = new HashMap<String, Object>();
        parameters.put("requested_times", StateSystemUtils.getTimes((long)start, (long)end, (long)resolution));
        parameters.put("requested_items", items);
        Multimap<@NonNull Integer, @NonNull String> regexesMap = this.getRegexes();
        if (!regexesMap.isEmpty()) {
            parameters.put("regex_map_filters", regexesMap.asMap());
        }
        if (fullSearch) {
            parameters.put("full_search", Boolean.TRUE);
        }
        return parameters;
    }

    protected @NonNull Map<@NonNull String, @NonNull Object> getFetchArrowsParameters(@NonNull List<@NonNull Long> times) {
        @NonNull HashMap<@NonNull String, @NonNull Object> parameters = new HashMap<String, Object>();
        parameters.put("requested_times", times);
        return parameters;
    }

    protected @NonNull Map<@NonNull String, @NonNull Object> getFetchTooltipParameters(long time, long item, @Nullable IOutputElement element) {
        @NonNull HashMap<@NonNull String, @NonNull Object> parameters = new HashMap<String, Object>();
        parameters.put("requested_times", Collections.singletonList(time));
        parameters.put("requested_items", Collections.singletonList(item));
        if (element != null) {
            parameters.put("requested_element", element);
        }
        return parameters;
    }

    protected @NonNull Map<@NonNull String, @NonNull Object> getFetchAnnotationCategoriesParameters() {
        return new HashMap<String, Object>();
    }

    protected @NonNull Map<@NonNull String, @NonNull Object> getFetchAnnotationsParameters(@NonNull List<Long> times, @NonNull Collection<Long> items) {
        HashMap<@NonNull String, @NonNull Object> parameters = new HashMap<String, Object>();
        parameters.put("requested_times", times);
        parameters.put("requested_items", items);
        return parameters;
    }

    private BiFunction<ITimeEvent, Long, Map<String, String>> getTooltipResolver(ITimeGraphDataProvider<? extends TimeGraphEntryModel> provider) {
        return (event, time) -> {
            Map<String, Object> parameters;
            TmfModelResponse response;
            Map tooltip;
            Long entryId = null;
            Table<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Long, TimeGraphEntry> table = this.fEntries;
            synchronized (table) {
                entryId = (Long)this.fEntryIds.get((Object)event.getEntry(), (Object)provider);
            }
            if (entryId == null) {
                return Collections.emptyMap();
            }
            ITimeElement element = null;
            if (event instanceof TimeEvent) {
                element = ((TimeEvent)event).getModel();
            }
            return (tooltip = (Map)(response = provider.fetchTooltip(parameters = this.getFetchTooltipParameters((long)time, entryId, (IOutputElement)element), (IProgressMonitor)new NullProgressMonitor())).getModel()) == null ? Collections.emptyMap() : tooltip;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void resetView(ITmfTrace viewTrace) {
        List<@NonNull TimeGraphEntry> entryList = this.getEntryList(viewTrace);
        super.resetView(viewTrace);
        if (entryList != null) {
            Table<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Long, TimeGraphEntry> table = this.fEntries;
            synchronized (table) {
                if (!this.fProviders.isEmpty()) {
                    this.fProviders.removeAll((Object)viewTrace).forEach(provider -> {
                        this.fEntries.row(provider).clear();
                        this.fEntryIds.column(provider).clear();
                        this.fMarkerCategories.remove(provider);
                    });
                } else {
                    for (TimeGraphEntry entry : entryList) {
                        if (!(entry instanceof TraceEntry)) continue;
                        this.fEntries.row(((TraceEntry)entry).getProvider()).clear();
                    }
                }
                this.fScopes.removeAll((Object)viewTrace).forEach(scope -> this.fScopedEntries.row(scope).clear());
            }
        }
    }

    private IContributionItem createOpenSourceCodeAction(Map<String, String> model) {
        if (model != null) {
            String callsite = model.get(TmfStrings.source());
            return OpenSourceCodeAction.create(Messages.BaseDataProviderTimeGraphView_OpenSourceActionName, () -> {
                Matcher matcher;
                if (callsite != null && (matcher = SOURCE_REGEX.matcher(callsite)).matches()) {
                    return new TmfCallsite(Objects.requireNonNull(matcher.group(1)), Long.valueOf(Long.parseLong(matcher.group(2))));
                }
                return null;
            }, this.getTimeGraphViewer().getTimeGraphControl().getShell());
        }
        return null;
    }

    protected void fillTimeEventContextMenu(@NonNull IMenuManager menuManager) {
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSel = (IStructuredSelection)selection;
            Object[] objectArray = sSel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof TimeEvent) {
                    TimeEvent event = (TimeEvent)element;
                    IContributionItem contribItem = this.createOpenSourceCodeAction(this.getPresentationProvider().getEventHoverToolTipInfo(event, this.getTimeGraphViewer().getSelectionBegin()));
                    if (contribItem != null) {
                        menuManager.add(contribItem);
                        break;
                    }
                }
                ++n2;
            }
        }
    }

    private void createTimeEventContextMenu() {
        MenuManager eventMenuManager = new MenuManager();
        eventMenuManager.setRemoveAllWhenShown(true);
        TimeGraphControl timeGraphControl = this.getTimeGraphViewer().getTimeGraphControl();
        Menu timeEventMenu = eventMenuManager.createContextMenu((Control)timeGraphControl);
        timeGraphControl.addTimeEventMenuListener(event -> {
            Menu menu2 = timeEventMenu;
            if (event.data instanceof TimeEvent) {
                timeGraphControl.setMenu(menu2);
                return;
            }
            timeGraphControl.setMenu(null);
            event.doit = false;
        });
        eventMenuManager.addMenuListener(manager -> {
            this.fillTimeEventContextMenu((IMenuManager)eventMenuManager);
            eventMenuManager.add((IContributionItem)new GroupMarker("additions"));
        });
        this.getSite().registerContextMenu(eventMenuManager, this.getTimeGraphViewer().getSelectionProvider());
    }

    protected static class TraceEntry
    extends TimeGraphEntry {
        private final @NonNull ITmfTrace fTrace;
        private final @NonNull ITimeGraphDataProvider<? extends TimeGraphEntryModel> fProvider;

        public TraceEntry(@NonNull TimeGraphEntryModel model, @NonNull ITmfTrace trace, @NonNull ITimeGraphDataProvider<? extends TimeGraphEntryModel> provider) {
            super(model);
            this.fTrace = trace;
            this.fProvider = provider;
        }

        public @NonNull ITmfTrace getTrace() {
            return this.fTrace;
        }

        public @NonNull ITimeGraphDataProvider<? extends TimeGraphEntryModel> getProvider() {
            return this.fProvider;
        }
    }
}

