/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.trace;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.IEventDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StringDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StringDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfTestTraceUtils;
import org.eclipse.tracecompass.ctf.core.trace.CTFResponse;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInput;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInputReader;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.ICTFStream;
import org.eclipse.tracecompass.internal.ctf.core.event.EventDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.EventDefinition;
import org.eclipse.tracecompass.internal.ctf.core.trace.CTFStream;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CTFStreamInputReaderTest {
    private static final CtfTestTrace testTrace = CtfTestTrace.KERNEL;
    private CTFStreamInputReader fixture;

    @Before
    public void setUp() throws CTFException {
        this.fixture = CTFStreamInputReaderTest.getStreamInputReader();
        this.fixture.setName(1);
        this.fixture.setCurrentEvent((IEventDefinition)new EventDefinition((IEventDeclaration)new EventDeclaration(), this.fixture.getCPU(), 0L, null, null, null, (ICompositeDefinition)new StructDefinition(new StructDeclaration(0L), null, "packet", new Definition[]{new StringDefinition(StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8), null, "field", "test")}), null, this.fixture.getCurrentPacketReader().getCurrentPacket()));
    }

    private static CTFStreamInputReader getStreamInputReader() throws CTFException {
        CTFTrace trace = CtfTestTraceUtils.getTrace(testTrace);
        ICTFStream s = trace.getStream(Long.valueOf(0L));
        Set streamInput = s.getStreamInputs();
        CTFStreamInputReader retVal = null;
        for (CTFStreamInput si : streamInput) {
            if (!si.getFilename().endsWith("0_0")) continue;
            retVal = new CTFStreamInputReader(si);
            break;
        }
        return retVal;
    }

    @Test
    public void testStreamInputReader_valid() {
        Assert.assertNotNull((Object)this.fixture);
    }

    @Test(expected=CTFException.class)
    public void testStreamInputReader_invalid() throws CTFException, IOException {
        CTFStreamInput streamInput = new CTFStreamInput((ICTFStream)new CTFStream(new CTFTrace("")), new File(""));
        Throwable throwable = null;
        Object var3_4 = null;
        try (CTFStreamInputReader result = new CTFStreamInputReader(streamInput);){
            Assert.assertNotNull((Object)result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testGetCPU() {
        int result = this.fixture.getCPU();
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    public void testGetCurrentEvent() {
        Assert.assertNotNull((Object)this.fixture.getCurrentEvent());
    }

    @Test
    public void testGetCurrentPacketContext() {
        IEventDefinition currentEvent = this.fixture.getCurrentEvent();
        Assert.assertNotNull((Object)currentEvent);
        ICompositeDefinition result = currentEvent.getPacketContext();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetName() {
        int result = this.fixture.getName();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testGoToLastEvent1() throws CTFException {
        long endTimestamp = this.goToEnd();
        Assert.assertEquals((long)4287422460315L, (long)endTimestamp);
    }

    @Test
    public void testGoToLastEvent2() throws CTFException {
        long timestamp = -1L;
        while (this.fixture.readNextEvent().equals((Object)CTFResponse.OK)) {
            IEventDefinition currentEvent = this.fixture.getCurrentEvent();
            Assert.assertNotNull((Object)currentEvent);
            timestamp = currentEvent.getTimestamp();
        }
        long endTimestamp = this.goToEnd();
        Assert.assertEquals((long)0L, (long)(timestamp - endTimestamp));
    }

    private long goToEnd() throws CTFException {
        this.fixture.goToLastEvent();
        IEventDefinition currentEvent = this.fixture.getCurrentEvent();
        Assert.assertNotNull((Object)currentEvent);
        return currentEvent.getTimestamp();
    }

    @Test
    public void testReadNextEvent() throws CTFException {
        Assert.assertEquals((Object)CTFResponse.OK, (Object)this.fixture.readNextEvent());
    }

    @Test
    public void testSeek_timestamp() throws CTFException {
        long timestamp = 1L;
        this.fixture.seek(timestamp);
    }

    @Test
    public void testSeek_eventDefinition() throws CTFException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CTFStreamInputReader streamInputReader = CTFStreamInputReaderTest.getStreamInputReader();){
            EventDefinition eventDefinition = new EventDefinition((IEventDeclaration)new EventDeclaration(), streamInputReader.getCPU(), 1L, null, null, null, null, null, streamInputReader.getCurrentPacketReader().getCurrentPacket());
            this.fixture.setCurrentEvent((IEventDefinition)eventDefinition);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

