/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.graph;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.building.AbstractTmfGraphBuilderModule;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.OSCriticalPathModule;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdgeContextState;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.graph.TmfGraphFactory;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.GraphOps;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsWorker;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.OSEdgeContextState;
import org.eclipse.tracecompass.lttng2.kernel.core.tests.Activator;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.junit.Assert;
import org.junit.Test;

public class DistributedCriticalPathTest {
    private static final String EXPERIMENT = "CritPathExperiment";
    private static int BLOCK_SIZE = 1000;
    private static final @NonNull String TEST_ANALYSIS_ID = "org.eclipse.tracecompass.analysis.os.linux.execgraph";

    private static void deleteSupplementaryFiles(@NonNull ITmfTrace trace) {
        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
        File[] fileArray = suppDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    private ITmfTrace setUpExperiment(String ... traceFiles) throws TmfTraceException {
        ITmfTrace[] traces = new ITmfTrace[traceFiles.length];
        int i = 0;
        Object object = traceFiles;
        int n = traceFiles.length;
        int n2 = 0;
        while (n2 < n) {
            TmfXmlKernelTraceStub trace = new TmfXmlKernelTraceStub();
            String traceFile = object[n2];
            IPath filePath = Activator.getAbsoluteFilePath(traceFile);
            IStatus status = trace.validate(null, filePath.toOSString());
            if (!status.isOK()) {
                Assert.fail((String)status.getException().getMessage());
            }
            trace.initTrace(null, filePath.toOSString(), ITmfEvent.class);
            traces[i++] = trace;
            ++n2;
        }
        TmfExperiment experiment = new TmfExperiment(ITmfEvent.class, EXPERIMENT, traces, BLOCK_SIZE, null);
        experiment.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)experiment, null));
        IAnalysisModule module = null;
        object = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)experiment, AbstractTmfGraphBuilderModule.class).iterator();
        while (object.hasNext()) {
            IAnalysisModule mod;
            module = mod = (IAnalysisModule)object.next();
        }
        Assert.assertNotNull(module);
        module.schedule();
        Assert.assertTrue((boolean)module.waitForCompletion());
        return experiment;
    }

    @Test
    public void testNetworkExchangeWithWifi() throws TmfTraceException, TmfAnalysisException {
        ITmfTrace experiment = this.setUpExperiment("testfiles/graph/network_exchange_eth.xml", "testfiles/graph/network_exchange_wifi.xml");
        Assert.assertNotNull((Object)experiment);
        try {
            DistributedCriticalPathTest.internalTestNetworkExchangeWithWifi(experiment);
        }
        finally {
            experiment.dispose();
            DistributedCriticalPathTest.deleteSupplementaryFiles(experiment);
        }
    }

    private static void internalTestNetworkExchangeWithWifi(@NonNull ITmfTrace experiment) throws TmfAnalysisException {
        AbstractTmfGraphBuilderModule module = (AbstractTmfGraphBuilderModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)experiment, AbstractTmfGraphBuilderModule.class, (String)TEST_ANALYSIS_ID);
        Assert.assertNotNull((Object)module);
        ITmfGraph graph = module.getTmfGraph();
        Assert.assertNotNull((Object)graph);
        Collection workers = graph.getWorkers();
        Assert.assertEquals((long)6L, (long)workers.size());
        HashMap<Integer, IGraphWorker> workerMap = new HashMap<Integer, IGraphWorker>();
        for (IGraphWorker worker : workers) {
            workerMap.put(((OsWorker)worker).getHostThread().getTid(), worker);
        }
        ITmfGraph expected = TmfGraphFactory.createSimpleGraph();
        IGraphWorker worker = (IGraphWorker)workerMap.get(201);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 10L));
        expected.append(expected.createVertex(worker, 15L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        expected.append(expected.createVertex(worker, 60L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        worker = (IGraphWorker)workerMap.get(200);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 10L));
        ITmfVertex packet1Sent = expected.createVertex(worker, 13L);
        expected.append(packet1Sent, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.append(expected.createVertex(worker, 15L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        ITmfVertex packet2Received = expected.createVertex(worker, 70L);
        expected.append(packet2Received, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK), "irq/30-handler");
        expected.append(expected.createVertex(worker, 75L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        worker = (IGraphWorker)workerMap.get(50);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 55L));
        expected.append(expected.createVertex(worker, 60L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        expected.append(expected.createVertex(worker, 65L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.append(expected.createVertex(worker, 75L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        worker = (IGraphWorker)workerMap.get(101);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 5L));
        expected.append(expected.createVertex(worker, 40L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.append(expected.createVertex(worker, 55L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        worker = (IGraphWorker)workerMap.get(100);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 5L));
        ITmfVertex packet1Received = expected.createVertex(worker, 35L);
        expected.append(packet1Received, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK));
        expected.append(expected.createVertex(worker, 40L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        ITmfVertex packet2Sent = expected.createVertex(worker, 45L);
        expected.append(packet2Sent, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.append(expected.createVertex(worker, 55L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.edgeVertical(packet1Sent, packet1Received, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK), null);
        expected.edgeVertical(packet2Sent, packet2Received, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK), null);
        worker = (IGraphWorker)workerMap.get(-1);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 30L));
        expected.append(expected.createVertex(worker, 33L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        GraphOps.checkEquality((ITmfGraph)expected, (ITmfGraph)graph);
        expected = TmfGraphFactory.createSimpleGraph();
        worker = (IGraphWorker)workerMap.get(200);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 10L));
        expected.append(expected.createVertex(worker, 13L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        packet1Sent = expected.createVertex(worker, 15L);
        expected.append(packet1Sent, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        packet2Received = expected.createVertex(worker, 70L);
        expected.add(packet2Received);
        expected.append(expected.createVertex(worker, 75L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        worker = (IGraphWorker)workerMap.get(100);
        Assert.assertNotNull((Object)worker);
        packet1Received = expected.createVertex(worker, 35L);
        expected.add(packet1Received);
        expected.append(expected.createVertex(worker, 40L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        packet2Sent = expected.createVertex(worker, 45L);
        expected.append(packet2Sent, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.edgeVertical(packet1Sent, packet1Received, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK), null);
        expected.edgeVertical(packet2Sent, packet2Received, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK), null);
        OSCriticalPathModule critPathModule = new OSCriticalPathModule(module);
        try {
            critPathModule.setTrace(experiment);
            critPathModule.setParameter("workerid", workerMap.get(200));
            critPathModule.schedule();
            Assert.assertTrue((boolean)critPathModule.waitForCompletion());
            ITmfGraph criticalPath = critPathModule.getCriticalPathGraph();
            Assert.assertNotNull((Object)criticalPath);
            GraphOps.checkEquality((ITmfGraph)expected, (ITmfGraph)criticalPath);
        }
        finally {
            critPathModule.dispose();
        }
    }

    @Test
    public void testNetworkExchange() throws TmfTraceException, TmfAnalysisException {
        ITmfTrace experiment = this.setUpExperiment("testfiles/graph/simple_network_server.xml", "testfiles/graph/simple_network_client.xml");
        Assert.assertNotNull((Object)experiment);
        try {
            DistributedCriticalPathTest.internalTestNetworkExchange(experiment);
        }
        finally {
            experiment.dispose();
            DistributedCriticalPathTest.deleteSupplementaryFiles(experiment);
        }
    }

    private static void internalTestNetworkExchange(@NonNull ITmfTrace experiment) throws TmfAnalysisException {
        AbstractTmfGraphBuilderModule module = (AbstractTmfGraphBuilderModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)experiment, AbstractTmfGraphBuilderModule.class, (String)TEST_ANALYSIS_ID);
        Assert.assertNotNull((Object)module);
        ITmfGraph graph = module.getTmfGraph();
        Assert.assertNotNull((Object)graph);
        Collection workers = graph.getWorkers();
        Assert.assertEquals((long)7L, (long)workers.size());
        OsWorker clientWorker = null;
        OsWorker serverWorker = null;
        HashMap<Integer, IGraphWorker> workerMap = new HashMap<Integer, IGraphWorker>();
        for (IGraphWorker worker : workers) {
            OsWorker osWorker = (OsWorker)worker;
            if (osWorker.getHostThread().getTid() < 0) {
                if (osWorker.getHostId().equals("simple_network_server.xml")) {
                    serverWorker = osWorker;
                } else {
                    clientWorker = osWorker;
                }
            }
            workerMap.put(osWorker.getHostThread().getTid(), worker);
        }
        ITmfGraph expected = TmfGraphFactory.createSimpleGraph();
        IGraphWorker worker = (IGraphWorker)workerMap.get(201);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 7L));
        expected.append(expected.createVertex(worker, 10L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.append(expected.createVertex(worker, 15L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        expected.append(expected.createVertex(worker, 75L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        worker = (IGraphWorker)workerMap.get(200);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 10L));
        ITmfVertex packet1Sent = expected.createVertex(worker, 13L);
        expected.append(packet1Sent, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.append(expected.createVertex(worker, 15L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        ITmfVertex packet2Received = expected.createVertex(worker, 70L);
        expected.append(packet2Received, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK));
        expected.append(expected.createVertex(worker, 75L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        ITmfVertex wakeupSource = expected.createVertex(worker, 90L);
        expected.append(wakeupSource, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.append(expected.createVertex(worker, 95L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        worker = clientWorker;
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 60L));
        expected.append(expected.createVertex(worker, 65L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        worker = (IGraphWorker)workerMap.get(202);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 7L));
        ITmfVertex wakeupTarget = expected.createVertex(worker, 90L);
        expected.append(wakeupTarget, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
        expected.append(expected.createVertex(worker, 95L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        expected.edgeVertical(wakeupSource, wakeupTarget, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.DEFAULT), null);
        worker = (IGraphWorker)workerMap.get(101);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 5L));
        expected.append(expected.createVertex(worker, 40L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.append(expected.createVertex(worker, 55L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        worker = (IGraphWorker)workerMap.get(100);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 5L));
        ITmfVertex packet1Received = expected.createVertex(worker, 35L);
        expected.append(packet1Received, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK));
        expected.append(expected.createVertex(worker, 40L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        ITmfVertex packet2Sent = expected.createVertex(worker, 45L);
        expected.append(packet2Sent, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.append(expected.createVertex(worker, 55L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.edgeVertical(packet1Sent, packet1Received, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK), null);
        expected.edgeVertical(packet2Sent, packet2Received, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK), null);
        worker = serverWorker;
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 30L));
        expected.append(expected.createVertex(worker, 33L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        GraphOps.checkEquality((ITmfGraph)expected, (ITmfGraph)graph);
        expected = TmfGraphFactory.createSimpleGraph();
        worker = (IGraphWorker)workerMap.get(200);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 10L));
        expected.append(expected.createVertex(worker, 13L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        packet1Sent = expected.createVertex(worker, 15L);
        expected.append(packet1Sent, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        packet2Received = expected.createVertex(worker, 70L);
        expected.add(packet2Received);
        expected.append(expected.createVertex(worker, 75L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        expected.append(expected.createVertex(worker, 90L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.append(expected.createVertex(worker, 95L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        worker = (IGraphWorker)workerMap.get(100);
        Assert.assertNotNull((Object)worker);
        packet1Received = expected.createVertex(worker, 35L);
        expected.add(packet1Received);
        expected.append(expected.createVertex(worker, 40L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        packet2Sent = expected.createVertex(worker, 45L);
        expected.append(packet2Sent, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.edgeVertical(packet1Sent, packet1Received, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK), null);
        expected.edgeVertical(packet2Sent, packet2Received, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK), null);
        OSCriticalPathModule critPathModule = new OSCriticalPathModule(module);
        try {
            critPathModule.setTrace(experiment);
            critPathModule.setParameter("workerid", workerMap.get(200));
            critPathModule.schedule();
            Assert.assertTrue((boolean)critPathModule.waitForCompletion());
            ITmfGraph criticalPath = critPathModule.getCriticalPathGraph();
            Assert.assertNotNull((Object)criticalPath);
            GraphOps.checkEquality((ITmfGraph)expected, (ITmfGraph)criticalPath);
        }
        finally {
            critPathModule.dispose();
        }
    }

    @Test
    public void testNetworkExchangeOneTrace() throws TmfTraceException, TmfAnalysisException {
        ITmfTrace experiment = this.setUpExperiment("testfiles/graph/network_exchange_wifi.xml");
        Assert.assertNotNull((Object)experiment);
        try {
            DistributedCriticalPathTest.internalTestNetworkExchangeOneTrace(experiment);
        }
        finally {
            experiment.dispose();
            DistributedCriticalPathTest.deleteSupplementaryFiles(experiment);
        }
    }

    private static void internalTestNetworkExchangeOneTrace(@NonNull ITmfTrace experiment) throws TmfAnalysisException {
        AbstractTmfGraphBuilderModule module = (AbstractTmfGraphBuilderModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)experiment, AbstractTmfGraphBuilderModule.class, (String)TEST_ANALYSIS_ID);
        Assert.assertNotNull((Object)module);
        ITmfGraph graph = module.getTmfGraph();
        Assert.assertNotNull((Object)graph);
        Collection workers = graph.getWorkers();
        Assert.assertEquals((long)3L, (long)workers.size());
        HashMap<Integer, IGraphWorker> workerMap = new HashMap<Integer, IGraphWorker>();
        for (IGraphWorker worker : workers) {
            workerMap.put(((OsWorker)worker).getHostThread().getTid(), worker);
        }
        ITmfGraph expected = TmfGraphFactory.createSimpleGraph();
        IGraphWorker worker = (IGraphWorker)workerMap.get(201);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 10L));
        expected.append(expected.createVertex(worker, 15L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        expected.append(expected.createVertex(worker, 60L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        worker = (IGraphWorker)workerMap.get(200);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 10L));
        ITmfVertex packet1Sent = expected.createVertex(worker, 13L);
        expected.append(packet1Sent, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.append(expected.createVertex(worker, 15L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        ITmfVertex packet2Received = expected.createVertex(worker, 70L);
        expected.append(packet2Received, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK), "irq/30-handler");
        expected.append(expected.createVertex(worker, 75L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        worker = (IGraphWorker)workerMap.get(50);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 55L));
        expected.append(expected.createVertex(worker, 60L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        expected.append(expected.createVertex(worker, 65L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.append(expected.createVertex(worker, 75L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        GraphOps.checkEquality((ITmfGraph)expected, (ITmfGraph)graph);
        ITmfGraph expectedCritPath = TmfGraphFactory.createSimpleGraph();
        worker = (IGraphWorker)workerMap.get(200);
        Assert.assertNotNull((Object)worker);
        for (ITmfVertex vertex : ImmutableList.copyOf((Iterator)expected.getNodesOf(worker))) {
            expectedCritPath.add(vertex);
        }
        OSCriticalPathModule critPathModule = new OSCriticalPathModule(module);
        try {
            critPathModule.setTrace(experiment);
            critPathModule.setParameter("workerid", workerMap.get(200));
            critPathModule.schedule();
            Assert.assertTrue((boolean)critPathModule.waitForCompletion());
            ITmfGraph criticalPath = critPathModule.getCriticalPathGraph();
            Assert.assertNotNull((Object)criticalPath);
            GraphOps.checkEquality((ITmfGraph)expectedCritPath, (ITmfGraph)criticalPath);
        }
        finally {
            critPathModule.dispose();
        }
    }

    @Test
    public void testNetworkExchangeOneTraceSoftirq() throws TmfTraceException, TmfAnalysisException {
        ITmfTrace experiment = this.setUpExperiment("testfiles/graph/simple_network_client.xml");
        Assert.assertNotNull((Object)experiment);
        try {
            DistributedCriticalPathTest.internalTestNetworkExchangeOneTraceSoftirq(experiment);
        }
        finally {
            experiment.dispose();
            DistributedCriticalPathTest.deleteSupplementaryFiles(experiment);
        }
    }

    private static void internalTestNetworkExchangeOneTraceSoftirq(@NonNull ITmfTrace experiment) throws TmfAnalysisException {
        AbstractTmfGraphBuilderModule module = (AbstractTmfGraphBuilderModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)experiment, AbstractTmfGraphBuilderModule.class, (String)TEST_ANALYSIS_ID);
        Assert.assertNotNull((Object)module);
        ITmfGraph graph = module.getTmfGraph();
        Assert.assertNotNull((Object)graph);
        Collection workers = graph.getWorkers();
        Assert.assertEquals((long)4L, (long)workers.size());
        OsWorker clientWorker = null;
        HashMap<Integer, IGraphWorker> workerMap = new HashMap<Integer, IGraphWorker>();
        for (IGraphWorker worker : workers) {
            OsWorker osWorker = (OsWorker)worker;
            if (osWorker.getHostThread().getTid() < 0) {
                clientWorker = osWorker;
            }
            workerMap.put(osWorker.getHostThread().getTid(), worker);
        }
        ITmfGraph expected = TmfGraphFactory.createSimpleGraph();
        IGraphWorker worker = (IGraphWorker)workerMap.get(201);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 7L));
        expected.append(expected.createVertex(worker, 10L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.append(expected.createVertex(worker, 15L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        expected.append(expected.createVertex(worker, 75L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        worker = (IGraphWorker)workerMap.get(200);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 10L));
        ITmfVertex packet1Sent = expected.createVertex(worker, 13L);
        expected.append(packet1Sent, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.append(expected.createVertex(worker, 15L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        ITmfVertex packet2Received = expected.createVertex(worker, 70L);
        expected.append(packet2Received, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK));
        expected.append(expected.createVertex(worker, 75L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        ITmfVertex wakeupSource = expected.createVertex(worker, 90L);
        expected.append(wakeupSource, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.append(expected.createVertex(worker, 95L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        worker = clientWorker;
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 60L));
        expected.append(expected.createVertex(worker, 65L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        worker = (IGraphWorker)workerMap.get(202);
        Assert.assertNotNull((Object)worker);
        expected.add(expected.createVertex(worker, 7L));
        ITmfVertex wakeupTarget = expected.createVertex(worker, 90L);
        expected.append(wakeupTarget, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
        expected.append(expected.createVertex(worker, 95L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        expected.edgeVertical(wakeupSource, wakeupTarget, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.DEFAULT), null);
        GraphOps.checkEquality((ITmfGraph)expected, (ITmfGraph)graph);
        expected = TmfGraphFactory.createSimpleGraph();
        IGraphWorker cWorker = (IGraphWorker)workerMap.get(200);
        Assert.assertNotNull((Object)cWorker);
        expected.add(expected.createVertex(cWorker, 10L));
        expected.append(expected.createVertex(cWorker, 13L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        packet1Sent = expected.createVertex(cWorker, 15L);
        expected.append(packet1Sent, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        packet2Received = expected.createVertex(cWorker, 70L);
        expected.append(packet2Received, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK));
        expected.append(expected.createVertex(cWorker, 75L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
        wakeupSource = expected.createVertex(cWorker, 90L);
        expected.append(wakeupSource, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        expected.append(expected.createVertex(cWorker, 95L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
        OSCriticalPathModule critPathModule = new OSCriticalPathModule(module);
        try {
            critPathModule.setTrace(experiment);
            critPathModule.setParameter("workerid", (Object)cWorker);
            critPathModule.schedule();
            Assert.assertTrue((boolean)critPathModule.waitForCompletion());
            ITmfGraph criticalPath = critPathModule.getCriticalPathGraph();
            Assert.assertNotNull((Object)criticalPath);
            GraphOps.checkEquality((ITmfGraph)expected, (ITmfGraph)criticalPath);
            expected = TmfGraphFactory.createSimpleGraph();
            worker = (IGraphWorker)workerMap.get(202);
            Assert.assertNotNull((Object)worker);
            ITmfVertex begin = expected.createVertex(worker, 7L);
            expected.add(begin);
            wakeupTarget = expected.createVertex(worker, 90L);
            expected.add(wakeupTarget);
            expected.append(expected.createVertex(worker, 95L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
            ITmfVertex start = expected.createVertex(cWorker, 7L);
            expected.add(start);
            expected.append(expected.createVertex(cWorker, 10L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.UNKNOWN));
            expected.append(expected.createVertex(cWorker, 13L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            packet1Sent = expected.createVertex(cWorker, 15L);
            expected.append(packet1Sent, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            packet2Received = expected.createVertex(cWorker, 70L);
            expected.append(packet2Received, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK));
            expected.append(expected.createVertex(cWorker, 75L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.PREEMPTED));
            wakeupSource = expected.createVertex(cWorker, 90L);
            expected.append(wakeupSource, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            expected.edgeVertical(begin, start, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.DEFAULT), null);
            expected.edgeVertical(wakeupSource, wakeupTarget, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.DEFAULT), null);
            critPathModule.setParameter("workerid", (Object)worker);
            critPathModule.schedule();
            Assert.assertTrue((boolean)critPathModule.waitForCompletion());
            criticalPath = critPathModule.getCriticalPathGraph();
            Assert.assertNotNull((Object)criticalPath);
            GraphOps.checkEquality((ITmfGraph)expected, (ITmfGraph)criticalPath);
        }
        finally {
            critPathModule.dispose();
        }
    }
}

