/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests.stubs.statevalues;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.datastore.core.serialization.SafeByteBufferFactory;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.CustomStateValue;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;

public class CustomStateValueStub
extends CustomStateValue {
    public static final CustomStateValue.CustomStateValueFactory FACTORY = b -> {
        int val = b.getInt();
        String str = b.getString();
        return new CustomStateValueStub(val, str);
    };
    private static final byte CUSTOM_TYPE_ID = 87;
    private final int fIntField;
    private final String fStringField;

    public CustomStateValueStub(int val, String str) {
        this.fIntField = val;
        this.fStringField = str;
    }

    public static void registerFactory() {
        CustomStateValue.registerCustomFactory((byte)87, (CustomStateValue.CustomStateValueFactory)FACTORY);
    }

    public static void unregisterFactory() {
        CustomStateValue.unregisterCustomFactory((byte)87);
    }

    public int compareTo(@Nullable ITmfStateValue o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        if (!(o instanceof CustomStateValueStub)) {
            throw new StateValueTypeException("Need a TestCustomStateValue object to compare to");
        }
        CustomStateValueStub other = (CustomStateValueStub)o;
        int cmp = Integer.compare(this.fIntField, other.fIntField);
        if (cmp == 0) {
            cmp = this.fStringField.compareTo(other.fStringField);
        }
        return cmp;
    }

    public boolean equals(@Nullable Object arg0) {
        if (!(arg0 instanceof CustomStateValueStub)) {
            return false;
        }
        CustomStateValueStub tcsv = (CustomStateValueStub)((Object)arg0);
        return this.fIntField == tcsv.fIntField && this.fStringField.equals(tcsv.fStringField);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.fIntField;
        result = 31 * result + this.fStringField.hashCode();
        return result;
    }

    protected @NonNull Byte getCustomTypeId() {
        return (byte)87;
    }

    public String toString() {
        return "[" + this.fIntField + "," + this.fStringField + "]";
    }

    protected void serializeValue(@NonNull ISafeByteBufferWriter buffer) {
        buffer.putInt(this.fIntField);
        buffer.putString(this.fStringField);
    }

    protected int getSerializedValueSize() {
        return 4 + SafeByteBufferFactory.getStringSizeInBuffer((String)this.fStringField);
    }
}

