/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event;

import java.util.Map;
import java.util.TimeZone;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimePreferences;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.service.prefs.BackingStoreException;

public class TmfTimePreferencesTest {
    private static final String TIME_PATTERN = "HH:mm:ss.SSS SSS SSS";
    private static final String INTERVAL_PATTERN = "TTT.SSS SSS SSS";

    @Test
    public void testInit() {
        Assert.assertEquals((Object)DefaultScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core").get("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime", null), (Object)"HH:mm:ss");
    }

    @Test
    public void testGetTimePattern() {
        Assert.assertEquals((Object)TIME_PATTERN, (Object)TmfTimePreferences.getTimePattern());
    }

    @Test
    public void testGetIntervalPattern() {
        Assert.assertEquals((Object)INTERVAL_PATTERN, (Object)TmfTimePreferences.getIntervalPattern());
    }

    @Test
    public void testGetTimeZone() {
        Assert.assertEquals((Object)TimeZone.getDefault(), (Object)TmfTimePreferences.getTimeZone());
    }

    @Test
    public void testGetPreferenceMap() {
        Map defaultPreferenceMap = TmfTimePreferences.getDefaultPreferenceMap();
        Assert.assertEquals((Object)"HH:mm:ss", defaultPreferenceMap.get("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime"));
        String testValue = "HH:mm:ssfoo";
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
        node.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime", testValue);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {}
        Map preferenceMap = TmfTimePreferences.getPreferenceMap();
        Assert.assertEquals((Object)testValue, preferenceMap.get("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime"));
        defaultPreferenceMap = TmfTimePreferences.getDefaultPreferenceMap();
        Assert.assertEquals((Object)"HH:mm:ss", defaultPreferenceMap.get("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime"));
        node.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime", "HH:mm:ss");
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    @Test
    public void testComputeTimePattern() {
        Assert.assertEquals((Object)TIME_PATTERN, (Object)TmfTimePreferences.computeTimePattern((Map)TmfTimePreferences.getPreferenceMap()));
    }
}

