/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.uml2sd;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.uml2sd.TmfAsyncSequenceDiagramEvent;
import org.junit.Assert;
import org.junit.Test;

public class TmfAsyncSequenceDiagramEventTest {
    private final @NonNull String fTypeId = "Some type";
    private final String fLabel0 = "label1";
    private final String fLabel1 = "label2";
    private final String[] fLabels = new String[]{"label1", "label2"};
    private final ITmfTimestamp fTimestamp1 = TmfTimestamp.create((long)12345L, (int)2);
    private final ITmfTimestamp fTimestamp2 = TmfTimestamp.create((long)12350L, (int)2);
    private final TmfEventType fType = new TmfEventType("Some type", TmfEventField.makeRoot((String[])this.fLabels));
    private final ITmfEvent fEvent1;
    private final ITmfEvent fEvent2;
    private final TmfEventField fContent1 = new TmfEventField(":root:", (Object)"Some content", null);
    private final TmfEventField fContent2;

    public TmfAsyncSequenceDiagramEventTest() {
        this.fEvent1 = new TmfEvent(null, -1L, this.fTimestamp1, (ITmfEventType)this.fType, (ITmfEventField)this.fContent1);
        this.fContent2 = new TmfEventField(":root:", (Object)"Some other content", null);
        this.fEvent2 = new TmfEvent(null, -1L, this.fTimestamp2, (ITmfEventType)this.fType, (ITmfEventField)this.fContent2);
    }

    @Test
    public void testTmfAsyncSequenceDiagramEvent() {
        TmfAsyncSequenceDiagramEvent event = null;
        try {
            event = new TmfAsyncSequenceDiagramEvent(null, null, null, null, null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"TmfAsyncSequenceDiagramEvent", (boolean)e.getMessage().contains("startEvent=null"));
        }
        try {
            event = new TmfAsyncSequenceDiagramEvent(this.fEvent1, this.fEvent2, null, null, null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"TmfAsyncSequenceDiagramEvent", (boolean)e.getMessage().contains("sender=null"));
        }
        try {
            event = new TmfAsyncSequenceDiagramEvent(this.fEvent1, this.fEvent2, null, null, null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"TmfAsyncSequenceDiagramEvent", (boolean)e.getMessage().contains("receiver=null"));
        }
        try {
            event = new TmfAsyncSequenceDiagramEvent(this.fEvent1, this.fEvent2, "sender", null, null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"TmfAsyncSequenceDiagramEvent", (boolean)e.getMessage().contains("name=null"));
        }
        try {
            event = new TmfAsyncSequenceDiagramEvent(this.fEvent1, null, "sender", "receiver", "signal");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)"TmfAsyncSequenceDiagramEvent", (boolean)e.getMessage().contains("endEvent=null"));
        }
        try {
            event = new TmfAsyncSequenceDiagramEvent(this.fEvent1, this.fEvent2, "sender", "receiver", "signal");
            Assert.assertEquals((String)"testTmfAsyncSequenceDiagramEvent", (long)0L, (long)event.getStartTime().compareTo(this.fTimestamp1));
            Assert.assertEquals((String)"testTmfAsyncSequenceDiagramEvent", (long)0L, (long)event.getEndTime().compareTo(this.fTimestamp2));
            Assert.assertEquals((String)"testTmfAsyncSequenceDiagramEvent", (Object)"sender", (Object)event.getSender());
            Assert.assertEquals((String)"testTmfAsyncSequenceDiagramEvent", (Object)"receiver", (Object)event.getReceiver());
            Assert.assertEquals((String)"testTmfAsyncSequenceDiagramEvent", (Object)"signal", (Object)event.getName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.fail();
        }
    }
}

