/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class LoadMetadataRepositoryJob
extends ProvisioningJob {
    public static final Object LOAD_FAMILY = new Object();
    public static final QualifiedName SUPPRESS_AUTHENTICATION_JOB_MARKER = new QualifiedName("org.eclipse.equinox.p2.ui", "SUPPRESS_AUTHENTICATION_REQUESTS");
    public static final QualifiedName SUPPRESS_REPOSITORY_EVENTS = new QualifiedName("org.eclipse.equinox.p2.ui", "SUPRESS_REPOSITORY_EVENTS");
    public static final QualifiedName WIZARD_CLIENT_SHOULD_SCHEDULE = new QualifiedName("org.eclipse.equinox.p2.ui", "WIZARD_CLIENT_SHOULD_SCHEDULE");
    public static final QualifiedName ACCUMULATE_LOAD_ERRORS = new QualifiedName("org.eclipse.equinox.p2.ui", "ACCUMULATE_LOAD_ERRORS");
    private List<IMetadataRepository> repoCache = new ArrayList<IMetadataRepository>();
    private RepositoryTracker tracker;
    private MultiStatus accumulatedStatus;
    private URI[] locations;
    private ProvisioningUI ui;

    public LoadMetadataRepositoryJob(ProvisioningUI ui) {
        super(ProvUIMessages.LoadMetadataRepositoryJob_ContactSitesProgress, ui.getSession());
        this.ui = ui;
        this.tracker = ui.getRepositoryTracker();
        this.locations = this.tracker.getKnownRepositories(ui.getSession());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus runModal(IProgressMonitor monitor) {
        IStatus status;
        if (this.locations == null) return Status.OK_STATUS;
        if (this.locations.length == 0) {
            return Status.OK_STATUS;
        }
        this.ui.signalRepositoryOperationStart();
        try {
            status = this.doLoad(monitor);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.ui.signalRepositoryOperationComplete(null, this.getProperty(SUPPRESS_REPOSITORY_EVENTS) == null);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.ui.signalRepositoryOperationComplete(null, this.getProperty(SUPPRESS_REPOSITORY_EVENTS) == null);
        return status;
    }

    private IStatus doLoad(IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)ProvUIMessages.LoadMetadataRepositoryJob_ContactSitesProgress, (int)(this.locations.length * 100));
        if (sub.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        int i = 0;
        while (i < this.locations.length) {
            if (sub.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                this.repoCache.add(ProvUI.getMetadataRepositoryManager(this.ui.getSession()).loadRepository(this.locations[i], (IProgressMonitor)sub.newChild(100)));
            }
            catch (ProvisionException e) {
                this.handleLoadFailure(e, this.locations[i]);
            }
            catch (OperationCanceledException operationCanceledException) {
                return Status.CANCEL_STATUS;
            }
            ++i;
        }
        return this.getCurrentStatus();
    }

    private void handleLoadFailure(ProvisionException e, URI location) {
        if (this.shouldAccumulateFailures()) {
            IStatus status = e.getStatus();
            if (status instanceof MultiStatus && ((MultiStatus)status).getChildren().length == 0) {
                status = new Status(4, status.getPlugin(), status.getCode(), status.getMessage(), status.getException());
            }
            if (this.accumulatedStatus == null) {
                this.accumulatedStatus = new MultiStatus("org.eclipse.equinox.p2.ui", 1000, new IStatus[]{status}, ProvUIMessages.LoadMetadataRepositoryJob_SitesMissingError, null);
            } else {
                this.accumulatedStatus.add(status);
            }
            this.ui.getRepositoryTracker().addNotFound(location);
            LogHelper.log((ProvisionException)e);
        } else {
            this.tracker.reportLoadFailure(location, e);
        }
    }

    private boolean shouldAccumulateFailures() {
        return this.getProperty(ACCUMULATE_LOAD_ERRORS) != null;
    }

    public void reportAccumulatedStatus() {
        IStatus status = this.getCurrentStatus();
        if (status.isOK() || status.getSeverity() == 8) {
            return;
        }
        if (!this.ui.getPolicy().getRepositoriesVisible()) {
            return;
        }
        StatusManager.getManager().handle(status, 2);
        this.accumulatedStatus = null;
    }

    private IStatus getCurrentStatus() {
        if (this.accumulatedStatus != null) {
            if (this.accumulatedStatus.getChildren().length == 1) {
                return this.accumulatedStatus.getChildren()[0];
            }
            return this.accumulatedStatus;
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return family == LOAD_FAMILY;
    }
}

