/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.simpleconfigurator.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.equinox.internal.simpleconfigurator.console.ConfiguratorCommandProvider;
import org.eclipse.equinox.internal.simpleconfigurator.utils.URIUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class EquinoxUtils {
    public static URL[] getConfigAreaURL(BundleContext context) {
        Location configLocation = EquinoxUtils.getConfigLocation(context);
        if (configLocation == null) {
            return null;
        }
        URL baseURL = configLocation.getURL();
        if (configLocation.getParentLocation() != null && configLocation.getURL() != null) {
            if (baseURL == null) {
                return new URL[]{configLocation.getParentLocation().getURL()};
            }
            return new URL[]{baseURL, configLocation.getParentLocation().getURL()};
        }
        if (baseURL != null) {
            return new URL[]{baseURL};
        }
        return null;
    }

    public static Location getConfigLocation(BundleContext context) {
        Location location;
        Filter filter = null;
        try {
            filter = context.createFilter(Location.CONFIGURATION_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        ServiceTracker configLocationTracker = new ServiceTracker(context, filter, null);
        configLocationTracker.open();
        try {
            location = (Location)configLocationTracker.getService();
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            configLocationTracker.close();
            throw throwable;
        }
        configLocationTracker.close();
        return location;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URI getInstallLocationURI(BundleContext context) {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.osgi.service.datalocation.Location");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            ServiceReference[] references = context.getServiceReferences(clazz.getName(), Location.INSTALL_FILTER);
            if (references == null) return null;
            if (references.length <= 0) return null;
            ServiceReference reference = references[0];
            Location installLocation = (Location)context.getService(reference);
            if (installLocation == null) return null;
            try {
                block9: {
                    URI uRI;
                    try {
                        if (!installLocation.isSet()) break block9;
                        URL location = installLocation.getURL();
                        uRI = URIUtil.toURI(location);
                        Object var5_6 = null;
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                    context.ungetService(reference);
                    return uRI;
                }
                Object var5_8 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                context.ungetService(reference);
                throw throwable;
            }
            context.ungetService(reference);
            return null;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return null;
    }

    public static ServiceRegistration registerConsoleCommands(BundleContext context) {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.osgi.framework.console.CommandProvider");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return context.registerService(clazz.getName(), (Object)new ConfiguratorCommandProvider(context), null);
    }
}

