/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.impl.ClientConnection;
import io.vertx.core.http.impl.WebSocketImplBase;
import io.vertx.core.impl.VertxInternal;

public class WebSocketImpl
extends WebSocketImplBase
implements WebSocket {
    private Object metric;

    public WebSocketImpl(VertxInternal vertx, ClientConnection conn, boolean supportsContinuation, int maxWebSocketFrameSize) {
        super(vertx, conn, supportsContinuation, maxWebSocketFrameSize);
    }

    synchronized void setMetric(Object metric) {
        this.metric = metric;
    }

    @Override
    public synchronized WebSocket handler(Handler<Buffer> handler) {
        if (handler != null) {
            this.checkClosed();
        }
        this.dataHandler = handler;
        return this;
    }

    @Override
    public synchronized WebSocket endHandler(Handler<Void> handler) {
        if (handler != null) {
            this.checkClosed();
        }
        this.endHandler = handler;
        return this;
    }

    @Override
    public synchronized WebSocket exceptionHandler(Handler<Throwable> handler) {
        if (handler != null) {
            this.checkClosed();
        }
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public WebSocket writeFrame(WebSocketFrame frame) {
        this.writeFrameInternal(frame);
        return this;
    }

    @Override
    public WebSocket writeFinalTextFrame(String text) {
        return this.writeFrame(WebSocketFrame.textFrame(text, true));
    }

    @Override
    public WebSocket writeFinalBinaryFrame(Buffer data) {
        return this.writeFrame(WebSocketFrame.binaryFrame(data, true));
    }

    @Override
    public WebSocket writeBinaryMessage(Buffer data) {
        this.writeMessageInternal(data);
        return this;
    }

    @Override
    public synchronized WebSocket closeHandler(Handler<Void> handler) {
        this.checkClosed();
        this.closeHandler = handler;
        return this;
    }

    @Override
    public synchronized WebSocket frameHandler(Handler<WebSocketFrame> handler) {
        this.checkClosed();
        this.frameHandler = handler;
        return this;
    }

    @Override
    public synchronized WebSocket pause() {
        this.checkClosed();
        this.conn.doPause();
        return this;
    }

    @Override
    public synchronized WebSocket resume() {
        this.checkClosed();
        this.conn.doResume();
        return this;
    }

    @Override
    public synchronized WebSocket setWriteQueueMaxSize(int maxSize) {
        this.checkClosed();
        this.conn.doSetWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public WebSocket write(Buffer data) {
        this.writeFrame(WebSocketFrame.binaryFrame(data, true));
        return this;
    }

    @Override
    public synchronized WebSocket drainHandler(Handler<Void> handler) {
        this.checkClosed();
        this.drainHandler = handler;
        return this;
    }

    @Override
    synchronized void handleClosed() {
        ((ClientConnection)this.conn).metrics().disconnected(this.metric);
        super.handleClosed();
    }
}

