/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.impl.Arguments;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetworkOptionsConverter;

@DataObject(generateConverter=true)
public abstract class NetworkOptions {
    public static final int DEFAULT_SEND_BUFFER_SIZE = -1;
    public static final int DEFAULT_RECEIVE_BUFFER_SIZE = -1;
    public static final int DEFAULT_TRAFFIC_CLASS = -1;
    public static final boolean DEFAULT_REUSE_ADDRESS = true;
    private int sendBufferSize;
    private int receiveBufferSize;
    private int trafficClass;
    private boolean reuseAddress;

    public NetworkOptions() {
        this.sendBufferSize = -1;
        this.receiveBufferSize = -1;
        this.reuseAddress = true;
        this.trafficClass = -1;
    }

    public NetworkOptions(NetworkOptions other) {
        this.sendBufferSize = other.getSendBufferSize();
        this.receiveBufferSize = other.getReceiveBufferSize();
        this.reuseAddress = other.isReuseAddress();
        this.trafficClass = other.getTrafficClass();
    }

    public NetworkOptions(JsonObject json) {
        this();
        NetworkOptionsConverter.fromJson(json, this);
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public NetworkOptions setSendBufferSize(int sendBufferSize) {
        Arguments.require(sendBufferSize > 0, "sendBufferSize must be > 0");
        this.sendBufferSize = sendBufferSize;
        return this;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public NetworkOptions setReceiveBufferSize(int receiveBufferSize) {
        Arguments.require(receiveBufferSize > 0, "receiveBufferSize must be > 0");
        this.receiveBufferSize = receiveBufferSize;
        return this;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public NetworkOptions setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
        return this;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public NetworkOptions setTrafficClass(int trafficClass) {
        Arguments.requireInRange(trafficClass, 0, 255, "trafficClass tc must be 0 <= tc <= 255");
        this.trafficClass = trafficClass;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkOptions)) {
            return false;
        }
        NetworkOptions that = (NetworkOptions)o;
        if (this.receiveBufferSize != that.receiveBufferSize) {
            return false;
        }
        if (this.reuseAddress != that.reuseAddress) {
            return false;
        }
        if (this.sendBufferSize != that.sendBufferSize) {
            return false;
        }
        return this.trafficClass == that.trafficClass;
    }

    public int hashCode() {
        int result = this.sendBufferSize;
        result = 31 * result + this.receiveBufferSize;
        result = 31 * result + this.trafficClass;
        result = 31 * result + (this.reuseAddress ? 1 : 0);
        return result;
    }
}

