/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseLongIterable;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;

final class ImmutableLongArrayList
implements ImmutableLongList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long[] items;

    private ImmutableLongArrayList(long[] newElements) {
        if (newElements.length <= 1) {
            throw new IllegalArgumentException("Use LongLists.immutable.with() to instantiate an optimized collection");
        }
        this.items = newElements;
    }

    public static ImmutableLongArrayList newList(LongIterable iterable) {
        return new ImmutableLongArrayList(iterable.toArray());
    }

    public static ImmutableLongArrayList newListWith(long ... elements) {
        long[] newArray = new long[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableLongArrayList(newArray);
    }

    @Override
    public long get(int index) {
        return this.items[index];
    }

    @Override
    public long getFirst() {
        return this.items[0];
    }

    @Override
    public long getLast() {
        return this.items[this.items.length - 1];
    }

    @Override
    public int indexOf(long value) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(long value) {
        for (int i = this.items.length - 1; i >= 0; --i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public LongIterator longIterator() {
        return new InternalLongIterator();
    }

    @Override
    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(LongProcedure procedure) {
        for (long item : this.items) {
            procedure.value(item);
        }
    }

    @Override
    public void forEachWithIndex(LongIntProcedure procedure) {
        for (int i = 0; i < this.items.length; ++i) {
            procedure.value(this.items[i], i);
        }
    }

    @Override
    public int count(LongPredicate predicate) {
        int count = 0;
        for (long item : this.items) {
            if (!predicate.accept(item)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        for (long item : this.items) {
            if (!predicate.accept(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        for (long item : this.items) {
            if (predicate.accept(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(LongPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    @Override
    public ImmutableLongList select(LongPredicate predicate) {
        return this.select(predicate, new LongArrayList()).toImmutable();
    }

    @Override
    public <R extends MutableLongCollection> R select(LongPredicate predicate, R target) {
        for (long item : this.items) {
            if (!predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    @Override
    public ImmutableLongList reject(LongPredicate predicate) {
        return this.reject(predicate, new LongArrayList()).toImmutable();
    }

    @Override
    public <R extends MutableLongCollection> R reject(LongPredicate predicate, R target) {
        for (long item : this.items) {
            if (predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    @Override
    public long detectIfNone(LongPredicate predicate, long ifNone) {
        for (long item : this.items) {
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    @Override
    public <V> ImmutableList<V> collect(LongToObjectFunction<? extends V> function) {
        FastList list = this.collect(function, FastList.newList(this.items.length));
        return list.toImmutable();
    }

    @Override
    public <V, R extends Collection<V>> R collect(LongToObjectFunction<? extends V> function, R target) {
        for (long item : this.items) {
            target.add(function.valueOf(item));
        }
        return target;
    }

    @Override
    public long sum() {
        long result = 0L;
        for (long item : this.items) {
            result += item;
        }
        return result;
    }

    @Override
    public long max() {
        long max = this.items[0];
        for (int i = 1; i < this.items.length; ++i) {
            long value = this.items[i];
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    @Override
    public long maxIfEmpty(long defaultValue) {
        return this.max();
    }

    @Override
    public long min() {
        long min = this.items[0];
        for (int i = 1; i < this.items.length; ++i) {
            long value = this.items[i];
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    @Override
    public long minIfEmpty(long defaultValue) {
        return this.min();
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        long[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            long first = sortedArray[middleIndex];
            long second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public long[] toSortedArray() {
        long[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public long dotProduct(LongList list) {
        if (this.size() != list.size()) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        long sum = 0L;
        for (int i = 0; i < this.size(); ++i) {
            sum += this.items[i] * list.get(i);
        }
        return sum;
    }

    @Override
    public LazyLongIterable asReversed() {
        return ReverseLongIterable.adapt(this);
    }

    @Override
    public MutableLongList toSortedList() {
        return LongArrayList.newList(this).sortThis();
    }

    @Override
    public int binarySearch(long value) {
        return Arrays.binarySearch(this.items, value);
    }

    @Override
    public long[] toArray() {
        long[] newItems = new long[this.items.length];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        return newItems;
    }

    @Override
    public boolean contains(long value) {
        for (long item : this.items) {
            if (item != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(long ... source) {
        for (long value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(LongIterable source) {
        LongIterator iterator = source.longIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableLongList toList() {
        return LongArrayList.newList(this);
    }

    @Override
    public MutableLongSet toSet() {
        return LongHashSet.newSet(this);
    }

    @Override
    public MutableLongBag toBag() {
        return LongHashBag.newBag(this);
    }

    @Override
    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter(this);
    }

    @Override
    public ImmutableLongList toImmutable() {
        return this;
    }

    @Override
    public ImmutableLongArrayList toReversed() {
        return ImmutableLongArrayList.newList(this.asReversed());
    }

    @Override
    public ImmutableLongList newWith(long element) {
        long[] newItems = new long[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        newItems[this.items.length] = element;
        return new ImmutableLongArrayList(newItems);
    }

    @Override
    public ImmutableLongList newWithout(long element) {
        int index = this.indexOf(element);
        if (index != -1) {
            long[] newItems = new long[this.items.length - 1];
            System.arraycopy(this.items, 0, newItems, 0, index);
            System.arraycopy(this.items, index + 1, newItems, index, this.items.length - index - 1);
            return LongLists.immutable.with(newItems);
        }
        return this;
    }

    @Override
    public ImmutableLongList newWithAll(LongIterable elements) {
        long[] newItems = new long[this.items.length + elements.size()];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        int index = 0;
        LongIterator iterator = elements.longIterator();
        while (iterator.hasNext()) {
            newItems[this.items.length + index] = iterator.next();
            ++index;
        }
        return new ImmutableLongArrayList(newItems);
    }

    @Override
    public ImmutableLongList newWithoutAll(LongIterable elements) {
        MutableLongList mutableLongList = this.toList();
        mutableLongList.removeAll(elements);
        return mutableLongList.toImmutable();
    }

    @Override
    public int size() {
        return this.items.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        for (int i = 0; i < this.items.length; ++i) {
            result = function.valueOf(result, this.items[i]);
        }
        return result;
    }

    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectLongIntToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        for (int i = 0; i < this.items.length; ++i) {
            result = function.valueOf(result, this.items[i], i);
        }
        return result;
    }

    @Override
    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof LongList)) {
            return false;
        }
        LongList list = (LongList)otherList;
        if (this.items.length != list.size()) {
            return false;
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == list.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (long item : this.items) {
            hashCode = 31 * hashCode + (int)(item ^ item >>> 32);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            for (int i = 0; i < this.items.length; ++i) {
                if (i > 0) {
                    appendable.append(separator);
                }
                long value = this.items[i];
                appendable.append(String.valueOf(value));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ImmutableLongList distinct() {
        LongArrayList target = new LongArrayList();
        LongHashSet seenSoFar = new LongHashSet(this.size());
        for (long each : this.items) {
            if (!seenSoFar.add(each)) continue;
            target.add(each);
        }
        return target.toImmutable();
    }

    @Override
    public ImmutableLongList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    private class InternalLongIterator
    implements LongIterator {
        private int currentIndex;

        private InternalLongIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex != ImmutableLongArrayList.this.items.length;
        }

        @Override
        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long next = ImmutableLongArrayList.this.items[this.currentIndex];
            ++this.currentIndex;
            return next;
        }
    }
}

