/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.generator.operations;

import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystem;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.HostType;
import org.eclipse.viatra.examples.cps.generator.dtos.CPSFragment;
import org.eclipse.viatra.examples.cps.generator.dtos.HostClass;
import org.eclipse.viatra.examples.cps.generator.utils.CPSModelBuilderUtil;
import org.eclipse.viatra.examples.cps.generator.utils.RandomUtils;
import org.eclipse.viatra.examples.cps.planexecutor.api.IOperation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;

public class HostTypeGenerationOperation
implements IOperation<CPSFragment> {
    private final HostClass hostClass;
    @Extension
    private CPSModelBuilderUtil modelBuilder;
    @Extension
    private RandomUtils randUtil;

    public HostTypeGenerationOperation(HostClass applicationClass) {
        RandomUtils _randomUtils;
        CPSModelBuilderUtil _cPSModelBuilderUtil;
        this.hostClass = applicationClass;
        this.modelBuilder = _cPSModelBuilderUtil = new CPSModelBuilderUtil();
        this.randUtil = _randomUtils = new RandomUtils();
    }

    public boolean execute(CPSFragment fragment) {
        try {
            boolean _xblockexpression = false;
            int numberOfHostTypes = this.randUtil.randInt(this.hostClass.numberOfHostTypes, fragment.getRandom());
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, numberOfHostTypes, true);
            for (Integer i : _doubleDotLessThan) {
                String hostTypeId = "simple.cps.host." + this.hostClass.name + i;
                HostType hostType = this.modelBuilder.prepareHostTypeWithId((CyberPhysicalSystem)fragment.modelRoot, hostTypeId);
                fragment.addHostType(this.hostClass, hostType);
            }
            _xblockexpression = true;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

