/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.batch.simple;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationType;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystem;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.HostInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Identifiable;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.State;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.StateMachine;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Transition;
import org.eclipse.viatra.examples.cps.deployment.BehaviorState;
import org.eclipse.viatra.examples.cps.deployment.BehaviorTransition;
import org.eclipse.viatra.examples.cps.deployment.Deployment;
import org.eclipse.viatra.examples.cps.deployment.DeploymentApplication;
import org.eclipse.viatra.examples.cps.deployment.DeploymentBehavior;
import org.eclipse.viatra.examples.cps.deployment.DeploymentElement;
import org.eclipse.viatra.examples.cps.deployment.DeploymentFactory;
import org.eclipse.viatra.examples.cps.deployment.DeploymentHost;
import org.eclipse.viatra.examples.cps.traceability.CPS2DeploymentTrace;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.examples.cps.traceability.TraceabilityFactory;
import org.eclipse.viatra.examples.cps.xform.m2m.util.NamingUtil;
import org.eclipse.viatra.examples.cps.xform.m2m.util.SignalUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class CPS2DeploymentBatchTransformationSimple {
    @Extension
    private Logger logger = Logger.getLogger((String)"cps.xform.m2m.batch.simple");
    private CPSToDeployment mapping;

    private void traceBegin(String method) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing ");
        _builder.append(method);
        _builder.append(" BEGIN");
        this.logger.trace((Object)_builder);
    }

    private void traceEnd(String method) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing ");
        _builder.append(method);
        _builder.append(" END");
        this.logger.trace((Object)_builder);
    }

    public CPS2DeploymentBatchTransformationSimple(CPSToDeployment mapping) {
        this.traceBegin("constructor");
        Preconditions.checkNotNull((Object)mapping, (Object)"Mapping cannot be null!");
        CyberPhysicalSystem _cps = mapping.getCps();
        boolean _tripleNotEquals = _cps != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"CPS not defined in mapping!");
        Deployment _deployment = mapping.getDeployment();
        boolean _tripleNotEquals_1 = _deployment != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_1, (Object)"Deployment not defined in mapping!");
        this.mapping = mapping;
        this.traceEnd("constructor");
    }

    public void execute() {
        this.traceBegin("execute()");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing transformation on:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Cyber-physical system: ");
        String _identifier = this.mapping.getCps().getIdentifier();
        _builder.append(_identifier, "\t");
        this.logger.info((Object)_builder);
        this.mapping.getTraces().clear();
        this.mapping.getDeployment().getHosts().clear();
        Functions.Function1 _function = it -> it.getInstances();
        Iterable hosts = Iterables.concat((Iterable)ListExtensions.map((List)this.mapping.getCps().getHostTypes(), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> this.transform((HostInstance)it);
        ImmutableList deploymentHosts = ImmutableList.copyOf((Iterable)IterableExtensions.map((Iterable)hosts, (Functions.Function1)_function_1));
        EList _hosts = this.mapping.getDeployment().getHosts();
        Iterables.addAll((Collection)_hosts, (Iterable)deploymentHosts);
        this.assignTriggers();
        this.traceEnd("execute()");
    }

    private void assignTriggers() {
        this.traceBegin("assignTriggers()");
        Functions.Function1 _function = it -> {
            DeploymentElement _head = (DeploymentElement)IterableExtensions.head((Iterable)it.getDeploymentElements());
            return _head instanceof BehaviorTransition;
        };
        Iterable transitionMappings = IterableExtensions.filter((Iterable)this.mapping.getTraces(), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> this.isTraceForSender((CPS2DeploymentTrace)it);
        Iterable senderTransitionMappings = IterableExtensions.filter((Iterable)transitionMappings, (Functions.Function1)_function_1);
        Consumer<CPS2DeploymentTrace> _function_2 = it -> this.findAndAssignReceivers((CPS2DeploymentTrace)it);
        senderTransitionMappings.forEach(_function_2);
        this.traceEnd("assignTriggers()");
    }

    private void findAndAssignReceivers(CPS2DeploymentTrace senderTrace) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("findReceivers(");
        String _name = NamingUtil.name((EObject)senderTrace);
        _builder.append(_name);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        Functions.Function1 _function = it -> {
            DeploymentElement _head = (DeploymentElement)IterableExtensions.head((Iterable)it.getDeploymentElements());
            return _head instanceof BehaviorTransition;
        };
        Iterable receiverTraces = IterableExtensions.filter((Iterable)this.mapping.getTraces(), (Functions.Function1)_function);
        Consumer<CPS2DeploymentTrace> _function_1 = it -> this.setTriggerIfConnected((CPS2DeploymentTrace)it, senderTrace);
        receiverTraces.forEach(_function_1);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("findReceivers(");
        String _name_1 = NamingUtil.name((EObject)senderTrace);
        _builder_1.append(_name_1);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
    }

    private void setTriggerIfConnected(CPS2DeploymentTrace receiverTrace, CPS2DeploymentTrace senderTrace) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("setTriggerIfConnected(");
        String _name = NamingUtil.name((EObject)receiverTrace);
        _builder.append(_name);
        _builder.append(",");
        String _name_1 = NamingUtil.name((EObject)senderTrace);
        _builder.append(_name_1);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        boolean _isTraceForReceiver = this.isTraceForReceiver(receiverTrace);
        boolean bl = _not = !_isTraceForReceiver;
        if (_not) {
            return;
        }
        EList _deploymentElements = receiverTrace.getDeploymentElements();
        for (DeploymentElement i : _deploymentElements) {
            EList _deploymentElements_1 = senderTrace.getDeploymentElements();
            for (DeploymentElement j : _deploymentElements_1) {
                boolean _isConnectedTo;
                Identifiable _head_3;
                Transition senderTransition;
                String appId1;
                BehaviorTransition receiverBehaviorTransition = (BehaviorTransition)i;
                EObject _eContainer = receiverBehaviorTransition.eContainer().eContainer();
                DeploymentApplication receiverDeploymentApp = (DeploymentApplication)_eContainer;
                EObject _eContainer_1 = receiverDeploymentApp.eContainer();
                DeploymentHost receiverDeploymentHost = (DeploymentHost)_eContainer_1;
                Functions.Function1 _function = it -> {
                    DeploymentElement _head = (DeploymentElement)IterableExtensions.head((Iterable)it.getDeploymentElements());
                    return Objects.equal((Object)_head, (Object)receiverDeploymentHost);
                };
                Identifiable _head = (Identifiable)IterableExtensions.head((Iterable)((CPS2DeploymentTrace)IterableExtensions.findFirst((Iterable)this.mapping.getTraces(), (Functions.Function1)_function)).getCpsElements());
                HostInstance receiverHostInstance = (HostInstance)_head;
                BehaviorTransition senderBehaviorTransition = (BehaviorTransition)j;
                EObject _eContainer_2 = senderBehaviorTransition.eContainer().eContainer();
                DeploymentApplication senderDeploymentApp = (DeploymentApplication)_eContainer_2;
                EObject _eContainer_3 = senderDeploymentApp.eContainer();
                DeploymentHost senderDeploymentHost = (DeploymentHost)_eContainer_3;
                Functions.Function1 _function_1 = it -> {
                    DeploymentElement _head_1 = (DeploymentElement)IterableExtensions.head((Iterable)it.getDeploymentElements());
                    return Objects.equal((Object)_head_1, (Object)senderDeploymentHost);
                };
                Identifiable _head_1 = (Identifiable)IterableExtensions.head((Iterable)((CPS2DeploymentTrace)IterableExtensions.findFirst((Iterable)this.mapping.getTraces(), (Functions.Function1)_function_1)).getCpsElements());
                HostInstance senderHostInstance = (HostInstance)_head_1;
                Functions.Function1 _function_2 = it -> {
                    DeploymentElement _head_2 = (DeploymentElement)IterableExtensions.head((Iterable)it.getDeploymentElements());
                    return Objects.equal((Object)_head_2, (Object)receiverDeploymentApp);
                };
                Identifiable _head_2 = (Identifiable)IterableExtensions.head((Iterable)((CPS2DeploymentTrace)IterableExtensions.findFirst((Iterable)this.mapping.getTraces(), (Functions.Function1)_function_2)).getCpsElements());
                ApplicationInstance appInstance = (ApplicationInstance)_head_2;
                String appTypeId = appInstance.getType().getIdentifier();
                if (!Objects.equal((Object)appTypeId, (Object)(appId1 = SignalUtil.getAppId((String)(senderTransition = (Transition)(_head_3 = (Identifiable)IterableExtensions.head((Iterable)senderTrace.getCpsElements()))).getAction()))) || !Objects.equal((Object)SignalUtil.getSignalId((String)((Transition)IterableExtensions.head((Iterable)senderTrace.getCpsElements())).getAction()), (Object)SignalUtil.getSignalId((String)((Transition)IterableExtensions.head((Iterable)receiverTrace.getCpsElements())).getAction())) || !(_isConnectedTo = this.isConnectedTo(senderHostInstance, receiverHostInstance))) continue;
                BehaviorTransition sender = senderBehaviorTransition;
                BehaviorTransition receiver = receiverBehaviorTransition;
                EList _trigger = sender.getTrigger();
                _trigger.add((Object)receiver);
            }
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("setTriggerIfConnected(");
        String _name_2 = NamingUtil.name((EObject)receiverTrace);
        _builder_1.append(_name_2);
        _builder_1.append(",");
        String _name_3 = NamingUtil.name((EObject)senderTrace);
        _builder_1.append(_name_3);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
    }

    private boolean isTraceForSender(CPS2DeploymentTrace trace) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("isTraceForSender");
        String _name = NamingUtil.name((EObject)trace);
        _builder.append(_name);
        this.traceBegin(_builder.toString());
        boolean isSender = false;
        EList elements = trace.getCpsElements();
        for (Identifiable t : elements) {
            boolean bl = isSender = isSender || this.isTransitionSender((Transition)t);
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("isTraceForSender");
        String _name_1 = NamingUtil.name((EObject)trace);
        _builder_1.append(_name_1);
        this.traceEnd(_builder_1.toString());
        return isSender;
    }

    private boolean isTransitionSender(Transition transition) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("isTransitionSender(");
        String _name = NamingUtil.name((EObject)transition);
        _builder.append(_name);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        String _action = transition.getAction();
        boolean bl = _tripleEquals = _action == null;
        if (_tripleEquals) {
            return false;
        }
        boolean _isSend = SignalUtil.isSend((String)transition.getAction());
        if (_isSend) {
            return true;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("isTransitionSender(");
        String _name_1 = NamingUtil.name((EObject)transition);
        _builder_1.append(_name_1);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
        return false;
    }

    private boolean isTraceForReceiver(CPS2DeploymentTrace trace) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("isTraceForReceiver(");
        String _name = NamingUtil.name((EObject)trace);
        _builder.append(_name);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        boolean isReceiver = false;
        EList elements = trace.getCpsElements();
        for (Identifiable t : elements) {
            boolean bl = isReceiver = isReceiver || this.isTransitionReceiver((Transition)t);
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("isTraceForReceiver(");
        String _name_1 = NamingUtil.name((EObject)trace);
        _builder_1.append(_name_1);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
        return isReceiver;
    }

    private boolean isTransitionReceiver(Transition transition) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("isTransitionReceiver(");
        String _name = NamingUtil.name((EObject)transition);
        _builder.append(_name);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        String _action = transition.getAction();
        boolean bl = _tripleEquals = _action == null;
        if (_tripleEquals) {
            return false;
        }
        boolean _isWait = SignalUtil.isWait((String)transition.getAction());
        if (_isWait) {
            return true;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("isTransitionReceiver(");
        String _name_1 = NamingUtil.name((EObject)transition);
        _builder_1.append(_name_1);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
        return false;
    }

    private boolean isConnectedTo(HostInstance src, HostInstance dst) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("isConnectedTo(");
        String _name = NamingUtil.name((EObject)src);
        _builder.append(_name);
        _builder.append(", ");
        String _name_1 = NamingUtil.name((EObject)dst);
        _builder.append(_name_1);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        boolean communicates = Objects.equal((Object)src, (Object)dst) || src.getCommunicateWith().contains((Object)dst);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("isConnectedTo(");
        String _name_2 = NamingUtil.name((EObject)src);
        _builder_1.append(_name_2);
        _builder_1.append(", ");
        String _name_3 = NamingUtil.name((EObject)dst);
        _builder_1.append(_name_3);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
        return communicates;
    }

    private DeploymentHost transform(HostInstance hostInstance) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("transform(");
        String _name = NamingUtil.name((EObject)hostInstance);
        _builder.append(_name);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        DeploymentHost deploymentHost = DeploymentFactory.eINSTANCE.createDeploymentHost();
        deploymentHost.setIp(hostInstance.getNodeIp());
        this.createOrAddTrace((Identifiable)hostInstance, (DeploymentElement)deploymentHost);
        Functions.Function1 _function = it -> {
            ApplicationType _type = it.getType();
            CyberPhysicalSystem _cps = null;
            if (_type != null) {
                _cps = _type.getCps();
            }
            CyberPhysicalSystem _cps_1 = this.mapping.getCps();
            return Objects.equal((Object)_cps, (Object)_cps_1);
        };
        Iterable liveApplications = IterableExtensions.filter((Iterable)hostInstance.getApplications(), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> this.transform((ApplicationInstance)it);
        Iterable deploymentApps = IterableExtensions.map((Iterable)liveApplications, (Functions.Function1)_function_1);
        EList _applications = deploymentHost.getApplications();
        Iterables.addAll((Collection)_applications, (Iterable)deploymentApps);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("transform(");
        String _name_1 = NamingUtil.name((EObject)hostInstance);
        _builder_1.append(_name_1);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
        return deploymentHost;
    }

    private DeploymentApplication transform(ApplicationInstance appInstance) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("transform(");
        String _name = NamingUtil.name((EObject)appInstance);
        _builder.append(_name);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        DeploymentApplication deploymentApp = DeploymentFactory.eINSTANCE.createDeploymentApplication();
        deploymentApp.setId(appInstance.getIdentifier());
        this.createOrAddTrace((Identifiable)appInstance, (DeploymentElement)deploymentApp);
        StateMachine _behavior = appInstance.getType().getBehavior();
        boolean bl = _tripleNotEquals = _behavior != null;
        if (_tripleNotEquals) {
            deploymentApp.setBehavior(this.transform(appInstance.getType().getBehavior()));
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("transform(");
        String _name_1 = NamingUtil.name((EObject)appInstance);
        _builder_1.append(_name_1);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
        return deploymentApp;
    }

    private DeploymentBehavior transform(StateMachine stateMachine) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("transform(");
        String _name = NamingUtil.name((EObject)stateMachine);
        _builder.append(_name);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        DeploymentBehavior behavior = DeploymentFactory.eINSTANCE.createDeploymentBehavior();
        behavior.setDescription(stateMachine.getIdentifier());
        this.createOrAddTrace((Identifiable)stateMachine, (DeploymentElement)behavior);
        Functions.Function1 _function = it -> this.transform((State)it);
        List behaviorStates = ListExtensions.map((List)stateMachine.getStates(), (Functions.Function1)_function);
        EList _states = behavior.getStates();
        Iterables.addAll((Collection)_states, (Iterable)behaviorStates);
        ArrayList behaviorTransitions = new ArrayList();
        EList _states_1 = stateMachine.getStates();
        for (State state : _states_1) {
            Functions.Function1 _function_1 = it -> it.getCpsElements().contains((Object)state);
            CPS2DeploymentTrace stateMapping = (CPS2DeploymentTrace)IterableExtensions.findFirst((Iterable)this.mapping.getTraces(), (Functions.Function1)_function_1);
            Functions.Function1 _function_2 = it -> behavior.getStates().contains(it);
            BehaviorState parentBehaviorState = (BehaviorState)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)stateMapping.getDeploymentElements(), BehaviorState.class), (Functions.Function1)_function_2);
            Functions.Function1 _function_3 = it -> {
                State _targetState = it.getTargetState();
                return _targetState != null;
            };
            Functions.Function1 _function_4 = transition -> IterableExtensions.findFirst((Iterable)this.mapping.getTraces(), it -> it.getCpsElements().contains((Object)transition.getTargetState())) != null && transition.getTargetState() != null;
            Functions.Function1 _function_5 = it -> this.transform((Transition)it, parentBehaviorState);
            Iterables.addAll(behaviorTransitions, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)state.getOutgoingTransitions(), (Functions.Function1)_function_3), (Functions.Function1)_function_4), (Functions.Function1)_function_5));
        }
        EList _transitions = behavior.getTransitions();
        Iterables.addAll((Collection)_transitions, behaviorTransitions);
        this.setCurrentState(stateMachine, behavior);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("transform(");
        String _name_1 = NamingUtil.name((EObject)stateMachine);
        _builder_1.append(_name_1);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
        return behavior;
    }

    private BehaviorState transform(State state) {
        BehaviorState _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("transform(");
        String _name = NamingUtil.name((EObject)state);
        _builder.append(_name);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        BehaviorState behaviorState = DeploymentFactory.eINSTANCE.createBehaviorState();
        behaviorState.setDescription(state.getIdentifier());
        this.createOrAddTrace((Identifiable)state, (DeploymentElement)behaviorState);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("transform(");
        String _name_1 = NamingUtil.name((EObject)state);
        _builder_1.append(_name_1);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
        _xblockexpression = behaviorState;
        return _xblockexpression;
    }

    private BehaviorTransition transform(Transition transition, BehaviorState behaviorState) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("transform(");
        String _name = NamingUtil.name((EObject)transition);
        _builder.append(_name);
        _builder.append(", ");
        String _name_1 = NamingUtil.name((EObject)behaviorState);
        _builder.append(_name_1);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        BehaviorTransition behaviorTransition = DeploymentFactory.eINSTANCE.createBehaviorTransition();
        Functions.Function1 _function = it -> it.getCpsElements().contains((Object)transition.getTargetState());
        CPS2DeploymentTrace targetStateMapping = (CPS2DeploymentTrace)IterableExtensions.findFirst((Iterable)this.mapping.getTraces(), (Functions.Function1)_function);
        EList dep = targetStateMapping.getDeploymentElements();
        Functions.Function1 _function_1 = it -> it.eContainer().equals(behaviorState.eContainer());
        BehaviorState targetBehaviorState = (BehaviorState)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)dep, BehaviorState.class), (Functions.Function1)_function_1);
        behaviorTransition.setTo(targetBehaviorState);
        EList _outgoing = behaviorState.getOutgoing();
        _outgoing.add((Object)behaviorTransition);
        behaviorTransition.setDescription(transition.getIdentifier());
        this.createOrAddTrace((Identifiable)transition, (DeploymentElement)behaviorTransition);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("transform(");
        String _name_2 = NamingUtil.name((EObject)transition);
        _builder_1.append(_name_2);
        _builder_1.append(", ");
        String _name_3 = NamingUtil.name((EObject)behaviorState);
        _builder_1.append(_name_3);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
        return behaviorTransition;
    }

    private void setCurrentState(StateMachine stateMachine, DeploymentBehavior behavior) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("transform(");
        String _name = NamingUtil.name((EObject)stateMachine);
        _builder.append(_name);
        _builder.append(", ");
        String _name_1 = NamingUtil.name((EObject)behavior);
        _builder.append(_name_1);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        Functions.Function1 _function = it -> {
            State _initial = stateMachine.getInitial();
            return Objects.equal((Object)_initial, (Object)it);
        };
        State initial = (State)IterableExtensions.findFirst((Iterable)stateMachine.getStates(), (Functions.Function1)_function);
        if (initial != null) {
            Functions.Function1 _function_1 = it -> it.getCpsElements().contains((Object)initial);
            CPS2DeploymentTrace mappingForInitialState = (CPS2DeploymentTrace)IterableExtensions.findFirst((Iterable)this.mapping.getTraces(), (Functions.Function1)_function_1);
            Functions.Function1 _function_2 = it -> behavior.getStates().contains(it);
            DeploymentElement initialBehaviorState = (DeploymentElement)IterableExtensions.findFirst((Iterable)mappingForInitialState.getDeploymentElements(), (Functions.Function1)_function_2);
            behavior.setCurrent((BehaviorState)initialBehaviorState);
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("transform(");
        String _name_2 = NamingUtil.name((EObject)stateMachine);
        _builder_1.append(_name_2);
        _builder_1.append(", ");
        String _name_3 = NamingUtil.name((EObject)behavior);
        _builder_1.append(_name_3);
        _builder_1.append(")");
        this.traceEnd(_builder_1.toString());
    }

    private void createOrAddTrace(Identifiable identifiable, DeploymentElement deploymentElement) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("createOrAddTrace(");
        String _name = NamingUtil.name((EObject)identifiable);
        _builder.append(_name);
        _builder.append(", ");
        String _name_1 = NamingUtil.name((EObject)deploymentElement);
        _builder.append(_name_1);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        Functions.Function1 _function = it -> it.getCpsElements().contains((Object)identifiable);
        Iterable trace = IterableExtensions.filter((Iterable)this.mapping.getTraces(), (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)trace);
        if (_isEmpty) {
            this.createTrace(identifiable, deploymentElement);
        } else {
            boolean _not;
            EList _deploymentElements = ((CPS2DeploymentTrace)IterableExtensions.head((Iterable)trace)).getDeploymentElements();
            _deploymentElements.add((Object)deploymentElement);
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)IterableExtensions.tail((Iterable)trace));
            boolean bl = _not = !_isEmpty_1;
            if (_not) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("More than one mapping was created to state machine with Id '");
                String _identifier = identifiable.getIdentifier();
                _builder_1.append(_identifier);
                _builder_1.append("'.");
                throw new IllegalStateException(_builder_1.toString());
            }
        }
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("createOrAddTrace(");
        String _name_2 = NamingUtil.name((EObject)identifiable);
        _builder_2.append(_name_2);
        _builder_2.append(", ");
        String _name_3 = NamingUtil.name((EObject)deploymentElement);
        _builder_2.append(_name_3);
        _builder_2.append(")");
        this.traceEnd(_builder_2.toString());
    }

    private void createTrace(Identifiable identifiable, DeploymentElement deploymentElement) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("createTrace(");
        String _name = NamingUtil.name((EObject)identifiable);
        _builder.append(_name);
        _builder.append(", ");
        String _name_1 = NamingUtil.name((EObject)deploymentElement);
        _builder.append(_name_1);
        _builder.append(")");
        this.traceBegin(_builder.toString());
        CPS2DeploymentTrace trace = TraceabilityFactory.eINSTANCE.createCPS2DeploymentTrace();
        EList _cpsElements = trace.getCpsElements();
        _cpsElements.add((Object)identifiable);
        EList _deploymentElements = trace.getDeploymentElements();
        _deploymentElements.add((Object)deploymentElement);
        EList _traces = this.mapping.getTraces();
        _traces.add((Object)trace);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("createTrace(");
        String _name_2 = NamingUtil.name((EObject)identifiable);
        _builder_1.append(_name_2);
        _builder_1.append(", ");
        String _name_3 = NamingUtil.name((EObject)deploymentElement);
        _builder_1.append(_name_3);
        _builder_1.append(")");
        this.traceBegin(_builder_1.toString());
    }

    public void dispose() {
        this.traceBegin("dispose()");
        this.traceEnd("dispose()");
    }
}

