/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.batch.optimized;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationType;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystem;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.HostInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.HostType;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Identifiable;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.State;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.StateMachine;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Transition;
import org.eclipse.viatra.examples.cps.deployment.BehaviorState;
import org.eclipse.viatra.examples.cps.deployment.BehaviorTransition;
import org.eclipse.viatra.examples.cps.deployment.Deployment;
import org.eclipse.viatra.examples.cps.deployment.DeploymentApplication;
import org.eclipse.viatra.examples.cps.deployment.DeploymentBehavior;
import org.eclipse.viatra.examples.cps.deployment.DeploymentElement;
import org.eclipse.viatra.examples.cps.deployment.DeploymentFactory;
import org.eclipse.viatra.examples.cps.deployment.DeploymentHost;
import org.eclipse.viatra.examples.cps.traceability.CPS2DeploymentTrace;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.examples.cps.traceability.TraceabilityFactory;
import org.eclipse.viatra.examples.cps.xform.m2m.util.NamingUtil;
import org.eclipse.viatra.examples.cps.xform.m2m.util.SignalUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class CPS2DeploymentBatchTransformationOptimized {
    @Extension
    private Logger logger = Logger.getLogger((String)"cps.xform.m2m.batch.optimized");
    private Stopwatch clearModelPerformance;
    private Stopwatch hostTransformationPerformance;
    private Stopwatch appTransformationPerformance;
    private Stopwatch stateMachineTransformationPerformance;
    private Stopwatch stateTransformationPerformance;
    private Stopwatch transitionTransformationPerformance;
    private Stopwatch triggerTransformationPerformance;
    private Stopwatch transitionMappingCachingPerformance;
    private Stopwatch otherTimer;
    private CPSToDeployment mapping;
    private HashMultimap<Identifiable, DeploymentElement> mappingCache;
    private Map<DeploymentElement, Identifiable> reverseMappingCache;
    private final HashMap<Object, Object> transitionToAppId = Maps.newHashMap();
    private final HashMap<Object, Object> transitionToActionId = Maps.newHashMap();
    private Map<BehaviorTransition, HostInstance> transitionToHost = Maps.newHashMap();

    private void traceBegin(String method) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Executing ");
        _builder.append((Object)method);
        _builder.append((Object)" BEGIN");
        this.logger.trace((Object)_builder);
    }

    private void traceEnd(String method) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Executing ");
        _builder.append((Object)method);
        _builder.append((Object)" END");
        this.logger.trace((Object)_builder);
    }

    private Stopwatch initPerformanceTimers() {
        Stopwatch _xblockexpression = null;
        this.clearModelPerformance = Stopwatch.createUnstarted();
        this.hostTransformationPerformance = Stopwatch.createUnstarted();
        this.appTransformationPerformance = Stopwatch.createUnstarted();
        this.stateMachineTransformationPerformance = Stopwatch.createUnstarted();
        this.stateTransformationPerformance = Stopwatch.createUnstarted();
        this.transitionTransformationPerformance = Stopwatch.createUnstarted();
        this.triggerTransformationPerformance = Stopwatch.createUnstarted();
        this.transitionMappingCachingPerformance = Stopwatch.createUnstarted();
        _xblockexpression = this.otherTimer = Stopwatch.createUnstarted();
        return _xblockexpression;
    }

    public CPS2DeploymentBatchTransformationOptimized(CPSToDeployment mapping) {
        this.traceBegin("constructor");
        boolean _notEquals = !Objects.equal((Object)mapping, null);
        Preconditions.checkNotNull((Object)_notEquals, (Object)"Mapping cannot be null!");
        CyberPhysicalSystem _cps = mapping.getCps();
        boolean _notEquals_1 = !Objects.equal((Object)_cps, null);
        Preconditions.checkArgument((boolean)_notEquals_1, (Object)"CPS not defined in mapping!");
        Deployment _deployment = mapping.getDeployment();
        boolean _notEquals_2 = !Objects.equal((Object)_deployment, null);
        Preconditions.checkArgument((boolean)_notEquals_2, (Object)"Deployment not defined in mapping!");
        this.mapping = mapping;
        this.mappingCache = HashMultimap.create();
        this.reverseMappingCache = Maps.newHashMap();
        this.traceEnd("constructor");
    }

    private void reportPerformance() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)">>>Cleared model in: ");
        long _elapsed = this.clearModelPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed);
        _builder.append((Object)" ms");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)">>>Host transformation: ");
        long _elapsed_1 = this.hostTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_1);
        _builder.append((Object)" ms");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)">>>Application Instance transformation: ");
        long _elapsed_2 = this.appTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_2);
        _builder.append((Object)" ms");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)">>>State Machine transformation: ");
        long _elapsed_3 = this.stateMachineTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_3);
        _builder.append((Object)" ms");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)">>>State transformation: ");
        long _elapsed_4 = this.stateTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_4);
        _builder.append((Object)" ms");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)">>>Transition transformation: ");
        long _elapsed_5 = this.transitionTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_5);
        _builder.append((Object)" ms");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)">>>Trigger transformation: ");
        long _elapsed_6 = this.triggerTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_6);
        _builder.append((Object)" ms");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)">>>Other perf: ");
        long _elapsed_7 = this.otherTimer.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_7);
        _builder.append((Object)" ms");
        this.logger.debug((Object)_builder);
    }

    public void execute() {
        this.traceBegin("execute()");
        this.initPerformanceTimers();
        this.otherTimer.start();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Executing transformation on:");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"Cyber-physical system: ");
        String _identifier = this.mapping.getCps().getIdentifier();
        _builder.append((Object)_identifier, "\t");
        this.logger.info((Object)_builder);
        this.clearModelPerformance.start();
        this.mapping.getTraces().clear();
        this.mapping.getDeployment().getHosts().clear();
        this.mappingCache.clear();
        this.reverseMappingCache.clear();
        this.clearModelPerformance.stop();
        Functions.Function1<HostType, EList<HostInstance>> _function = new Functions.Function1<HostType, EList<HostInstance>>(){

            public EList<HostInstance> apply(HostType it) {
                return it.getInstances();
            }
        };
        Iterable hosts = Iterables.concat((Iterable)ListExtensions.map((List)this.mapping.getCps().getHostTypes(), (Functions.Function1)_function));
        Functions.Function1<HostInstance, DeploymentHost> _function_1 = new Functions.Function1<HostInstance, DeploymentHost>(){

            public DeploymentHost apply(HostInstance it) {
                return CPS2DeploymentBatchTransformationOptimized.this.transform(it);
            }
        };
        Iterable deploymentHosts = IterableExtensions.map((Iterable)hosts, (Functions.Function1)_function_1);
        EList _hosts = this.mapping.getDeployment().getHosts();
        Iterables.addAll((Collection)_hosts, (Iterable)deploymentHosts);
        Functions.Function1<CPS2DeploymentTrace, Boolean> _function_2 = new Functions.Function1<CPS2DeploymentTrace, Boolean>(){

            public Boolean apply(CPS2DeploymentTrace it) {
                Identifiable _head = (Identifiable)IterableExtensions.head((Iterable)it.getCpsElements());
                return _head instanceof Transition;
            }
        };
        Procedures.Procedure1<CPS2DeploymentTrace> _function_3 = new Procedures.Procedure1<CPS2DeploymentTrace>(){

            public void apply(CPS2DeploymentTrace it) {
                CPS2DeploymentBatchTransformationOptimized.this.createTransitionCache(it);
            }
        };
        IterableExtensions.forEach((Iterable)IterableExtensions.filter((Iterable)this.mapping.getTraces(), (Functions.Function1)_function_2), (Procedures.Procedure1)_function_3);
        this.assignTriggers();
        this.otherTimer.stop();
        this.traceEnd("execute()");
        this.reportPerformance();
    }

    private void assignTriggers() {
        this.traceBegin("assignTriggers()");
        this.triggerTransformationPerformance.start();
        Functions.Function1<CPS2DeploymentTrace, Boolean> _function = new Functions.Function1<CPS2DeploymentTrace, Boolean>(){

            public Boolean apply(CPS2DeploymentTrace it) {
                DeploymentElement _head = (DeploymentElement)IterableExtensions.head((Iterable)it.getDeploymentElements());
                return _head instanceof BehaviorTransition;
            }
        };
        Iterable transitionMappings = IterableExtensions.filter((Iterable)this.mapping.getTraces(), (Functions.Function1)_function);
        Functions.Function1<CPS2DeploymentTrace, Boolean> _function_1 = new Functions.Function1<CPS2DeploymentTrace, Boolean>(){

            public Boolean apply(CPS2DeploymentTrace it) {
                return CPS2DeploymentBatchTransformationOptimized.this.isTraceForSender(it);
            }
        };
        Iterable senderTransitionMappings = IterableExtensions.filter((Iterable)transitionMappings, (Functions.Function1)_function_1);
        Procedures.Procedure1<CPS2DeploymentTrace> _function_2 = new Procedures.Procedure1<CPS2DeploymentTrace>(){

            public void apply(CPS2DeploymentTrace it) {
                CPS2DeploymentBatchTransformationOptimized.this.findAndAssignReceivers(it);
            }
        };
        IterableExtensions.forEach((Iterable)senderTransitionMappings, (Procedures.Procedure1)_function_2);
        this.triggerTransformationPerformance.stop();
        this.traceEnd("assignTriggers()");
    }

    private void findAndAssignReceivers(final CPS2DeploymentTrace senderTrace) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"findReceivers(");
        String _name = NamingUtil.name((EObject)senderTrace);
        _builder.append((Object)_name);
        _builder.append((Object)")");
        this.traceBegin(_builder.toString());
        Functions.Function1<CPS2DeploymentTrace, Boolean> _function = new Functions.Function1<CPS2DeploymentTrace, Boolean>(){

            public Boolean apply(CPS2DeploymentTrace it) {
                DeploymentElement _head = (DeploymentElement)IterableExtensions.head((Iterable)it.getDeploymentElements());
                return _head instanceof BehaviorTransition;
            }
        };
        Iterable receiverTraces = IterableExtensions.filter((Iterable)this.mapping.getTraces(), (Functions.Function1)_function);
        Procedures.Procedure1<CPS2DeploymentTrace> _function_1 = new Procedures.Procedure1<CPS2DeploymentTrace>(){

            public void apply(CPS2DeploymentTrace it) {
                CPS2DeploymentBatchTransformationOptimized.this.setTriggerIfConnected(it, senderTrace);
            }
        };
        IterableExtensions.forEach((Iterable)receiverTraces, (Procedures.Procedure1)_function_1);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"findReceivers(");
        String _name_1 = NamingUtil.name((EObject)senderTrace);
        _builder_1.append((Object)_name_1);
        _builder_1.append((Object)")");
        this.traceEnd(_builder_1.toString());
    }

    private void createTransitionCache(CPS2DeploymentTrace transitionTrace) {
        this.transitionMappingCachingPerformance.start();
        Identifiable _head = (Identifiable)IterableExtensions.head((Iterable)transitionTrace.getCpsElements());
        Transition transition = (Transition)_head;
        String _action = transition.getAction();
        boolean _equals = Objects.equal((Object)_action, null);
        if (_equals) {
            this.transitionMappingCachingPerformance.stop();
            return;
        }
        String actionId = SignalUtil.getSignalId((String)transition.getAction());
        EList _deploymentElements = transitionTrace.getDeploymentElements();
        for (DeploymentElement i : _deploymentElements) {
            BehaviorTransition behaviorTransition = (BehaviorTransition)i;
            EObject _eContainer = behaviorTransition.eContainer().eContainer();
            DeploymentApplication deploymentApp = (DeploymentApplication)_eContainer;
            EObject _eContainer_1 = deploymentApp.eContainer();
            DeploymentHost deploymentHost = (DeploymentHost)_eContainer_1;
            Identifiable _get = this.reverseMappingCache.get(deploymentHost);
            HostInstance hostInstance = (HostInstance)_get;
            Identifiable _get_1 = this.reverseMappingCache.get(deploymentApp);
            ApplicationInstance appInstance = (ApplicationInstance)_get_1;
            String appTypeId = appInstance.getType().getIdentifier();
            this.transitionToAppId.put(behaviorTransition, appTypeId);
            this.transitionToActionId.put(behaviorTransition, actionId);
            this.transitionToHost.put(behaviorTransition, hostInstance);
        }
        this.transitionMappingCachingPerformance.stop();
    }

    private void setTriggerIfConnected(CPS2DeploymentTrace receiverTrace, CPS2DeploymentTrace senderTrace) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"setTriggerIfConnected(");
        String _name = NamingUtil.name((EObject)receiverTrace);
        _builder.append((Object)_name);
        _builder.append((Object)",");
        String _name_1 = NamingUtil.name((EObject)senderTrace);
        _builder.append((Object)_name_1);
        _builder.append((Object)")");
        this.traceBegin(_builder.toString());
        boolean _isTraceForReceiver = this.isTraceForReceiver(receiverTrace);
        boolean bl = _not = !_isTraceForReceiver;
        if (_not) {
            return;
        }
        HashMap senderReceiverMappings = Maps.newHashMap();
        EList _deploymentElements = receiverTrace.getDeploymentElements();
        for (DeploymentElement sender : _deploymentElements) {
            senderReceiverMappings.put((BehaviorTransition)sender, receiverTrace.getDeploymentElements());
        }
        EList _deploymentElements_1 = receiverTrace.getDeploymentElements();
        for (DeploymentElement i : _deploymentElements_1) {
            BehaviorTransition receiverBehaviorTransition = (BehaviorTransition)i;
            Object appTypeId = this.transitionToAppId.get(receiverBehaviorTransition);
            Identifiable _head = (Identifiable)IterableExtensions.head((Iterable)senderTrace.getCpsElements());
            Transition senderTransition = (Transition)_head;
            String targetAppId = SignalUtil.getAppId((String)senderTransition.getAction());
            HostInstance receiverHostInstance = this.transitionToHost.get(receiverBehaviorTransition);
            this.transitionToActionId.get(receiverBehaviorTransition);
            Object receiverSignalId = this.transitionToActionId.get(receiverBehaviorTransition);
            EList _deploymentElements_2 = senderTrace.getDeploymentElements();
            for (DeploymentElement j : _deploymentElements_2) {
                boolean _isConnectedTo;
                BehaviorTransition senderBehaviorTransition = (BehaviorTransition)j;
                Object senderSignalId = this.transitionToActionId.get(senderBehaviorTransition);
                HostInstance senderHostInstance = this.transitionToHost.get(senderBehaviorTransition);
                if (!Objects.equal((Object)appTypeId, (Object)targetAppId) || !Objects.equal((Object)receiverSignalId, (Object)senderSignalId) || !(_isConnectedTo = this.isConnectedTo(senderHostInstance, receiverHostInstance))) continue;
                BehaviorTransition sender_1 = senderBehaviorTransition;
                BehaviorTransition receiver = receiverBehaviorTransition;
                EList _trigger = sender_1.getTrigger();
                _trigger.add((Object)receiver);
            }
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"setTriggerIfConnected(");
        String _name_2 = NamingUtil.name((EObject)receiverTrace);
        _builder_1.append((Object)_name_2);
        _builder_1.append((Object)",");
        String _name_3 = NamingUtil.name((EObject)senderTrace);
        _builder_1.append((Object)_name_3);
        _builder_1.append((Object)")");
        this.traceEnd(_builder_1.toString());
    }

    private boolean isTraceForSender(CPS2DeploymentTrace trace) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"isTraceForSender");
        String _name = NamingUtil.name((EObject)trace);
        _builder.append((Object)_name);
        this.traceBegin(_builder.toString());
        boolean isSender = false;
        EList elements = trace.getCpsElements();
        for (Identifiable t : elements) {
            boolean bl = isSender = isSender || this.isTransitionSender((Transition)t);
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"isTraceForSender");
        String _name_1 = NamingUtil.name((EObject)trace);
        _builder_1.append((Object)_name_1);
        this.traceEnd(_builder_1.toString());
        return isSender;
    }

    private boolean isTransitionSender(Transition transition) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"isTransitionSender(");
        String _name = NamingUtil.name((EObject)transition);
        _builder.append((Object)_name);
        _builder.append((Object)")");
        this.traceBegin(_builder.toString());
        String _action = transition.getAction();
        boolean _equals = Objects.equal((Object)_action, null);
        if (_equals) {
            return false;
        }
        boolean _isSend = SignalUtil.isSend((String)transition.getAction());
        if (_isSend) {
            return true;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"isTransitionSender(");
        String _name_1 = NamingUtil.name((EObject)transition);
        _builder_1.append((Object)_name_1);
        _builder_1.append((Object)")");
        this.traceEnd(_builder_1.toString());
        return false;
    }

    private boolean isTraceForReceiver(CPS2DeploymentTrace trace) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"isTraceForReceiver(");
        String _name = NamingUtil.name((EObject)trace);
        _builder.append((Object)_name);
        _builder.append((Object)")");
        this.traceBegin(_builder.toString());
        boolean isReceiver = false;
        EList elements = trace.getCpsElements();
        for (Identifiable t : elements) {
            boolean bl = isReceiver = isReceiver || this.isTransitionReceiver((Transition)t);
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"isTraceForReceiver(");
        String _name_1 = NamingUtil.name((EObject)trace);
        _builder_1.append((Object)_name_1);
        _builder_1.append((Object)")");
        this.traceEnd(_builder_1.toString());
        return isReceiver;
    }

    private boolean isTransitionReceiver(Transition transition) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"isTransitionReceiver(");
        String _name = NamingUtil.name((EObject)transition);
        _builder.append((Object)_name);
        _builder.append((Object)")");
        this.traceBegin(_builder.toString());
        String _action = transition.getAction();
        boolean _equals = Objects.equal((Object)_action, null);
        if (_equals) {
            return false;
        }
        boolean _isWait = SignalUtil.isWait((String)transition.getAction());
        if (_isWait) {
            return true;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"isTransitionReceiver(");
        String _name_1 = NamingUtil.name((EObject)transition);
        _builder_1.append((Object)_name_1);
        _builder_1.append((Object)")");
        this.traceEnd(_builder_1.toString());
        return false;
    }

    private boolean isConnectedTo(HostInstance src, HostInstance dst) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"isConnectedTo(");
        String _name = NamingUtil.name((EObject)src);
        _builder.append((Object)_name);
        _builder.append((Object)", ");
        String _name_1 = NamingUtil.name((EObject)dst);
        _builder.append((Object)_name_1);
        _builder.append((Object)")");
        this.traceBegin(_builder.toString());
        boolean communicates = Objects.equal((Object)src, (Object)dst) || src.getCommunicateWith().contains((Object)dst);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"isConnectedTo(");
        String _name_2 = NamingUtil.name((EObject)src);
        _builder_1.append((Object)_name_2);
        _builder_1.append((Object)", ");
        String _name_3 = NamingUtil.name((EObject)dst);
        _builder_1.append((Object)_name_3);
        _builder_1.append((Object)")");
        this.traceEnd(_builder_1.toString());
        return communicates;
    }

    private DeploymentHost transform(HostInstance hostInstance) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"transform(");
        String _name = NamingUtil.name((EObject)hostInstance);
        _builder.append((Object)_name);
        _builder.append((Object)")");
        this.traceBegin(_builder.toString());
        this.hostTransformationPerformance.start();
        DeploymentHost deploymentHost = DeploymentFactory.eINSTANCE.createDeploymentHost();
        deploymentHost.setIp(hostInstance.getNodeIp());
        this.createOrAddTrace((Identifiable)hostInstance, (DeploymentElement)deploymentHost);
        this.hostTransformationPerformance.stop();
        Functions.Function1<ApplicationInstance, Boolean> _function = new Functions.Function1<ApplicationInstance, Boolean>(){

            public Boolean apply(ApplicationInstance it) {
                ApplicationType _type = it.getType();
                CyberPhysicalSystem _cps = null;
                if (_type != null) {
                    _cps = _type.getCps();
                }
                CyberPhysicalSystem _cps_1 = CPS2DeploymentBatchTransformationOptimized.this.mapping.getCps();
                return Objects.equal((Object)_cps, (Object)_cps_1);
            }
        };
        Iterable liveApplications = IterableExtensions.filter((Iterable)hostInstance.getApplications(), (Functions.Function1)_function);
        Functions.Function1<ApplicationInstance, DeploymentApplication> _function_1 = new Functions.Function1<ApplicationInstance, DeploymentApplication>(){

            public DeploymentApplication apply(ApplicationInstance it) {
                return CPS2DeploymentBatchTransformationOptimized.this.transform(it);
            }
        };
        Iterable deploymentApps = IterableExtensions.map((Iterable)liveApplications, (Functions.Function1)_function_1);
        EList _applications = deploymentHost.getApplications();
        Iterables.addAll((Collection)_applications, (Iterable)deploymentApps);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"transform(");
        String _name_1 = NamingUtil.name((EObject)hostInstance);
        _builder_1.append((Object)_name_1);
        _builder_1.append((Object)")");
        this.traceEnd(_builder_1.toString());
        return deploymentHost;
    }

    private DeploymentApplication transform(ApplicationInstance appInstance) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"transform(");
        String _name = NamingUtil.name((EObject)appInstance);
        _builder.append((Object)_name);
        _builder.append((Object)")");
        this.traceBegin(_builder.toString());
        this.appTransformationPerformance.start();
        DeploymentApplication deploymentApp = DeploymentFactory.eINSTANCE.createDeploymentApplication();
        deploymentApp.setId(appInstance.getIdentifier());
        this.createOrAddTrace((Identifiable)appInstance, (DeploymentElement)deploymentApp);
        this.appTransformationPerformance.stop();
        StateMachine _behavior = appInstance.getType().getBehavior();
        boolean bl = _notEquals = !Objects.equal((Object)_behavior, null);
        if (_notEquals) {
            deploymentApp.setBehavior(this.transform(appInstance.getType().getBehavior()));
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"transform(");
        String _name_1 = NamingUtil.name((EObject)appInstance);
        _builder_1.append((Object)_name_1);
        _builder_1.append((Object)")");
        this.traceEnd(_builder_1.toString());
        return deploymentApp;
    }

    private DeploymentBehavior transform(StateMachine stateMachine) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"transform(");
        String _name = NamingUtil.name((EObject)stateMachine);
        _builder.append((Object)_name);
        _builder.append((Object)")");
        this.traceBegin(_builder.toString());
        this.stateMachineTransformationPerformance.start();
        final DeploymentBehavior behavior = DeploymentFactory.eINSTANCE.createDeploymentBehavior();
        behavior.setDescription(stateMachine.getIdentifier());
        this.createOrAddTrace((Identifiable)stateMachine, (DeploymentElement)behavior);
        this.stateMachineTransformationPerformance.stop();
        Functions.Function1<State, BehaviorState> _function = new Functions.Function1<State, BehaviorState>(){

            public BehaviorState apply(State it) {
                return CPS2DeploymentBatchTransformationOptimized.this.transform(it);
            }
        };
        List behaviorStates = ListExtensions.map((List)stateMachine.getStates(), (Functions.Function1)_function);
        EList _states = behavior.getStates();
        Iterables.addAll((Collection)_states, (Iterable)behaviorStates);
        ArrayList behaviorTransitions = new ArrayList();
        EList _states_1 = stateMachine.getStates();
        for (State state : _states_1) {
            Functions.Function1<DeploymentElement, Boolean> _function_1 = new Functions.Function1<DeploymentElement, Boolean>(){

                public Boolean apply(DeploymentElement it) {
                    return behavior.getStates().contains((Object)it);
                }
            };
            DeploymentElement _findFirst = (DeploymentElement)IterableExtensions.findFirst((Iterable)this.mappingCache.get((Object)state), (Functions.Function1)_function_1);
            final BehaviorState parentBehaviorState = (BehaviorState)_findFirst;
            Functions.Function1<Transition, Boolean> _function_2 = new Functions.Function1<Transition, Boolean>(){

                public Boolean apply(Transition it) {
                    State _targetState = it.getTargetState();
                    return !Objects.equal((Object)_targetState, null);
                }
            };
            Functions.Function1<Transition, Boolean> _function_3 = new Functions.Function1<Transition, Boolean>(){

                public Boolean apply(Transition transition) {
                    return !Objects.equal((Object)CPS2DeploymentBatchTransformationOptimized.this.mappingCache.get((Object)transition.getTargetState()), null) && !Objects.equal((Object)transition.getTargetState().eContainer(), null);
                }
            };
            Functions.Function1<Transition, BehaviorTransition> _function_4 = new Functions.Function1<Transition, BehaviorTransition>(){

                public BehaviorTransition apply(Transition it) {
                    return CPS2DeploymentBatchTransformationOptimized.this.transform(it, parentBehaviorState);
                }
            };
            Iterables.addAll(behaviorTransitions, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)state.getOutgoingTransitions(), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4));
        }
        this.stateMachineTransformationPerformance.start();
        EList _transitions = behavior.getTransitions();
        Iterables.addAll((Collection)_transitions, behaviorTransitions);
        this.setCurrentState(stateMachine, behavior);
        this.stateMachineTransformationPerformance.stop();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"transform(");
        String _name_1 = NamingUtil.name((EObject)stateMachine);
        _builder_1.append((Object)_name_1);
        _builder_1.append((Object)")");
        this.traceEnd(_builder_1.toString());
        return behavior;
    }

    private BehaviorState transform(State state) {
        BehaviorState _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"transform(");
        String _name = NamingUtil.name((EObject)state);
        _builder.append((Object)_name);
        _builder.append((Object)")");
        this.traceBegin(_builder.toString());
        this.stateTransformationPerformance.start();
        BehaviorState behaviorState = DeploymentFactory.eINSTANCE.createBehaviorState();
        behaviorState.setDescription(state.getIdentifier());
        this.createOrAddTrace((Identifiable)state, (DeploymentElement)behaviorState);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"transform(");
        String _name_1 = NamingUtil.name((EObject)state);
        _builder_1.append((Object)_name_1);
        _builder_1.append((Object)")");
        this.traceEnd(_builder_1.toString());
        this.stateTransformationPerformance.stop();
        _xblockexpression = behaviorState;
        return _xblockexpression;
    }

    private BehaviorTransition transform(Transition transition, final BehaviorState behaviorState) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"transform(");
        String _name = NamingUtil.name((EObject)transition);
        _builder.append((Object)_name);
        _builder.append((Object)", ");
        String _name_1 = NamingUtil.name((EObject)behaviorState);
        _builder.append((Object)_name_1);
        _builder.append((Object)")");
        this.traceBegin(_builder.toString());
        this.transitionTransformationPerformance.start();
        BehaviorTransition behaviorTransition = DeploymentFactory.eINSTANCE.createBehaviorTransition();
        Set dep = this.mappingCache.get((Object)transition.getTargetState());
        Functions.Function1<BehaviorState, Boolean> _function = new Functions.Function1<BehaviorState, Boolean>(){

            public Boolean apply(BehaviorState it) {
                return it.eContainer().equals(behaviorState.eContainer());
            }
        };
        BehaviorState targetBehaviorState = (BehaviorState)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)dep, BehaviorState.class), (Functions.Function1)_function);
        behaviorTransition.setTo(targetBehaviorState);
        EList _outgoing = behaviorState.getOutgoing();
        _outgoing.add((Object)behaviorTransition);
        behaviorTransition.setDescription(transition.getIdentifier());
        this.createOrAddTrace((Identifiable)transition, (DeploymentElement)behaviorTransition);
        this.transitionTransformationPerformance.stop();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"transform(");
        String _name_2 = NamingUtil.name((EObject)transition);
        _builder_1.append((Object)_name_2);
        _builder_1.append((Object)", ");
        String _name_3 = NamingUtil.name((EObject)behaviorState);
        _builder_1.append((Object)_name_3);
        _builder_1.append((Object)")");
        this.traceEnd(_builder_1.toString());
        return behaviorTransition;
    }

    private void setCurrentState(StateMachine stateMachine, final DeploymentBehavior behavior) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"transform(");
        String _name = NamingUtil.name((EObject)stateMachine);
        _builder.append((Object)_name);
        _builder.append((Object)", ");
        String _name_1 = NamingUtil.name((EObject)behavior);
        _builder.append((Object)_name_1);
        _builder.append((Object)")");
        this.traceBegin(_builder.toString());
        State initial = stateMachine.getInitial();
        boolean bl = _notEquals = !Objects.equal((Object)initial, null);
        if (_notEquals) {
            Functions.Function1<DeploymentElement, Boolean> _function = new Functions.Function1<DeploymentElement, Boolean>(){

                public Boolean apply(DeploymentElement it) {
                    return behavior.getStates().contains((Object)it);
                }
            };
            DeploymentElement initialBehaviorState = (DeploymentElement)IterableExtensions.findFirst((Iterable)this.mappingCache.get((Object)initial), (Functions.Function1)_function);
            behavior.setCurrent((BehaviorState)initialBehaviorState);
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"transform(");
        String _name_2 = NamingUtil.name((EObject)stateMachine);
        _builder_1.append((Object)_name_2);
        _builder_1.append((Object)", ");
        String _name_3 = NamingUtil.name((EObject)behavior);
        _builder_1.append((Object)_name_3);
        _builder_1.append((Object)")");
        this.traceEnd(_builder_1.toString());
    }

    private CPS2DeploymentTrace createOrAddTrace(final Identifiable identifiable, DeploymentElement deploymentElement) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"createOrAddTrace(");
        String _name = NamingUtil.name((EObject)identifiable);
        _builder.append((Object)_name);
        _builder.append((Object)", ");
        String _name_1 = NamingUtil.name((EObject)deploymentElement);
        _builder.append((Object)_name_1);
        _builder.append((Object)")");
        this.traceBegin(_builder.toString());
        Functions.Function1<CPS2DeploymentTrace, Boolean> _function = new Functions.Function1<CPS2DeploymentTrace, Boolean>(){

            public Boolean apply(CPS2DeploymentTrace it) {
                return it.getCpsElements().contains((Object)identifiable);
            }
        };
        Iterable trace = IterableExtensions.filter((Iterable)this.mapping.getTraces(), (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)trace);
        if (_isEmpty) {
            return this.createTrace(identifiable, deploymentElement);
        }
        EList _deploymentElements = ((CPS2DeploymentTrace)IterableExtensions.head((Iterable)trace)).getDeploymentElements();
        _deploymentElements.add((Object)deploymentElement);
        this.mappingCache.put((Object)identifiable, (Object)deploymentElement);
        this.reverseMappingCache.put(deploymentElement, identifiable);
        boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)IterableExtensions.tail((Iterable)trace));
        boolean bl = _not = !_isEmpty_1;
        if (_not) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"More than one mapping was created to state machine with Id '");
            String _identifier = identifiable.getIdentifier();
            _builder_1.append((Object)_identifier);
            _builder_1.append((Object)"'.");
            throw new IllegalStateException(_builder_1.toString());
        }
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append((Object)"createOrAddTrace(");
        String _name_2 = NamingUtil.name((EObject)identifiable);
        _builder_2.append((Object)_name_2);
        _builder_2.append((Object)", ");
        String _name_3 = NamingUtil.name((EObject)deploymentElement);
        _builder_2.append((Object)_name_3);
        _builder_2.append((Object)")");
        this.traceEnd(_builder_2.toString());
        return (CPS2DeploymentTrace)IterableExtensions.head((Iterable)trace);
    }

    private CPS2DeploymentTrace createTrace(Identifiable identifiable, DeploymentElement deploymentElement) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"createTrace(");
        String _name = NamingUtil.name((EObject)identifiable);
        _builder.append((Object)_name);
        _builder.append((Object)", ");
        String _name_1 = NamingUtil.name((EObject)deploymentElement);
        _builder.append((Object)_name_1);
        _builder.append((Object)")");
        this.traceBegin(_builder.toString());
        CPS2DeploymentTrace trace = TraceabilityFactory.eINSTANCE.createCPS2DeploymentTrace();
        EList _cpsElements = trace.getCpsElements();
        _cpsElements.add((Object)identifiable);
        EList _deploymentElements = trace.getDeploymentElements();
        _deploymentElements.add((Object)deploymentElement);
        EList _traces = this.mapping.getTraces();
        _traces.add((Object)trace);
        this.mappingCache.put((Object)identifiable, (Object)deploymentElement);
        this.reverseMappingCache.put(deploymentElement, identifiable);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"createTrace(");
        String _name_2 = NamingUtil.name((EObject)identifiable);
        _builder_1.append((Object)_name_2);
        _builder_1.append((Object)", ");
        String _name_3 = NamingUtil.name((EObject)deploymentElement);
        _builder_1.append((Object)_name_3);
        _builder_1.append((Object)")");
        this.traceBegin(_builder_1.toString());
        return trace;
    }

    public void dispose() {
        this.traceBegin("dispose()");
        this.traceEnd("dispose()");
    }
}

