/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.ui.util;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.viatra.transformation.debug.model.breakpoint.ConditionalTransformationBreakpoint;
import org.eclipse.viatra.transformation.debug.model.breakpoint.RuleBreakpoint;
import org.eclipse.viatra.transformation.debug.ui.activator.TransformationDebugUIActivator;

public class BreakpointCacheUtil {
    public static String BKP_CACHE_NAME = "/persistentbreakpoints.bpkt";

    public static String getBreakpointCacheLocation() {
        TransformationDebugUIActivator activator = new TransformationDebugUIActivator();
        IPath stateLocation = activator.getStateLocation();
        String location = stateLocation.toString();
        String fileLocation = String.valueOf(location) + BKP_CACHE_NAME;
        return fileLocation;
    }

    public static boolean breakpointCacheExists() {
        File file = new File(BreakpointCacheUtil.getBreakpointCacheLocation());
        return file.exists();
    }

    public static IBreakpoint[] filterBreakpoints(IBreakpoint[] iBreakpoints) {
        ArrayList ret = Lists.newArrayList();
        IBreakpoint[] iBreakpointArray = iBreakpoints;
        int n = iBreakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof RuleBreakpoint || breakpoint instanceof ConditionalTransformationBreakpoint) {
                ret.add(breakpoint);
            }
            ++n2;
        }
        return ret.toArray(new IBreakpoint[ret.size()]);
    }
}

