/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.core.OverflowingLRUCache;
import org.eclipse.jdt.internal.core.util.LRUCache;
import org.eclipse.pde.api.tools.internal.model.ApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;

public final class ApiModelCache {
    static final int DEFAULT_CACHE_SIZE = 1500;
    static final int DEFAULT_OVERFLOW = 150;
    static ApiModelCache fInstance = null;
    Cache fRootCache = null;
    Cache fMemberTypeCache = null;

    private ApiModelCache() {
    }

    public static synchronized ApiModelCache getCache() {
        if (fInstance == null) {
            fInstance = new ApiModelCache();
        }
        return fInstance;
    }

    private String getCacheKey(String baseline, String component, String typename) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(baseline).append('.').append(component).append('.').append(typename);
        return buffer.toString();
    }

    public void cacheElementInfo(IApiElement element) throws CoreException {
        switch (element.getType()) {
            case 2: {
                ApiType type;
                Cache typecache;
                IApiComponent comp;
                if (this.fRootCache == null) {
                    this.fRootCache = new Cache(150, 15);
                }
                if ((comp = element.getApiComponent()) == null) break;
                IApiBaseline baseline = comp.getBaseline();
                String id = comp.getSymbolicName();
                if (id == null) {
                    return;
                }
                Cache compcache = (Cache)((Object)this.fRootCache.get(baseline.getName()));
                if (compcache == null) {
                    compcache = new Cache(750, 75);
                    this.fRootCache.put(baseline.getName(), (Object)compcache);
                }
                if ((typecache = (Cache)((Object)compcache.get(id))) == null) {
                    typecache = new Cache(1500, 150);
                    compcache.put(comp.getSymbolicName(), (Object)typecache);
                }
                if ((type = (ApiType)element).isMemberType() || this.isMemberType(type.getName())) {
                    String key;
                    Cache mcache;
                    if (this.fMemberTypeCache == null) {
                        this.fMemberTypeCache = new Cache(1500, 150);
                    }
                    if ((mcache = (Cache)((Object)this.fMemberTypeCache.get(key = this.getCacheKey(baseline.getName(), id, this.getRootName(type.getName()))))) == null) {
                        mcache = new Cache(1500, 150);
                        this.fMemberTypeCache.put(key, (Object)mcache);
                    }
                    mcache.put(type.getName(), type);
                    break;
                }
                typecache.put(element.getName(), element);
                break;
            }
        }
    }

    private String getRootName(String typename) {
        int idx = typename.indexOf(36);
        if (idx > -1) {
            return typename.substring(0, idx);
        }
        return typename;
    }

    private boolean isMemberType(String typename) {
        return typename.indexOf(36) > -1;
    }

    public IApiElement getElementInfo(String baselineid, String componentid, String identifier, int type) {
        if (baselineid == null || componentid == null) {
            return null;
        }
        switch (type) {
            case 2: {
                Cache typecache;
                Cache compcache;
                if (this.isMemberType(identifier)) {
                    Cache mcache;
                    if (this.fMemberTypeCache == null || (mcache = (Cache)((Object)this.fMemberTypeCache.get(this.getCacheKey(baselineid, componentid, this.getRootName(identifier))))) == null) break;
                    return (IApiElement)mcache.get(identifier);
                }
                if (this.fRootCache == null || (compcache = (Cache)((Object)this.fRootCache.get(baselineid))) == null || (typecache = (Cache)((Object)compcache.get(componentid))) == null || identifier == null) break;
                return (IApiElement)typecache.get(identifier);
            }
        }
        return null;
    }

    public boolean removeElementInfo(String baselineid, String componentid, String identifier, int type) {
        if (baselineid == null) {
            return false;
        }
        switch (type) {
            case 2: {
                if (componentid == null || identifier == null) break;
                boolean removed = true;
                if (this.fMemberTypeCache != null) {
                    if (this.isMemberType(identifier)) {
                        Cache mcache = (Cache)((Object)this.fMemberTypeCache.get(this.getCacheKey(baselineid, componentid, this.getRootName(identifier))));
                        if (mcache != null) {
                            return mcache.remove(identifier) != null;
                        }
                    } else {
                        this.fMemberTypeCache.remove(this.getCacheKey(baselineid, componentid, this.getRootName(identifier)));
                    }
                }
                if (this.fRootCache != null) {
                    Cache typecache;
                    Cache compcache = (Cache)((Object)this.fRootCache.get(baselineid));
                    if (compcache == null || (typecache = (Cache)((Object)compcache.get(componentid))) == null) break;
                    removed &= typecache.remove(identifier) != null;
                    if (typecache.isEmpty()) {
                        removed &= compcache.remove(componentid) != null;
                    }
                    if (compcache.isEmpty()) {
                        removed &= this.fRootCache.remove(baselineid) != null;
                    }
                    return removed;
                }
                return false;
            }
            case 1: {
                boolean removed;
                Cache compcache;
                this.flushMemberCache();
                if (this.fRootCache == null || componentid == null || (compcache = (Cache)((Object)this.fRootCache.get(baselineid))) == null) break;
                boolean bl = removed = compcache.remove(componentid) != null;
                if (compcache.isEmpty()) {
                    removed &= this.fRootCache.remove(baselineid) != null;
                }
                return removed;
            }
            case 4: {
                this.flushMemberCache();
                if (this.fRootCache == null) break;
                return this.fRootCache.remove(baselineid) != null;
            }
        }
        return false;
    }

    public boolean removeElementInfo(IApiElement element) {
        if (element == null) {
            return false;
        }
        switch (element.getType()) {
            case 1: 
            case 2: {
                IApiComponent comp;
                if (this.fRootCache == null || (comp = element.getApiComponent()) == null) break;
                try {
                    IApiBaseline baseline = comp.getBaseline();
                    return this.removeElementInfo(baseline.getName(), comp.getSymbolicName(), element.getName(), element.getType());
                }
                catch (CoreException coreException) {
                    break;
                }
            }
            case 4: {
                this.flushMemberCache();
                if (this.fRootCache == null) break;
                IApiBaseline baseline = (IApiBaseline)element;
                return this.fRootCache.remove(baseline.getName()) != null;
            }
        }
        return false;
    }

    public void flushCaches() {
        if (this.fRootCache != null) {
            this.fRootCache.flush();
        }
        this.flushMemberCache();
    }

    private void flushMemberCache() {
        if (this.fMemberTypeCache != null) {
            this.fMemberTypeCache.flush();
        }
    }

    public boolean isEmpty() {
        boolean empty = true;
        if (this.fRootCache != null) {
            empty &= this.fRootCache.isEmpty();
        }
        if (this.fMemberTypeCache != null) {
            empty &= this.fMemberTypeCache.isEmpty();
        }
        return empty;
    }

    class Cache
    extends OverflowingLRUCache {
        public Cache(int size, int overflow) {
            super(size, overflow);
        }

        protected boolean close(LRUCache.LRUCacheEntry entry) {
            return true;
        }

        protected LRUCache newInstance(int size, int newOverflow) {
            return new Cache(size, newOverflow);
        }

        public boolean isEmpty() {
            return !this.keys().hasMoreElements();
        }
    }
}

